#!/bin/bash

PSI=$1

NEW=2.6.9-22.0.1.EL.livecd
ARCH=$( arch ) || exit 1

echo
echo "New kernel Version: $NEW"
echo "Arch: $ARCH"

echo
if [ "$1" = "" ]; then
    echo "Usage: $( basename $0 ) -psi|-sl"; echo
    exit 1
fi

# update first
./update_software.sh $1

# save grub.conf
# will modify grub.conf manually
cp -a /boot/grub/grub.conf /boot/grub/grub.conf.bak

# install kernel
rpm -ihv kernel-$NEW.$ARCH.rpm 
rpm -q kernel-devel && rpm -ihv kernel-devel-$NEW.$ARCH.rpm

# install openafs kernel module
echo
OPENAFS_VERSION=$( rpm -q --qf "%{version}" openafs ) || exit 1
rpm -ihv kernel-module-openafs-$NEW-$OPENAFS_VERSION-*.$ARCH.rpm
if [ "$ARCH" = "i686" ]; then
    rpm -ihv kernel-module-openafs-$NEW-$OPENAFS_VERSION-*.i386.rpm
fi

# restore grub.conf
mv -f /boot/grub/grub.conf.bak /boot/grub/grub.conf

echo
echo "Run rpm -qa | grep "^kernel"  | sort"
echo
rpm -qa | grep "^kernel"  | sort
echo

