## RabbitMQ 3.7.18

RabbitMQ `3.7.18` is a maintenance release that includes a fix to [CVE-2019-11281](https://pivotal.io/security/cve-2019-11281).
Kudos to [Markus @RareData Alvila](https://twitter.com/RareData) for responsibly disclosing the vulnerability.

The release also contains bug fixes and internal
API changes that refine the common plugin API with the [upcoming `3.8.0` version](https://github.com/rabbitmq/rabbitmq-server/releases/).

### Erlang/OTP Compatibility Notes

Per the new Erlang version support policy in effect starting with January 2019,
this release [**no longer supports Erlang/OTP 19.3**](https://groups.google.com/d/msg/rabbitmq-users/G4UJ9zbIYHs/qCeyjkjyCQAJ).
Make sure a [supported Erlang version](https://www.rabbitmq.com/which-erlang.html) is used before upgrading.

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision latest patch versions of Erlang `21.3.x` and `22.x`.

### Compatibility Notes

This release introduces credential obfuscation for Shovel connections and Federation links. This requires
one more application (library) from Erlang/OTP, `tools`. Operators must make sure that the Erlang runtime
provides it. On Debian-based systems, the package [`erlang-tools`](https://packages.ubuntu.com/bionic/erlang-tools) must be installed.

This release contains a **breaking change to the plugin API** around queue state access introduced in `3.7.17`.
Plugins that do not use that API revision are not affected. All plugins that ship with RabbitMQ have been updated
as necessary.

This revision was necessary to maintain a single API with the upcoming `3.8.0` release.

#### Upgrading to Erlang 21.x or Later Versions

When upgrading to this release **and upgrading Erlang to 21.x or later** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21 or later,
RabbitMQ **must be upgraded before Erlang**.

#### Upgrade Doc Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade
and compatibility notes first if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades
and [RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

### Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the
[RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users).


## Changes

### Core Server

#### Enhancements

 * New style config file parser is now more forgiving, handles trailing whitespace and empty lines
   better.

   GitHub issue: [rabbitmq/rabbitmq-server#2073](https://github.com/rabbitmq/rabbitmq-server/pull/2073)

 * `gen_server2` now includes two new functions, `stop/1` and `stop/3`, which `gen_server` in OTP
   introduced a couple of releases ago.

   Contributed by @codeadict.

   GitHub issue: [rabbitmq/rabbitmq-common#335](https://github.com/rabbitmq/rabbitmq-common/pull/335)

#### Bug Fixes

 * Log rotation is functional again on Windows.

   GitHub issue: [rabbitmq/rabbitmq-server#2059](https://github.com/rabbitmq/rabbitmq-server/issues/2059)

 * White space characters in `RABBITMQ_BASE` and other [configurable paths](https://www.rabbitmq.com/configure.html#customise-environment) are now handled better on Windows.

   GitHub issue: [rabbitmq/rabbitmq-server#2025](https://github.com/rabbitmq/rabbitmq-server/issues/2025)

 * Eliminate a "deprecated Ranch options" log warning.

   GitHub issue: [rabbitmq/rabbitmq-server#2069](https://github.com/rabbitmq/rabbitmq-server/issues/2069)


### Management Plugin

#### Enhancements

 * Two more TLS listener options are now available via new style configuration file:
   `management.ssl.verify` and `management.ssl.fail_if_no_peer_cert`.

   GitHub issue: [rabbitmq/rabbitmq-management#735](https://github.com/rabbitmq/rabbitmq-management/issues/735)

#### Bug Fixes

 * HTTP API documentation correction.

   GitHub issue: [rabbitmq/rabbitmq-management#737](https://github.com/rabbitmq/rabbitmq-management/issues/737)


### AMQP 1.0 Plugin

#### Bug Fixes

 * Connections that fail due to insufficient client permissions (authorisation failures) are now handled
   gracefully with reasonable log messages.

   GitHub issue: [rabbitmq/rabbitmq-amqp1.0#92](https://github.com/rabbitmq/rabbitmq-amqp1.0/pull/92)


### Shovel Plugin

#### Bug Fixes

 * Sensitive values in Shovel connection state (namely, the connection credentials) are now stored in
   encrypted form. This avoids unintentional credential logging by the runtime (exception logger)
   at the cost of making troubleshooting authentication failures harder.

   GitHub issue: [rabbitmq-erlang-client#123](https://github.com/rabbitmq/rabbitmq-erlang-client/issues/123)


### Federation Plugin

#### Bug Fixes

 * Sensitive values in Federation link state (namely, the connection credentials) are now stored in
   encrypted form. This avoids unintentional credential logging by the runtime (exception logger)
   at the cost of making troubleshooting authentication failures harder.

   GitHub issue: [rabbitmq-erlang-client#123](https://github.com/rabbitmq/rabbitmq-erlang-client/issues/123)


### RabbitMQ Erlang Client

#### Bug Fixes

 * Sensitive values in connection state (namely, the connection credentials) are now stored in
   encrypted form. This avoids unintentional credential logging by the runtime (exception logger)
   at the cost of making troubleshooting authentication failures harder.

   GitHub issue: [rabbitmq-erlang-client#123](https://github.com/rabbitmq/rabbitmq-erlang-client/issues/123)


### Web STOMP Examples Plugin

#### Bug Fixes

 * jQuery was upgraded to `3.4.x`.

   GitHub issue: [rabbitmq/rabbitmq-web-stomp-examples#18](https://github.com/rabbitmq/rabbitmq-web-stomp-examples/issues/18)


### Web MQTT Examples Plugin

#### Bug Fixes

 * jQuery was upgraded to `3.4.x`.

   GitHub issue: [rabbitmq/rabbitmq-web-mqtt-examples#2](https://github.com/rabbitmq/rabbitmq-web-mqtt-examples/issues/2)


## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-server-3.7.18.tar.xz`.
