/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a#\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u0082\u0002\n\n\b\b\u0002\u001a\u0004\u0010\u0000(\u0000\u001a\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\b\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\t\u001a\u00020\u0007*\u00020\u0002\u001a\u001a\u0010\u0010\u001a\u00020\u0007*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0002\"\u0017\u0010\n\u001a\u0004\u0018\u00010\u0002*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u0002*\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00f2\u0001\u0004\n\u00020\u0005\u00a8\u0006\u0014"}, d2={"classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "isKProperty", "", "isKMutableProperty", "isKClassType", "returnType", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "getReturnType", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "receiverType", "getReceiverType", "isTypeMismatchDueToNullability", "Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;", "actualType", "expectedType", "providers"})
@SourceDebugExtension(value={"SMAP\nInferenceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InferenceUtils.kt\norg/jetbrains/kotlin/fir/types/InferenceUtilsKt\n+ 2 FirTypeUtils.kt\norg/jetbrains/kotlin/fir/types/FirTypeUtilsKt\n*L\n1#1,55:1\n28#2:56\n28#2:57\n*S KotlinDebug\n*F\n+ 1 InferenceUtils.kt\norg/jetbrains/kotlin/fir/types/InferenceUtilsKt\n*L\n42#1:56\n43#1:57\n*E\n"})
public final class InferenceUtilsKt {
    private static final ClassId classId(ConeKotlinType $this$classId, FirSession session) {
        if (!($this$classId instanceof ConeClassLikeType)) {
            return null;
        }
        return TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$classId, session, null, 2, null).getLookupTag().getClassId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKProperty(@NotNull ConeKotlinType $this$isKProperty, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isKProperty, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        ClassId classId = InferenceUtilsKt.classId($this$isKProperty, session);
        if (classId == null) {
            return false;
        }
        ClassId classId2 = classId;
        if (!Intrinsics.areEqual(classId2.getPackageFqName(), StandardClassIds.INSTANCE.getBASE_REFLECT_PACKAGE())) return false;
        String string = classId2.getShortClassName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue(string, "getIdentifier(...)");
        if (!StringsKt.startsWith$default(string, "KProperty", false, 2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKMutableProperty(@NotNull ConeKotlinType $this$isKMutableProperty, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isKMutableProperty, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        ClassId classId = InferenceUtilsKt.classId($this$isKMutableProperty, session);
        if (classId == null) {
            return false;
        }
        ClassId classId2 = classId;
        if (!Intrinsics.areEqual(classId2.getPackageFqName(), StandardClassIds.INSTANCE.getBASE_REFLECT_PACKAGE())) return false;
        String string = classId2.getShortClassName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue(string, "getIdentifier(...)");
        if (!StringsKt.startsWith$default(string, "KMutableProperty", false, 2, null)) return false;
        return true;
    }

    public static final boolean isKClassType(@NotNull ConeKotlinType $this$isKClassType) {
        Intrinsics.checkNotNullParameter($this$isKClassType, "<this>");
        return Intrinsics.areEqual(ConeTypeUtilsKt.getClassId($this$isKClassType), StandardClassIds.INSTANCE.getKClass());
    }

    @Nullable
    public static final ConeKotlinType getReturnType(@NotNull FirAnonymousFunction $this$returnType) {
        Intrinsics.checkNotNullParameter($this$returnType, "<this>");
        FirTypeRef $this$coneTypeSafe$iv = $this$returnType.getReturnTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    @Nullable
    public static final ConeKotlinType getReceiverType(@NotNull FirAnonymousFunction $this$receiverType) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter($this$receiverType, "<this>");
        FirPureAbstractElement firPureAbstractElement = $this$receiverType.getReceiverParameter();
        if (firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null) {
            FirPureAbstractElement $this$coneTypeSafe$iv = firPureAbstractElement;
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                coneKotlinType = null;
            }
        } else {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    public static final boolean isTypeMismatchDueToNullability(@NotNull ConeTypeContext $this$isTypeMismatchDueToNullability, @NotNull ConeKotlinType actualType, @NotNull ConeKotlinType expectedType) {
        Intrinsics.checkNotNullParameter($this$isTypeMismatchDueToNullability, "<this>");
        Intrinsics.checkNotNullParameter(actualType, "actualType");
        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
        return $this$isTypeMismatchDueToNullability.isNullableType(actualType) && !$this$isTypeMismatchDueToNullability.isNullableType(expectedType) && AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, $this$isTypeMismatchDueToNullability, (KotlinTypeMarker)actualType, (KotlinTypeMarker)TypeUtilsKt.withNullability$default(expectedType, true, $this$isTypeMismatchDueToNullability, null, false, 12, null), false, 8, null);
    }
}

