/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountedCompleter;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import jdk.internal.misc.Unsafe;
import jdk.internal.vm.annotation.Contended;

public class ForkJoinPool
extends AbstractExecutorService {
    static final int SMASK = 65535;
    static final int MAX_CAP = Short.MAX_VALUE;
    static final int EVENMASK = 65534;
    static final int SQMASK = 126;
    static final int SCANNING = 1;
    static final int INACTIVE = Integer.MIN_VALUE;
    static final int SS_SEQ = 65536;
    static final int MODE_MASK = -65536;
    static final int LIFO_QUEUE = 0;
    static final int FIFO_QUEUE = 65536;
    static final int SHARED_QUEUE = Integer.MIN_VALUE;
    public static final ForkJoinWorkerThreadFactory defaultForkJoinWorkerThreadFactory;
    private static final RuntimePermission modifyThreadPermission;
    static final ForkJoinPool common;
    static final int commonParallelism;
    private static int commonMaxSpares;
    private static int poolNumberSequence;
    private static final long IDLE_TIMEOUT = 2000000000L;
    private static final long TIMEOUT_SLOP = 20000000L;
    private static final int DEFAULT_COMMON_MAX_SPARES = 256;
    private static final int SPINS = 0;
    private static final int SEED_INCREMENT = -1640531527;
    private static final long SP_MASK = 0xFFFFFFFFL;
    private static final long UC_MASK = -4294967296L;
    private static final int AC_SHIFT = 48;
    private static final long AC_UNIT = 0x1000000000000L;
    private static final long AC_MASK = -281474976710656L;
    private static final int TC_SHIFT = 32;
    private static final long TC_UNIT = 0x100000000L;
    private static final long TC_MASK = 0xFFFF00000000L;
    private static final long ADD_WORKER = 0x800000000000L;
    private static final int RSLOCK = 1;
    private static final int RSIGNAL = 2;
    private static final int STARTED = 4;
    private static final int STOP = 0x20000000;
    private static final int TERMINATED = 0x40000000;
    private static final int SHUTDOWN = Integer.MIN_VALUE;
    volatile long ctl;
    volatile int runState;
    final int config;
    int indexSeed;
    volatile WorkQueue[] workQueues;
    final ForkJoinWorkerThreadFactory factory;
    final Thread.UncaughtExceptionHandler ueh;
    final String workerNamePrefix;
    volatile AtomicLong stealCounter;
    private static final sun.misc.Unsafe U;
    private static final int ABASE;
    private static final int ASHIFT;
    private static final long CTL;
    private static final long RUNSTATE;
    private static final long STEALCOUNTER;
    private static final long PARKBLOCKER;
    private static final long QTOP;
    private static final long QLOCK;
    private static final long QSCANSTATE;
    private static final long QPARKER;
    private static final long QCURRENTSTEAL;
    private static final long QCURRENTJOIN;

    public ForkJoinPool() {
    }

    public ForkJoinPool(int n) {
    }

    public ForkJoinPool(int n, ForkJoinWorkerThreadFactory forkJoinWorkerThreadFactory, Thread.UncaughtExceptionHandler uncaughtExceptionHandler, boolean bl) {
    }

    public static ForkJoinPool commonPool() {
        return null;
    }

    public <T> T invoke(ForkJoinTask<T> forkJoinTask) {
        return null;
    }

    public void execute(ForkJoinTask<?> forkJoinTask) {
    }

    @Override
    public void execute(Runnable runnable) {
    }

    public <T> ForkJoinTask<T> submit(ForkJoinTask<T> forkJoinTask) {
        return null;
    }

    public <T> ForkJoinTask<T> submit(Callable<T> callable) {
        return null;
    }

    public <T> ForkJoinTask<T> submit(Runnable runnable, T t) {
        return null;
    }

    public ForkJoinTask<?> submit(Runnable runnable) {
        return null;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) {
        return null;
    }

    public ForkJoinWorkerThreadFactory getFactory() {
        return null;
    }

    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return null;
    }

    public int getParallelism() {
        return 0;
    }

    public static int getCommonPoolParallelism() {
        return 0;
    }

    public int getPoolSize() {
        return 0;
    }

    public boolean getAsyncMode() {
        return false;
    }

    public int getRunningThreadCount() {
        return 0;
    }

    public int getActiveThreadCount() {
        return 0;
    }

    public boolean isQuiescent() {
        return false;
    }

    public long getStealCount() {
        return 0L;
    }

    public long getQueuedTaskCount() {
        return 0L;
    }

    public int getQueuedSubmissionCount() {
        return 0;
    }

    public boolean hasQueuedSubmissions() {
        return false;
    }

    protected ForkJoinTask<?> pollSubmission() {
        return null;
    }

    protected int drainTasksTo(Collection<? super ForkJoinTask<?>> collection) {
        return 0;
    }

    public String toString() {
        return null;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public List<Runnable> shutdownNow() {
        return null;
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    public boolean isTerminating() {
        return false;
    }

    @Override
    public boolean isShutdown() {
        return false;
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return false;
    }

    public boolean awaitQuiescence(long l, TimeUnit timeUnit) {
        return false;
    }

    public static void managedBlock(ManagedBlocker managedBlocker) throws InterruptedException {
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T t) {
        return null;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return null;
    }

    public static interface ManagedBlocker {
        public boolean block() throws InterruptedException;

        public boolean isReleasable();
    }

    static final class WorkQueue {
        int stackPred;
        int config;
        int base;
        ForkJoinTask<?>[] array;
        final ForkJoinWorkerThread owner;
        @Contended(value="w")
        int top;
        @Contended(value="w")
        volatile int access;
        @Contended(value="w")
        volatile int phase;
        @Contended(value="w")
        volatile int source;
        @Contended(value="w")
        int nsteals;
        private static final Unsafe U = Unsafe.getUnsafe();
        private static final long ACCESS;
        private static final long PHASE;
        private static final long ABASE;
        private static final int ASHIFT;

        static ForkJoinTask<?> getAndClearSlot(ForkJoinTask<?>[] a, int i) {
            return (ForkJoinTask)U.getAndSetReference(a, ((long)i << ASHIFT) + ABASE, null);
        }

        static boolean casSlotToNull(ForkJoinTask<?>[] a, int i, ForkJoinTask<?> c) {
            return U.compareAndSetReference(a, ((long)i << ASHIFT) + ABASE, c, null);
        }

        final void forcePhaseActive() {
            U.getAndBitwiseAndInt(this, PHASE, Integer.MAX_VALUE);
        }

        final int getAndSetAccess(int v) {
            return U.getAndSetInt(this, ACCESS, v);
        }

        final void releaseAccess() {
            U.putIntRelease(this, ACCESS, 0);
        }

        WorkQueue(ForkJoinWorkerThread owner, int config) {
            this.owner = owner;
            this.config = config;
            this.top = 1;
            this.base = 1;
        }

        final int getPoolIndex() {
            return (this.config & 0xFFFF) >>> 1;
        }

        final int queueSize() {
            int unused = this.access;
            return Math.max(this.top - this.base, 0);
        }

        final void push(ForkJoinTask<?> task, ForkJoinPool pool, boolean signalIfEmpty) {
            int cap;
            boolean resize = false;
            int s = this.top++;
            int b = this.base;
            ForkJoinTask<?>[] a = this.array;
            if (this.array != null && (cap = a.length) > 0) {
                int m = cap - 1;
                if (m == s - b) {
                    ForkJoinTask[] newArray;
                    resize = true;
                    int newCap = cap < 0x1000000 ? cap << 2 : cap << 1;
                    try {
                        newArray = new ForkJoinTask[newCap];
                    }
                    catch (Throwable ex) {
                        this.top = s;
                        this.access = 0;
                        throw new RejectedExecutionException("Queue capacity exceeded");
                    }
                    if (newCap > 0) {
                        int newMask = newCap - 1;
                        int k = s;
                        do {
                            newArray[k-- & newMask] = task;
                        } while ((task = WorkQueue.getAndClearSlot(a, k & m)) != null);
                    }
                    this.array = newArray;
                } else {
                    a[m & s] = task;
                }
                this.getAndSetAccess(0);
                if ((resize || a[m & s - 1] == null && signalIfEmpty) && pool != null) {
                    pool.signalWork();
                }
            }
        }

        final ForkJoinTask<?> nextLocalTask(int fifo) {
            int cap;
            ForkJoinTask<?> t = null;
            ForkJoinTask<?>[] a = this.array;
            int p = this.top;
            int s = p - 1;
            int b = this.base;
            if (p - b > 0 && a != null && (cap = a.length) > 0) {
                do {
                    int nb;
                    if (fifo == 0 || (nb = b + 1) == p) {
                        t = WorkQueue.getAndClearSlot(a, cap - 1 & s);
                        if (t == null) break;
                        this.top = s;
                        break;
                    }
                    t = WorkQueue.getAndClearSlot(a, cap - 1 & b);
                    if (t != null) {
                        this.base = nb;
                        break;
                    }
                    while (b == (b = this.base)) {
                        U.loadFence();
                        Thread.onSpinWait();
                    }
                } while (p - b > 0);
                U.storeStoreFence();
            }
            return t;
        }

        final ForkJoinTask<?> nextLocalTask() {
            return this.nextLocalTask(this.config & 0x10000);
        }

        final boolean tryUnpush(ForkJoinTask<?> task, boolean owned) {
            int s;
            int k;
            int cap;
            ForkJoinTask<?>[] a = this.array;
            int p = this.top;
            if (task != null && this.base != p && a != null && (cap = a.length) > 0 && a[k = cap - 1 & (s = p - 1)] == task && (owned || this.getAndSetAccess(1) == 0)) {
                if (this.top != p || a[k] != task || WorkQueue.getAndClearSlot(a, k) == null) {
                    this.access = 0;
                } else {
                    this.top = s;
                    this.access = 0;
                    return true;
                }
            }
            return false;
        }

        final ForkJoinTask<?> peek() {
            int cap;
            ForkJoinTask<?>[] a = this.array;
            int cfg = this.config;
            int p = this.top;
            int b = this.base;
            if (p != b && a != null && (cap = a.length) > 0) {
                if ((cfg & 0x10000) == 0) {
                    return a[cap - 1 & p - 1];
                }
                while (p - b > 0) {
                    ForkJoinTask<?> t = a[cap - 1 & b];
                    if (t != null) {
                        return t;
                    }
                    ++b;
                }
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final ForkJoinTask<?> poll(ForkJoinPool pool) {
            int b = this.base;
            while (true) {
                int cap;
                ForkJoinTask<?>[] a = this.array;
                if (this.array == null || (cap = a.length) <= 0) return null;
                int k = cap - 1 & b;
                int nb = b + 1;
                int nk = cap - 1 & nb;
                ForkJoinTask<?> t = a[k];
                U.loadFence();
                if (b != (b = this.base)) continue;
                if (t != null && WorkQueue.casSlotToNull(a, k, t)) {
                    this.base = nb;
                    U.storeFence();
                    if (pool == null || a[nk] == null) return t;
                    pool.signalWork();
                    return t;
                }
                if (this.array == a && a[k] == null && a[nk] == null && this.top - b <= 0) return null;
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final ForkJoinTask<?> tryPoll() {
            int cap;
            int b = this.base;
            ForkJoinTask<?>[] a = this.array;
            if (this.array == null || (cap = a.length) <= 0) return null;
            while (true) {
                int k = cap - 1 & b;
                int nb = b + 1;
                ForkJoinTask<?> t = a[k];
                U.loadFence();
                if (b != (b = this.base)) continue;
                if (t != null) {
                    if (!WorkQueue.casSlotToNull(a, k, t)) return null;
                    this.base = nb;
                    U.storeStoreFence();
                    return t;
                }
                if (a[k] == null) return null;
            }
        }

        final void topLevelExec(ForkJoinTask<?> task, WorkQueue src) {
            int cfg = this.config;
            int fifo = cfg & 0x10000;
            int nstolen = 1;
            while (task != null) {
                task.doExec();
                task = this.nextLocalTask(fifo);
                if (task != null || src == null || (task = src.tryPoll()) == null) continue;
                ++nstolen;
            }
            this.nsteals += nstolen;
            this.source = 0;
            if ((cfg & 0x40000) != 0) {
                ThreadLocalRandom.eraseThreadLocals((Thread)Thread.currentThread());
            }
        }

        final int tryRemoveAndExec(ForkJoinTask<?> task, boolean owned) {
            int cap;
            ForkJoinTask<?>[] a = this.array;
            int p = this.top;
            int s = p - 1;
            int d = p - this.base;
            if (task != null && d > 0 && a != null && (cap = a.length) > 0) {
                int m = cap - 1;
                int i = s;
                while (true) {
                    int k;
                    ForkJoinTask<?> t;
                    if ((t = a[k = i & m]) == task) {
                        if (!owned && this.getAndSetAccess(1) != 0) break;
                        if (this.top != p || a[k] != task || WorkQueue.getAndClearSlot(a, k) == null) {
                            this.access = 0;
                            break;
                        }
                        if (i != s && i == this.base) {
                            this.base = i + 1;
                        } else {
                            int j = i;
                            while (j != s) {
                                a[j & m] = WorkQueue.getAndClearSlot(a, ++j & m);
                            }
                            this.top = s;
                        }
                        this.releaseAccess();
                        return task.doExec();
                    }
                    if (t == null || --d == 0) break;
                    --i;
                }
            }
            return 0;
        }

        final int helpComplete(ForkJoinTask<?> task, boolean owned, int limit) {
            int status = 0;
            if (task != null) {
                block0: do {
                    int p;
                    int s;
                    int k;
                    ForkJoinTask<?> t;
                    int cap;
                    if ((status = task.status) < 0) {
                        return status;
                    }
                    ForkJoinTask<?>[] a = this.array;
                    if (this.array == null || (cap = a.length) <= 0 || (t = a[k = cap - 1 & (s = (p = this.top) - 1)]) == null || !(t instanceof CountedCompleter)) break;
                    CountedCompleter<?> f = (CountedCompleter<?>)t;
                    while (f != task) {
                        f = f.completer;
                        if (f != null) continue;
                        break block0;
                    }
                    if (!owned && this.getAndSetAccess(1) != 0) break;
                    if (this.top != p || a[k] != t || WorkQueue.getAndClearSlot(a, k) == null) {
                        this.access = 0;
                        break;
                    }
                    this.top = s;
                    this.releaseAccess();
                    t.doExec();
                } while (limit == 0 || --limit != 0);
                status = task.status;
            }
            return status;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        final void helpAsyncBlocker(ManagedBlocker blocker) {
            if (blocker == null) return;
            while (true) {
                int cap;
                int b = this.base;
                ForkJoinTask<?>[] a = this.array;
                if (this.array == null || (cap = a.length) <= 0 || b == this.top) return;
                int k = cap - 1 & b;
                int nb = b + 1;
                int nk = cap - 1 & nb;
                ForkJoinTask<?> t = a[k];
                U.loadFence();
                if (this.base != b) continue;
                if (blocker.isReleasable()) return;
                if (a[k] != t) continue;
                if (t != null) {
                    if (!(t instanceof CompletableFuture.AsynchronousCompletionTask)) return;
                    if (!WorkQueue.casSlotToNull(a, k, t)) continue;
                    this.base = nb;
                    U.storeStoreFence();
                    t.doExec();
                    continue;
                }
                if (a[nk] == null) return;
            }
        }

        final boolean isApparentlyUnblocked() {
            Thread.State s;
            ForkJoinWorkerThread wt;
            return this.access != Integer.MIN_VALUE && (wt = this.owner) != null && (s = wt.getState()) != Thread.State.BLOCKED && s != Thread.State.WAITING && s != Thread.State.TIMED_WAITING;
        }

        final void setClearThreadLocals() {
            this.config |= 0x40000;
        }

        static {
            Class<WorkQueue> klass = WorkQueue.class;
            ACCESS = U.objectFieldOffset(klass, "access");
            PHASE = U.objectFieldOffset(klass, "phase");
            Class<ForkJoinTask[]> aklass = ForkJoinTask[].class;
            ABASE = U.arrayBaseOffset(aklass);
            int scale = U.arrayIndexScale(aklass);
            ASHIFT = 31 - Integer.numberOfLeadingZeros(scale);
            if ((scale & scale - 1) != 0) {
                throw new Error("array index scale not a power of two");
            }
        }
    }

    static final class DefaultForkJoinWorkerThreadFactory
    implements ForkJoinWorkerThreadFactory {
        static volatile AccessControlContext regularACC;
        static volatile AccessControlContext commonACC;

        DefaultForkJoinWorkerThreadFactory() {
        }

        @Override
        public final ForkJoinWorkerThread newThread(ForkJoinPool pool) {
            boolean isCommon = pool.workerNamePrefix == null;
            SecurityManager sm = System.getSecurityManager();
            if (sm == null) {
                return new ForkJoinWorkerThread(null, pool, true, false);
            }
            if (isCommon) {
                return DefaultForkJoinWorkerThreadFactory.newCommonWithACC(pool);
            }
            return DefaultForkJoinWorkerThreadFactory.newRegularWithACC(pool);
        }

        static ForkJoinWorkerThread newRegularWithACC(final ForkJoinPool pool) {
            AccessControlContext acc = regularACC;
            if (acc == null) {
                Permissions ps = new Permissions();
                ps.add(new RuntimePermission("getClassLoader"));
                ps.add(new RuntimePermission("setContextClassLoader"));
                regularACC = acc = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, ps)});
            }
            return AccessController.doPrivileged(new PrivilegedAction<ForkJoinWorkerThread>(){

                @Override
                public ForkJoinWorkerThread run() {
                    return new ForkJoinWorkerThread(null, pool, true, false);
                }
            }, acc);
        }

        static ForkJoinWorkerThread newCommonWithACC(final ForkJoinPool pool) {
            AccessControlContext acc = commonACC;
            if (acc == null) {
                Permissions ps = new Permissions();
                ps.add(new RuntimePermission("getClassLoader"));
                ps.add(new RuntimePermission("setContextClassLoader"));
                ps.add(new RuntimePermission("modifyThread"));
                ps.add(new RuntimePermission("enableContextClassLoaderOverride"));
                ps.add(new RuntimePermission("modifyThreadGroup"));
                commonACC = acc = new AccessControlContext(new ProtectionDomain[]{new ProtectionDomain(null, ps)});
            }
            return AccessController.doPrivileged(new PrivilegedAction<ForkJoinWorkerThread>(){

                @Override
                public ForkJoinWorkerThread run() {
                    return new ForkJoinWorkerThread.InnocuousForkJoinWorkerThread(pool);
                }
            }, acc);
        }
    }

    public static interface ForkJoinWorkerThreadFactory {
        public ForkJoinWorkerThread newThread(ForkJoinPool var1);
    }
}

