/* LIBGIMP - The GIMP Library
 * Copyright (C) 1995-2003 Peter Mattis and Spencer Kimball
 *
 * gimpvectorlayer_pdb.c
 *
 * This library is free software: you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library.  If not, see
 * <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl */

#include "config.h"

#include "stamp-pdbgen.h"

#include "gimp.h"


/**
 * SECTION: gimpvectorlayer
 * @title: gimpvectorlayer
 * @short_description: Functions for querying and manipulating vector layers.
 *
 * Functions for querying and manipulating vector layers.
 **/


/**
 * gimp_vector_layer_new:
 * @image: The image.
 * @path: The path to create the layer from.
 *
 * Creates a new vector layer.
 *
 * This procedure creates a new path layer displaying the specified
 * @path. By default, the fill and stroke properties will be defined by
 * the context.
 *
 * The new layer still needs to be added to the image as this is not
 * automatic. Add the new layer with the [method@Image.insert_layer]
 * method.
 *
 * The arguments are kept as simple as necessary for the basic case.
 * All vector attributes, however, can be modified with the appropriate
 * `gimp_vector_layer_set_*()` procedures.
 *
 * Returns: (transfer none):
 *          The new vector layer. The object belongs to libgimp and you should not free it.
 *
 * Since: 3.2
 **/
GimpVectorLayer *
gimp_vector_layer_new (GimpImage *image,
                       GimpPath  *path)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  GimpVectorLayer *layer = NULL;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_IMAGE, image,
                                          GIMP_TYPE_PATH, path,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-vector-layer-new",
                                               args);
  gimp_value_array_unref (args);

  if (GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS)
    layer = GIMP_VALUES_GET_VECTOR_LAYER (return_vals, 1);

  gimp_value_array_unref (return_vals);

  return layer;
}

/**
 * gimp_vector_layer_refresh:
 * @layer: The vector layer.
 *
 * Rerender the vector layer
 *
 * This procedure causes the vector layer to refresh itself after
 * changes.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.2
 **/
gboolean
gimp_vector_layer_refresh (GimpVectorLayer *layer)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_VECTOR_LAYER, layer,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-vector-layer-refresh",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}

/**
 * gimp_vector_layer_discard:
 * @layer: The vector layer.
 *
 * Discard the vector layer information.
 *
 * Discards the vector information. This makes the layer behave like a
 * normal layer.
 *
 * Returns: TRUE on success.
 *
 * Since: 3.2
 **/
gboolean
gimp_vector_layer_discard (GimpVectorLayer *layer)
{
  GimpValueArray *args;
  GimpValueArray *return_vals;
  gboolean success = TRUE;

  args = gimp_value_array_new_from_types (NULL,
                                          GIMP_TYPE_VECTOR_LAYER, layer,
                                          G_TYPE_NONE);

  return_vals = _gimp_pdb_run_procedure_array (gimp_get_pdb (),
                                               "gimp-vector-layer-discard",
                                               args);
  gimp_value_array_unref (args);

  success = GIMP_VALUES_GET_ENUM (return_vals, 0) == GIMP_PDB_SUCCESS;

  gimp_value_array_unref (return_vals);

  return success;
}
