/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.views.markers.internal.MarkerType;

public class MarkerTypesModel {
    static MarkerTypesModel instance;
    private HashMap<String, MarkerType> types = this.readTypes();

    public static MarkerTypesModel getInstance() {
        if (instance == null) {
            instance = new MarkerTypesModel();
        }
        return instance;
    }

    private MarkerTypesModel() {
    }

    public MarkerType getType(String id) {
        return this.types.get(id);
    }

    public MarkerType[] getTypes() {
        MarkerType[] result = new MarkerType[this.types.size()];
        this.types.values().toArray(result);
        return result;
    }

    private String getWellKnownLabel(String type) {
        if (type.equals("org.eclipse.core.resources.problemmarker")) {
            return "Problem";
        }
        if (type.equals("org.eclipse.core.resources.taskmarker")) {
            return "Task";
        }
        if (type.equals("org.eclipse.jdt.core.problem")) {
            return "Java Problem";
        }
        return type;
    }

    private HashMap<String, MarkerType> readTypes() {
        HashMap<String, MarkerType> result = new HashMap<String, MarkerType>();
        IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.core.resources", "markers");
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configElements;
                IExtension ext = iExtensionArray[n2];
                String id = ext.getUniqueIdentifier();
                String label = ext.getLabel();
                if (label.isEmpty()) {
                    label = this.getWellKnownLabel(id);
                }
                ArrayList<String> supersList = new ArrayList<String>();
                IConfigurationElement[] iConfigurationElementArray = configElements = ext.getConfigurationElements();
                int n3 = configElements.length;
                int n4 = 0;
                while (n4 < n3) {
                    String sup;
                    IConfigurationElement configElement = iConfigurationElementArray[n4];
                    if (configElement.getName().equalsIgnoreCase("super") && (sup = configElement.getAttribute("type")) != null) {
                        supersList.add(sup);
                    }
                    ++n4;
                }
                String[] superTypes = new String[supersList.size()];
                supersList.toArray(superTypes);
                MarkerType type = new MarkerType(this, id, label, superTypes);
                result.put(id, type);
                ++n2;
            }
        }
        return result;
    }
}

