/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.trino.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericDataType;
import org.jkiss.dbeaver.ext.generic.model.GenericDataTypeCache;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class TrinoDataTypeCache
extends GenericDataTypeCache {
    TrinoDataTypeCache(GenericStructContainer owner) {
        super(owner);
    }

    protected GenericDataType fetchObject(@NotNull JDBCSession session, @NotNull GenericStructContainer container, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
        block28: {
            String lowerCaseName;
            String name = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TYPE_NAME");
            if (CommonUtils.isEmpty((String)name)) {
                return null;
            }
            int valueType = JDBCUtils.safeGetInt((ResultSet)dbResult, (String)"DATA_TYPE");
            if (valueType != 2000) break block28;
            switch (lowerCaseName = name.toLowerCase(Locale.getDefault())) {
                case "varchar": {
                    valueType = 12;
                    break;
                }
                case "char": 
                case "uuid": {
                    valueType = 1;
                    break;
                }
                case "time with time zone": {
                    valueType = 2013;
                    break;
                }
                case "timestamp with time zone": {
                    valueType = 2014;
                    break;
                }
                case "timestamp": {
                    valueType = 93;
                    break;
                }
                case "time": {
                    valueType = 92;
                    break;
                }
                case "decimal": {
                    valueType = 3;
                    break;
                }
                default: {
                    return (GenericDataType)super.fetchObject(session, (DBSObject)container, dbResult);
                }
            }
            return this.makeDataType(dbResult, name, valueType);
        }
        return (GenericDataType)super.fetchObject(session, (DBSObject)container, dbResult);
    }
}

