/***************************************************************************
 *   Copyright (C) 2005 by Theo Schneider                                  *
 *   tooly@schneider-berlin                                                *
 *   based on luise_test from M.Wallbraun                                  * 
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "luise.h"

const char defFont[11]="f13x16.fnt";
const char defPic[11]="Bitmap.bmp";
const char defFile[8]="lcd.txt";

char pathPtr[2048];

// my_itoa uebernommen von www.pronix.de/pronix-821.html
char *my_itoa(int wert, int laenge) 
{
   char *ret =(char *) malloc(laenge+1 * sizeof(char));
   int i;

   for(i  =0; i < laenge; i++) {
      ret[laenge-i-1] = (wert % 10) + 48;
      wert = wert / 10;
   }
   ret[laenge]='\0';
   return ret;
}

void lcd_myName (int devNum)
{
  char fontPath[2048];

  strncpy (fontPath, pathPtr, strlen(pathPtr)+1);
  strncat (fontPath, defFont, strlen(defFont)+1); 
  
  char libVER_Text[34] = "Sie nutzen libluise Version# ";
  strcat (libVER_Text, my_itoa(GetDllVersion(), 4));

  LUI_Text (devNum, 40, 40, 320, 120, 0, 0, 1, 1, "Dieses Testprogramm wurde geschrieben von:");
  LUI_Text (devNum, 110, 70, 320, 120, 0, fontPath, 1, 1, "Theo Schneider");
  LUI_Text (devNum, 90, 100, 320, 120, 0, 0, 1, 1, "tooly@schneider-berlin.net");
  LUI_Text (devNum, 60, 135, 320, 120, 0, 0, 1, 1, "Mit freundlicher Unterstuetzung von:");
  LUI_Text (devNum, 55, 155, 320, 120, 0, fontPath, 1, 1, "www.wallbraun-electronics.de");
  LUI_Text (devNum, 70, 190, 320, 120, 0, 0, 1, 1, libVER_Text);
}

//  verringe den Kontrast um 5 Pkt.
void lcd_heller(int devNum)
{
  unsigned char val;

  LUI_GetContrast (devNum, &val);
  
  // falls val kleiner als 5, auf mind, 5 setzen
 if (val < 5) val=5;

  LUI_SetContrast (devNum, (unsigned char) (val-5));
}

// erhöhe den Kontrast um 5 Pkt.
void lcd_dunkler (int devNum)
{
  unsigned char val;

  LUI_GetContrast (devNum, &val);
  
  // falls val größer als 250 auf max. 250 setzen
  if (val > 250) val=250;

  LUI_SetContrast (devNum, (unsigned char) (val+5));
}

void lcd_clear (int devNum)
{
    unsigned char buf[9600];
    int x;
    
    // loesche Text
    LUI_Text (devNum, 0, 0, 320, 240, 0, 0, 1, 1, "");
    
    // evtl. Bild loeschen
    for (x=0; x < 9600; x++) buf[x]=0x00;
    LUI_Bitmap (devNum, 0, 0, 0, 0, 0, 320, 240, 320, 240, buf);
}

void show_grafik (int devNum)
{
  char picPath[2048];
  
  strncpy (picPath, pathPtr, strlen(pathPtr)+1);
  strncat (picPath, defPic, strlen(defPic)+1); 
	   
   // erstmal alles loeschen
   lcd_clear (devNum);

  // Grafik anzeigen
  LUI_BMPfile (devNum, 0, 0, 0, 0, 0, 320, 240, picPath);
}

void zeichne_grafik (int devNum)
{
  int x, i, z;

   //erstmal alles lschen
  lcd_clear (devNum);

  for (z=0; z < 3; z++)
  {
      // das "Netz" zeichen
      for (i=10; i < 110; i=i+10)
      {
        for (x=0; x < i; x++)
        {
          LUI_SetPixel (devNum, 0, (160-i)+x, 120-x, 1);
          LUI_SetPixel (devNum, 0, (160+i)-x, 120-x, 1);
          LUI_SetPixel (devNum, 0, (160-i)+x, 120+x, 1);
          LUI_SetPixel (devNum, 0, (160+i)-x, 120+x, 1);
        };
        usleep (25000);
     };

     // das "Netz" loeschen
    for (i=10; i < 110; i=i+10)
    {
      for (x=0; x < i; x++)
      {
        LUI_SetPixel (devNum, 0, (160-i)+x, 120-x, 0);
        LUI_SetPixel (devNum, 0, (160+i)-x, 120-x, 0);
        LUI_SetPixel (devNum, 0, (160-i)+x, 120+x, 0);
        LUI_SetPixel (devNum, 0, (160+i)-x, 120+x, 0);
      };
      usleep (25000);
    };
  };

  // nochmal zeichen, damit etwas auf dem LCD ist.
  for (i=10; i < 110; i=i+10)
      {
        for (x=0; x < i; x++)
        {
          LUI_SetPixel (devNum, 0, (160-i)+x, 120-x, 1);
          LUI_SetPixel (devNum, 0, (160+i)-x, 120-x, 1);
          LUI_SetPixel (devNum, 0, (160-i)+x, 120+x, 1);
          LUI_SetPixel (devNum, 0, (160+i)-x, 120+x, 1);
        };
        usleep (25000);
     };

    for (x=0; x < 110; x++)
    {
      // vertikal mitte
      LUI_SetPixel (devNum, 0, 160, 120-x, 1);
      LUI_SetPixel (devNum, 0, 160, 120+x, 1);

      // horizontal mitte
      LUI_SetPixel (devNum, 0, 160-x, 120, 1);
      LUI_SetPixel (devNum, 0, 160+x, 120, 1);

      usleep (10000);
    }; 

    for (x=0; x < 60; x++)
    {
      // links oben nach rechts unten
      LUI_SetPixel (devNum, 0, 160-x, 120-x, 1);
      LUI_SetPixel (devNum, 0, 160+x, 120+x, 1);

      // links unten nach rechts oben
      LUI_SetPixel (devNum, 0, 160-x, 120+x, 1);
      LUI_SetPixel (devNum, 0, 160+x, 120-x, 1);

      usleep (10000);
    };
}

int show_text (int devNum)
{
  FILE *lcdTXT;
  char **linePtr=(char **)malloc(sizeof(char *));
  size_t *lineLen = malloc(0);
  int yMax, xPos, yPos, x, y=0;
  char filePath[2048];

  strncpy (filePath, pathPtr, strlen(pathPtr)+1);
  strncat (filePath, defFile, strlen(defFile)+1); 
  
  // erstmal alles löschen
  lcd_clear(devNum);

  lcdTXT=fopen (filePath, "r");
  if (lcdTXT == NULL)
  {
    printf ("FEHLER! Kann Datei nicht oeffnen!");
    return 1;
   }

   *linePtr=NULL;
   yMax=10;
   
   while ( (x=getline(linePtr, lineLen, lcdTXT)) > 0)
   {
       xPos = 160 - (strlen(*linePtr) * 3);
       for (yPos=239; yPos > yMax; yPos--)
       {
	  LUI_Text (devNum, xPos, yPos, 320, 240, 0, 0, 1, 1, *linePtr);
	  usleep(12500);
	}
	 yMax += 10;
	 y++;
	 if (y > 30)
	 {
		 lcd_clear (devNum);
		 yMax=10;
		 y=0;
	 }
  }

  fclose (lcdTXT);
}

int main(int argc, char *argv[])
{
  int devNum=0, len;
  char auswahl, buf[2], *ptr;

  // argv[0] enthaellt den kompletten pfad zum programm
  // mit strrchr wird alles hinter dem letzen / abgeschnitten
  // dadurch enthaelt pathPtr nur noch den Pfad, ohne Progammnamen
  strncpy (pathPtr, argv[0], strlen(argv[0]+1));
  ptr = strrchr(pathPtr, '/');
  ptr++;
  *ptr='\0';

  if (LUI_OpenDevice (devNum)) 
  {
    printf ("FEHLER, kann LCD nicht oeffen!\n");
    return 1;
  }

  // naja wird zwar kaum einer wahrnehmen, 
  // aber zum angeben
  lcd_myName (devNum);

  system ("clear");
  //menu
  do
  {
    printf ("\n");
    printf ("   *--------------------------------------------*\n");
    printf ("      (0) LCD aus           (1) LCD ein\n");
    printf ("      (2) LCD dunkler       (3) LCD heller\n");
    printf ("      (4) Beleuchtung aus   (5) Beleuchtung an\n");
    printf ("      (6) Zeige Grafik      (7) Zeige Text\n");
    printf ("      (8) Grafik zeichnen   (9) LCD loeschen\n");
    printf ("                      (q) Ende\n");
    printf ("   *--------------------------------------------*\n");
    printf ("\n");
    printf ("                   Bitte waehlen: ");

    fgets(buf, 2, stdin);
    sscanf (buf, "%c", &auswahl);

    system ("clear");

    switch (auswahl)
    {
       case '0':						// Display ausschalten
       {
          LUI_DispOnOff (devNum, 0);
          break;
       }
       case '1':						// Display einschalten
       {
          LUI_DispOnOff (devNum, 1);
          break;
       }
       case '2':						// Kontrast verringern
       {
          lcd_dunkler(devNum);
          break;
       }
       case '3':						// Kontrast erhöhen
       {
          lcd_heller(devNum);
          break;
       }
       case '4':						// Hintergrundbeleuchtung ausschalten
       {
           LUI_CCFL (devNum, 0);
           break; 
       }
       case '5':						// Hintergrundbeleuchtung einschalten
       {
          LUI_CCFL (devNum, 1);
          break;
       }
       case '6':						// Grafik anzeigen
       {
          show_grafik (devNum);
          break;
       }
       case '7':						// Text anzeigen
       {
          show_text (devNum);
          break;
       }
       case '8':						// Grafik zeichnen
       {
          zeichne_grafik (devNum);
          break;
       }
       case '9':						// LCD löschen
       {
          lcd_clear(devNum);
          break;
       }
    }
  } while (auswahl != 'q');
  
  LUI_CloseDevice (devNum);
  return EXIT_SUCCESS;
}
