%ifdef CONFIG
{
  "HostFeatures": ["AVX"],
  "RegData": {
    "XMM0": ["0x3FF0000000000000", "0xEEEEEEEEEEEEEEEE", "0xFFFFFFFFFFFFFFFF", "0xAAAAAAAAAAAAAAAA"],
    "XMM1": ["0xBBBBBBBBBBBBBBBB", "0xDDDDDDDDDDDDDDDD", "0xCCCCCCCCCCCCCCCC", "0x9999999999999999"],
    "XMM2": ["0x3FF0000000000000", "0xEEEEEEEEEEEEEEEE", "0xBBBBBBBBBBBBBBBB", "0xDDDDDDDDDDDDDDDD"],
    "XMM3": ["0x3FF0000000000000", "0xEEEEEEEEEEEEEEEE", "0xBBBBBBBBBBBBBBBB", "0xDDDDDDDDDDDDDDDD"],
    "XMM4": ["0xFFFFFFFFFFFFFFFF", "0xAAAAAAAAAAAAAAAA", "0xCCCCCCCCCCCCCCCC", "0x9999999999999999"],
    "XMM5": ["0xFFFFFFFFFFFFFFFF", "0xAAAAAAAAAAAAAAAA", "0xCCCCCCCCCCCCCCCC", "0x9999999999999999"],
    "XMM6": ["0x0000000000000000", "0x0000000000000000", "0x0000000000000000", "0x0000000000000000"]
  }
}
%endif

lea rdx, [rel .data]

vmovapd ymm0, [rdx]
vmovapd ymm1, [rdx + 32]

; Permute first 128-bit element from each vector
vperm2f128 ymm2, ymm0, ymm1, 0b00100000
vperm2f128 ymm3, ymm0, [rdx + 32], 0b00100000

; Permute top halves of both vectors
vperm2f128 ymm4, ymm0, ymm1, 0b00110001
vperm2f128 ymm5, ymm0, [rdx + 32], 0b00110001

; Zero out entire vector
vmovapd ymm6, ymm0;
vperm2f128 ymm6, ymm0, ymm1, 0b10001000

hlt

align 32
.data:
dq 0x3FF0000000000000
dq 0xEEEEEEEEEEEEEEEE
dq 0xFFFFFFFFFFFFFFFF
dq 0xAAAAAAAAAAAAAAAA

dq 0xBBBBBBBBBBBBBBBB
dq 0xDDDDDDDDDDDDDDDD
dq 0xCCCCCCCCCCCCCCCC
dq 0x9999999999999999
