#!/bin/sh

set -e

if test $# -ne 4
then
	echo >&2 "USAGE: $0 <GITWEB-BUILD-OPTIONS> <GIT-VERSION-FILE> <INPUT> <OUTPUT>"
	exit 1
fi

GITWEB_BUILD_OPTIONS="$1"
GIT_VERSION_FILE="$2"
INPUT="$3"
OUTPUT="$4"

. "$GITWEB_BUILD_OPTIONS"
. "$GIT_VERSION_FILE"

sed -e "1s|#!/usr/bin/perl|#!$PERL_PATH|" \
    -e "s|@PERL_PATH@|$PERL_PATH|" \
    -e "s|@JSMIN@|$JSMIN|" \
    -e "s|@CSSMIN@|$CSSMIN|" \
    -e "s|@GIT_VERSION@|$GIT_VERSION|" \
    -e "s|@GIT_BINDIR@|$GIT_BINDIR|" \
    -e "s|@GITWEB_CONFIG@|$GITWEB_CONFIG|" \
    -e "s|@GITWEB_CONFIG_SYSTEM@|$GITWEB_CONFIG_SYSTEM|" \
    -e "s|@GITWEB_CONFIG_COMMON@|$GITWEB_CONFIG_COMMON|" \
    -e "s|@GITWEB_HOME_LINK_STR@|$GITWEB_HOME_LINK_STR|" \
    -e "s|@GITWEB_SITENAME@|$GITWEB_SITENAME|" \
    -e "s|@GITWEB_PROJECTROOT@|$GITWEB_PROJECTROOT|" \
    -e "s|@GITWEB_PROJECT_MAXDEPTH@|$GITWEB_PROJECT_MAXDEPTH|" \
    -e "s|@GITWEB_EXPORT_OK@|$GITWEB_EXPORT_OK|" \
    -e "s|@GITWEB_STRICT_EXPORT@|$GITWEB_STRICT_EXPORT|" \
    -e "s|@GITWEB_BASE_URL@|$GITWEB_BASE_URL|" \
    -e "s|@GITWEB_LIST@|$GITWEB_LIST|" \
    -e "s|@GITWEB_HOMETEXT@|$GITWEB_HOMETEXT|" \
    -e "s|@GITWEB_CSS@|$GITWEB_CSS|" \
    -e "s|@GITWEB_LOGO@|$GITWEB_LOGO|" \
    -e "s|@GITWEB_FAVICON@|$GITWEB_FAVICON|" \
    -e "s|@GITWEB_JS@|$GITWEB_JS|" \
    -e "s|@GITWEB_SITE_HTML_HEAD_STRING@|$GITWEB_SITE_HTML_HEAD_STRING|" \
    -e "s|@GITWEB_SITE_HEADER@|$GITWEB_SITE_HEADER|" \
    -e "s|@GITWEB_SITE_FOOTER@|$GITWEB_SITE_FOOTER|" \
    -e "s|@HIGHLIGHT_BIN@|$HIGHLIGHT_BIN|" \
    "$INPUT" >"$OUTPUT"

chmod a+x "$OUTPUT"
