describe :method_call, shared: true do
  it "invokes the method with the specified arguments, returning the method's return value" do
    m = 12.method("+")
    m.send(@method, 3).should == 15
    m.send(@method, 20).should == 32

    m = MethodSpecs::Methods.new.method(:attr=)
    m.send(@method, 42).should == 42
  end

  it "raises an ArgumentError when given incorrect number of arguments" do
    -> {
      MethodSpecs::Methods.new.method(:two_req).send(@method, 1, 2, 3)
    }.should raise_error(ArgumentError)
    -> {
      MethodSpecs::Methods.new.method(:two_req).send(@method, 1)
    }.should raise_error(ArgumentError)
  end

  describe "for a Method generated by respond_to_missing?" do
    it "invokes method_missing with the specified arguments and returns the result" do
      @m = MethodSpecs::Methods.new
      meth = @m.method(:handled_via_method_missing)
      meth.send(@method, :argument).should == [:argument]
    end

    it "invokes method_missing with the method name and the specified arguments" do
      @m = MethodSpecs::Methods.new
      meth = @m.method(:handled_via_method_missing)

      @m.should_receive(:method_missing).with(:handled_via_method_missing, :argument)
      meth.send(@method, :argument)
    end

    it "invokes method_missing dynamically" do
      @m = MethodSpecs::Methods.new
      meth = @m.method(:handled_via_method_missing)

      def @m.method_missing(*); :changed; end
      meth.send(@method, :argument).should == :changed
    end

    it "does not call the original method name even if it now exists" do
      @m = MethodSpecs::Methods.new
      meth = @m.method(:handled_via_method_missing)

      def @m.handled_via_method_missing(*); :not_called; end
      meth.send(@method, :argument).should == [:argument]
    end
  end
end
