package sql

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AdministratorType enumerates the values for administrator type.
type AdministratorType string

const (
	// AdministratorTypeActiveDirectory ...
	AdministratorTypeActiveDirectory AdministratorType = "ActiveDirectory"
)

// PossibleAdministratorTypeValues returns an array of possible values for the AdministratorType const type.
func PossibleAdministratorTypeValues() []AdministratorType {
	return []AdministratorType{AdministratorTypeActiveDirectory}
}

// AdvisorStatus enumerates the values for advisor status.
type AdvisorStatus string

const (
	// AdvisorStatusGA ...
	AdvisorStatusGA AdvisorStatus = "GA"
	// AdvisorStatusLimitedPublicPreview ...
	AdvisorStatusLimitedPublicPreview AdvisorStatus = "LimitedPublicPreview"
	// AdvisorStatusPrivatePreview ...
	AdvisorStatusPrivatePreview AdvisorStatus = "PrivatePreview"
	// AdvisorStatusPublicPreview ...
	AdvisorStatusPublicPreview AdvisorStatus = "PublicPreview"
)

// PossibleAdvisorStatusValues returns an array of possible values for the AdvisorStatus const type.
func PossibleAdvisorStatusValues() []AdvisorStatus {
	return []AdvisorStatus{AdvisorStatusGA, AdvisorStatusLimitedPublicPreview, AdvisorStatusPrivatePreview, AdvisorStatusPublicPreview}
}

// AggregationFunctionType enumerates the values for aggregation function type.
type AggregationFunctionType string

const (
	// AggregationFunctionTypeAvg ...
	AggregationFunctionTypeAvg AggregationFunctionType = "avg"
	// AggregationFunctionTypeMax ...
	AggregationFunctionTypeMax AggregationFunctionType = "max"
	// AggregationFunctionTypeMin ...
	AggregationFunctionTypeMin AggregationFunctionType = "min"
	// AggregationFunctionTypeStdev ...
	AggregationFunctionTypeStdev AggregationFunctionType = "stdev"
	// AggregationFunctionTypeSum ...
	AggregationFunctionTypeSum AggregationFunctionType = "sum"
)

// PossibleAggregationFunctionTypeValues returns an array of possible values for the AggregationFunctionType const type.
func PossibleAggregationFunctionTypeValues() []AggregationFunctionType {
	return []AggregationFunctionType{AggregationFunctionTypeAvg, AggregationFunctionTypeMax, AggregationFunctionTypeMin, AggregationFunctionTypeStdev, AggregationFunctionTypeSum}
}

// AutoExecuteStatus enumerates the values for auto execute status.
type AutoExecuteStatus string

const (
	// AutoExecuteStatusDefault ...
	AutoExecuteStatusDefault AutoExecuteStatus = "Default"
	// AutoExecuteStatusDisabled ...
	AutoExecuteStatusDisabled AutoExecuteStatus = "Disabled"
	// AutoExecuteStatusEnabled ...
	AutoExecuteStatusEnabled AutoExecuteStatus = "Enabled"
)

// PossibleAutoExecuteStatusValues returns an array of possible values for the AutoExecuteStatus const type.
func PossibleAutoExecuteStatusValues() []AutoExecuteStatus {
	return []AutoExecuteStatus{AutoExecuteStatusDefault, AutoExecuteStatusDisabled, AutoExecuteStatusEnabled}
}

// AutoExecuteStatusInheritedFrom enumerates the values for auto execute status inherited from.
type AutoExecuteStatusInheritedFrom string

const (
	// AutoExecuteStatusInheritedFromDatabase ...
	AutoExecuteStatusInheritedFromDatabase AutoExecuteStatusInheritedFrom = "Database"
	// AutoExecuteStatusInheritedFromDefault ...
	AutoExecuteStatusInheritedFromDefault AutoExecuteStatusInheritedFrom = "Default"
	// AutoExecuteStatusInheritedFromElasticPool ...
	AutoExecuteStatusInheritedFromElasticPool AutoExecuteStatusInheritedFrom = "ElasticPool"
	// AutoExecuteStatusInheritedFromServer ...
	AutoExecuteStatusInheritedFromServer AutoExecuteStatusInheritedFrom = "Server"
	// AutoExecuteStatusInheritedFromSubscription ...
	AutoExecuteStatusInheritedFromSubscription AutoExecuteStatusInheritedFrom = "Subscription"
)

// PossibleAutoExecuteStatusInheritedFromValues returns an array of possible values for the AutoExecuteStatusInheritedFrom const type.
func PossibleAutoExecuteStatusInheritedFromValues() []AutoExecuteStatusInheritedFrom {
	return []AutoExecuteStatusInheritedFrom{AutoExecuteStatusInheritedFromDatabase, AutoExecuteStatusInheritedFromDefault, AutoExecuteStatusInheritedFromElasticPool, AutoExecuteStatusInheritedFromServer, AutoExecuteStatusInheritedFromSubscription}
}

// AutomaticTuningDisabledReason enumerates the values for automatic tuning disabled reason.
type AutomaticTuningDisabledReason string

const (
	// AutomaticTuningDisabledReasonAutoConfigured ...
	AutomaticTuningDisabledReasonAutoConfigured AutomaticTuningDisabledReason = "AutoConfigured"
	// AutomaticTuningDisabledReasonDefault ...
	AutomaticTuningDisabledReasonDefault AutomaticTuningDisabledReason = "Default"
	// AutomaticTuningDisabledReasonDisabled ...
	AutomaticTuningDisabledReasonDisabled AutomaticTuningDisabledReason = "Disabled"
	// AutomaticTuningDisabledReasonInheritedFromServer ...
	AutomaticTuningDisabledReasonInheritedFromServer AutomaticTuningDisabledReason = "InheritedFromServer"
	// AutomaticTuningDisabledReasonNotSupported ...
	AutomaticTuningDisabledReasonNotSupported AutomaticTuningDisabledReason = "NotSupported"
	// AutomaticTuningDisabledReasonQueryStoreOff ...
	AutomaticTuningDisabledReasonQueryStoreOff AutomaticTuningDisabledReason = "QueryStoreOff"
	// AutomaticTuningDisabledReasonQueryStoreReadOnly ...
	AutomaticTuningDisabledReasonQueryStoreReadOnly AutomaticTuningDisabledReason = "QueryStoreReadOnly"
)

// PossibleAutomaticTuningDisabledReasonValues returns an array of possible values for the AutomaticTuningDisabledReason const type.
func PossibleAutomaticTuningDisabledReasonValues() []AutomaticTuningDisabledReason {
	return []AutomaticTuningDisabledReason{AutomaticTuningDisabledReasonAutoConfigured, AutomaticTuningDisabledReasonDefault, AutomaticTuningDisabledReasonDisabled, AutomaticTuningDisabledReasonInheritedFromServer, AutomaticTuningDisabledReasonNotSupported, AutomaticTuningDisabledReasonQueryStoreOff, AutomaticTuningDisabledReasonQueryStoreReadOnly}
}

// AutomaticTuningMode enumerates the values for automatic tuning mode.
type AutomaticTuningMode string

const (
	// AutomaticTuningModeAuto ...
	AutomaticTuningModeAuto AutomaticTuningMode = "Auto"
	// AutomaticTuningModeCustom ...
	AutomaticTuningModeCustom AutomaticTuningMode = "Custom"
	// AutomaticTuningModeInherit ...
	AutomaticTuningModeInherit AutomaticTuningMode = "Inherit"
	// AutomaticTuningModeUnspecified ...
	AutomaticTuningModeUnspecified AutomaticTuningMode = "Unspecified"
)

// PossibleAutomaticTuningModeValues returns an array of possible values for the AutomaticTuningMode const type.
func PossibleAutomaticTuningModeValues() []AutomaticTuningMode {
	return []AutomaticTuningMode{AutomaticTuningModeAuto, AutomaticTuningModeCustom, AutomaticTuningModeInherit, AutomaticTuningModeUnspecified}
}

// AutomaticTuningOptionModeActual enumerates the values for automatic tuning option mode actual.
type AutomaticTuningOptionModeActual string

const (
	// AutomaticTuningOptionModeActualOff ...
	AutomaticTuningOptionModeActualOff AutomaticTuningOptionModeActual = "Off"
	// AutomaticTuningOptionModeActualOn ...
	AutomaticTuningOptionModeActualOn AutomaticTuningOptionModeActual = "On"
)

// PossibleAutomaticTuningOptionModeActualValues returns an array of possible values for the AutomaticTuningOptionModeActual const type.
func PossibleAutomaticTuningOptionModeActualValues() []AutomaticTuningOptionModeActual {
	return []AutomaticTuningOptionModeActual{AutomaticTuningOptionModeActualOff, AutomaticTuningOptionModeActualOn}
}

// AutomaticTuningOptionModeDesired enumerates the values for automatic tuning option mode desired.
type AutomaticTuningOptionModeDesired string

const (
	// AutomaticTuningOptionModeDesiredDefault ...
	AutomaticTuningOptionModeDesiredDefault AutomaticTuningOptionModeDesired = "Default"
	// AutomaticTuningOptionModeDesiredOff ...
	AutomaticTuningOptionModeDesiredOff AutomaticTuningOptionModeDesired = "Off"
	// AutomaticTuningOptionModeDesiredOn ...
	AutomaticTuningOptionModeDesiredOn AutomaticTuningOptionModeDesired = "On"
)

// PossibleAutomaticTuningOptionModeDesiredValues returns an array of possible values for the AutomaticTuningOptionModeDesired const type.
func PossibleAutomaticTuningOptionModeDesiredValues() []AutomaticTuningOptionModeDesired {
	return []AutomaticTuningOptionModeDesired{AutomaticTuningOptionModeDesiredDefault, AutomaticTuningOptionModeDesiredOff, AutomaticTuningOptionModeDesiredOn}
}

// AutomaticTuningServerMode enumerates the values for automatic tuning server mode.
type AutomaticTuningServerMode string

const (
	// AutomaticTuningServerModeAuto ...
	AutomaticTuningServerModeAuto AutomaticTuningServerMode = "Auto"
	// AutomaticTuningServerModeCustom ...
	AutomaticTuningServerModeCustom AutomaticTuningServerMode = "Custom"
	// AutomaticTuningServerModeUnspecified ...
	AutomaticTuningServerModeUnspecified AutomaticTuningServerMode = "Unspecified"
)

// PossibleAutomaticTuningServerModeValues returns an array of possible values for the AutomaticTuningServerMode const type.
func PossibleAutomaticTuningServerModeValues() []AutomaticTuningServerMode {
	return []AutomaticTuningServerMode{AutomaticTuningServerModeAuto, AutomaticTuningServerModeCustom, AutomaticTuningServerModeUnspecified}
}

// AutomaticTuningServerReason enumerates the values for automatic tuning server reason.
type AutomaticTuningServerReason string

const (
	// AutomaticTuningServerReasonAutoConfigured ...
	AutomaticTuningServerReasonAutoConfigured AutomaticTuningServerReason = "AutoConfigured"
	// AutomaticTuningServerReasonDefault ...
	AutomaticTuningServerReasonDefault AutomaticTuningServerReason = "Default"
	// AutomaticTuningServerReasonDisabled ...
	AutomaticTuningServerReasonDisabled AutomaticTuningServerReason = "Disabled"
)

// PossibleAutomaticTuningServerReasonValues returns an array of possible values for the AutomaticTuningServerReason const type.
func PossibleAutomaticTuningServerReasonValues() []AutomaticTuningServerReason {
	return []AutomaticTuningServerReason{AutomaticTuningServerReasonAutoConfigured, AutomaticTuningServerReasonDefault, AutomaticTuningServerReasonDisabled}
}

// BackupStorageRedundancy enumerates the values for backup storage redundancy.
type BackupStorageRedundancy string

const (
	// BackupStorageRedundancyGeo ...
	BackupStorageRedundancyGeo BackupStorageRedundancy = "Geo"
	// BackupStorageRedundancyLocal ...
	BackupStorageRedundancyLocal BackupStorageRedundancy = "Local"
	// BackupStorageRedundancyZone ...
	BackupStorageRedundancyZone BackupStorageRedundancy = "Zone"
)

// PossibleBackupStorageRedundancyValues returns an array of possible values for the BackupStorageRedundancy const type.
func PossibleBackupStorageRedundancyValues() []BackupStorageRedundancy {
	return []BackupStorageRedundancy{BackupStorageRedundancyGeo, BackupStorageRedundancyLocal, BackupStorageRedundancyZone}
}

// BackupStorageRedundancy1 enumerates the values for backup storage redundancy 1.
type BackupStorageRedundancy1 string

const (
	// BackupStorageRedundancy1Geo ...
	BackupStorageRedundancy1Geo BackupStorageRedundancy1 = "Geo"
	// BackupStorageRedundancy1Local ...
	BackupStorageRedundancy1Local BackupStorageRedundancy1 = "Local"
	// BackupStorageRedundancy1Zone ...
	BackupStorageRedundancy1Zone BackupStorageRedundancy1 = "Zone"
)

// PossibleBackupStorageRedundancy1Values returns an array of possible values for the BackupStorageRedundancy1 const type.
func PossibleBackupStorageRedundancy1Values() []BackupStorageRedundancy1 {
	return []BackupStorageRedundancy1{BackupStorageRedundancy1Geo, BackupStorageRedundancy1Local, BackupStorageRedundancy1Zone}
}

// BlobAuditingPolicyState enumerates the values for blob auditing policy state.
type BlobAuditingPolicyState string

const (
	// BlobAuditingPolicyStateDisabled ...
	BlobAuditingPolicyStateDisabled BlobAuditingPolicyState = "Disabled"
	// BlobAuditingPolicyStateEnabled ...
	BlobAuditingPolicyStateEnabled BlobAuditingPolicyState = "Enabled"
)

// PossibleBlobAuditingPolicyStateValues returns an array of possible values for the BlobAuditingPolicyState const type.
func PossibleBlobAuditingPolicyStateValues() []BlobAuditingPolicyState {
	return []BlobAuditingPolicyState{BlobAuditingPolicyStateDisabled, BlobAuditingPolicyStateEnabled}
}

// CapabilityGroup enumerates the values for capability group.
type CapabilityGroup string

const (
	// CapabilityGroupSupportedEditions ...
	CapabilityGroupSupportedEditions CapabilityGroup = "supportedEditions"
	// CapabilityGroupSupportedElasticPoolEditions ...
	CapabilityGroupSupportedElasticPoolEditions CapabilityGroup = "supportedElasticPoolEditions"
	// CapabilityGroupSupportedInstancePoolEditions ...
	CapabilityGroupSupportedInstancePoolEditions CapabilityGroup = "supportedInstancePoolEditions"
	// CapabilityGroupSupportedManagedInstanceEditions ...
	CapabilityGroupSupportedManagedInstanceEditions CapabilityGroup = "supportedManagedInstanceEditions"
	// CapabilityGroupSupportedManagedInstanceVersions ...
	CapabilityGroupSupportedManagedInstanceVersions CapabilityGroup = "supportedManagedInstanceVersions"
)

// PossibleCapabilityGroupValues returns an array of possible values for the CapabilityGroup const type.
func PossibleCapabilityGroupValues() []CapabilityGroup {
	return []CapabilityGroup{CapabilityGroupSupportedEditions, CapabilityGroupSupportedElasticPoolEditions, CapabilityGroupSupportedInstancePoolEditions, CapabilityGroupSupportedManagedInstanceEditions, CapabilityGroupSupportedManagedInstanceVersions}
}

// CapabilityStatus enumerates the values for capability status.
type CapabilityStatus string

const (
	// CapabilityStatusAvailable ...
	CapabilityStatusAvailable CapabilityStatus = "Available"
	// CapabilityStatusDefault ...
	CapabilityStatusDefault CapabilityStatus = "Default"
	// CapabilityStatusDisabled ...
	CapabilityStatusDisabled CapabilityStatus = "Disabled"
	// CapabilityStatusVisible ...
	CapabilityStatusVisible CapabilityStatus = "Visible"
)

// PossibleCapabilityStatusValues returns an array of possible values for the CapabilityStatus const type.
func PossibleCapabilityStatusValues() []CapabilityStatus {
	return []CapabilityStatus{CapabilityStatusAvailable, CapabilityStatusDefault, CapabilityStatusDisabled, CapabilityStatusVisible}
}

// CatalogCollationType enumerates the values for catalog collation type.
type CatalogCollationType string

const (
	// CatalogCollationTypeDATABASEDEFAULT ...
	CatalogCollationTypeDATABASEDEFAULT CatalogCollationType = "DATABASE_DEFAULT"
	// CatalogCollationTypeSQLLatin1GeneralCP1CIAS ...
	CatalogCollationTypeSQLLatin1GeneralCP1CIAS CatalogCollationType = "SQL_Latin1_General_CP1_CI_AS"
)

// PossibleCatalogCollationTypeValues returns an array of possible values for the CatalogCollationType const type.
func PossibleCatalogCollationTypeValues() []CatalogCollationType {
	return []CatalogCollationType{CatalogCollationTypeDATABASEDEFAULT, CatalogCollationTypeSQLLatin1GeneralCP1CIAS}
}

// CheckNameAvailabilityReason enumerates the values for check name availability reason.
type CheckNameAvailabilityReason string

const (
	// CheckNameAvailabilityReasonAlreadyExists ...
	CheckNameAvailabilityReasonAlreadyExists CheckNameAvailabilityReason = "AlreadyExists"
	// CheckNameAvailabilityReasonInvalid ...
	CheckNameAvailabilityReasonInvalid CheckNameAvailabilityReason = "Invalid"
)

// PossibleCheckNameAvailabilityReasonValues returns an array of possible values for the CheckNameAvailabilityReason const type.
func PossibleCheckNameAvailabilityReasonValues() []CheckNameAvailabilityReason {
	return []CheckNameAvailabilityReason{CheckNameAvailabilityReasonAlreadyExists, CheckNameAvailabilityReasonInvalid}
}

// ColumnDataType enumerates the values for column data type.
type ColumnDataType string

const (
	// ColumnDataTypeBigint ...
	ColumnDataTypeBigint ColumnDataType = "bigint"
	// ColumnDataTypeBinary ...
	ColumnDataTypeBinary ColumnDataType = "binary"
	// ColumnDataTypeBit ...
	ColumnDataTypeBit ColumnDataType = "bit"
	// ColumnDataTypeChar ...
	ColumnDataTypeChar ColumnDataType = "char"
	// ColumnDataTypeDate ...
	ColumnDataTypeDate ColumnDataType = "date"
	// ColumnDataTypeDatetime ...
	ColumnDataTypeDatetime ColumnDataType = "datetime"
	// ColumnDataTypeDatetime2 ...
	ColumnDataTypeDatetime2 ColumnDataType = "datetime2"
	// ColumnDataTypeDatetimeoffset ...
	ColumnDataTypeDatetimeoffset ColumnDataType = "datetimeoffset"
	// ColumnDataTypeDecimal ...
	ColumnDataTypeDecimal ColumnDataType = "decimal"
	// ColumnDataTypeFloat ...
	ColumnDataTypeFloat ColumnDataType = "float"
	// ColumnDataTypeGeography ...
	ColumnDataTypeGeography ColumnDataType = "geography"
	// ColumnDataTypeGeometry ...
	ColumnDataTypeGeometry ColumnDataType = "geometry"
	// ColumnDataTypeHierarchyid ...
	ColumnDataTypeHierarchyid ColumnDataType = "hierarchyid"
	// ColumnDataTypeImage ...
	ColumnDataTypeImage ColumnDataType = "image"
	// ColumnDataTypeInt ...
	ColumnDataTypeInt ColumnDataType = "int"
	// ColumnDataTypeMoney ...
	ColumnDataTypeMoney ColumnDataType = "money"
	// ColumnDataTypeNchar ...
	ColumnDataTypeNchar ColumnDataType = "nchar"
	// ColumnDataTypeNtext ...
	ColumnDataTypeNtext ColumnDataType = "ntext"
	// ColumnDataTypeNumeric ...
	ColumnDataTypeNumeric ColumnDataType = "numeric"
	// ColumnDataTypeNvarchar ...
	ColumnDataTypeNvarchar ColumnDataType = "nvarchar"
	// ColumnDataTypeReal ...
	ColumnDataTypeReal ColumnDataType = "real"
	// ColumnDataTypeSmalldatetime ...
	ColumnDataTypeSmalldatetime ColumnDataType = "smalldatetime"
	// ColumnDataTypeSmallint ...
	ColumnDataTypeSmallint ColumnDataType = "smallint"
	// ColumnDataTypeSmallmoney ...
	ColumnDataTypeSmallmoney ColumnDataType = "smallmoney"
	// ColumnDataTypeSQLVariant ...
	ColumnDataTypeSQLVariant ColumnDataType = "sql_variant"
	// ColumnDataTypeSysname ...
	ColumnDataTypeSysname ColumnDataType = "sysname"
	// ColumnDataTypeText ...
	ColumnDataTypeText ColumnDataType = "text"
	// ColumnDataTypeTime ...
	ColumnDataTypeTime ColumnDataType = "time"
	// ColumnDataTypeTimestamp ...
	ColumnDataTypeTimestamp ColumnDataType = "timestamp"
	// ColumnDataTypeTinyint ...
	ColumnDataTypeTinyint ColumnDataType = "tinyint"
	// ColumnDataTypeUniqueidentifier ...
	ColumnDataTypeUniqueidentifier ColumnDataType = "uniqueidentifier"
	// ColumnDataTypeVarbinary ...
	ColumnDataTypeVarbinary ColumnDataType = "varbinary"
	// ColumnDataTypeVarchar ...
	ColumnDataTypeVarchar ColumnDataType = "varchar"
	// ColumnDataTypeXML ...
	ColumnDataTypeXML ColumnDataType = "xml"
)

// PossibleColumnDataTypeValues returns an array of possible values for the ColumnDataType const type.
func PossibleColumnDataTypeValues() []ColumnDataType {
	return []ColumnDataType{ColumnDataTypeBigint, ColumnDataTypeBinary, ColumnDataTypeBit, ColumnDataTypeChar, ColumnDataTypeDate, ColumnDataTypeDatetime, ColumnDataTypeDatetime2, ColumnDataTypeDatetimeoffset, ColumnDataTypeDecimal, ColumnDataTypeFloat, ColumnDataTypeGeography, ColumnDataTypeGeometry, ColumnDataTypeHierarchyid, ColumnDataTypeImage, ColumnDataTypeInt, ColumnDataTypeMoney, ColumnDataTypeNchar, ColumnDataTypeNtext, ColumnDataTypeNumeric, ColumnDataTypeNvarchar, ColumnDataTypeReal, ColumnDataTypeSmalldatetime, ColumnDataTypeSmallint, ColumnDataTypeSmallmoney, ColumnDataTypeSQLVariant, ColumnDataTypeSysname, ColumnDataTypeText, ColumnDataTypeTime, ColumnDataTypeTimestamp, ColumnDataTypeTinyint, ColumnDataTypeUniqueidentifier, ColumnDataTypeVarbinary, ColumnDataTypeVarchar, ColumnDataTypeXML}
}

// CreatedByType enumerates the values for created by type.
type CreatedByType string

const (
	// CreatedByTypeApplication ...
	CreatedByTypeApplication CreatedByType = "Application"
	// CreatedByTypeKey ...
	CreatedByTypeKey CreatedByType = "Key"
	// CreatedByTypeManagedIdentity ...
	CreatedByTypeManagedIdentity CreatedByType = "ManagedIdentity"
	// CreatedByTypeUser ...
	CreatedByTypeUser CreatedByType = "User"
)

// PossibleCreatedByTypeValues returns an array of possible values for the CreatedByType const type.
func PossibleCreatedByTypeValues() []CreatedByType {
	return []CreatedByType{CreatedByTypeApplication, CreatedByTypeKey, CreatedByTypeManagedIdentity, CreatedByTypeUser}
}

// CreateMode enumerates the values for create mode.
type CreateMode string

const (
	// CreateModeCopy ...
	CreateModeCopy CreateMode = "Copy"
	// CreateModeDefault ...
	CreateModeDefault CreateMode = "Default"
	// CreateModeOnlineSecondary ...
	CreateModeOnlineSecondary CreateMode = "OnlineSecondary"
	// CreateModePointInTimeRestore ...
	CreateModePointInTimeRestore CreateMode = "PointInTimeRestore"
	// CreateModeRecovery ...
	CreateModeRecovery CreateMode = "Recovery"
	// CreateModeRestore ...
	CreateModeRestore CreateMode = "Restore"
	// CreateModeRestoreExternalBackup ...
	CreateModeRestoreExternalBackup CreateMode = "RestoreExternalBackup"
	// CreateModeRestoreExternalBackupSecondary ...
	CreateModeRestoreExternalBackupSecondary CreateMode = "RestoreExternalBackupSecondary"
	// CreateModeRestoreLongTermRetentionBackup ...
	CreateModeRestoreLongTermRetentionBackup CreateMode = "RestoreLongTermRetentionBackup"
	// CreateModeSecondary ...
	CreateModeSecondary CreateMode = "Secondary"
)

// PossibleCreateModeValues returns an array of possible values for the CreateMode const type.
func PossibleCreateModeValues() []CreateMode {
	return []CreateMode{CreateModeCopy, CreateModeDefault, CreateModeOnlineSecondary, CreateModePointInTimeRestore, CreateModeRecovery, CreateModeRestore, CreateModeRestoreExternalBackup, CreateModeRestoreExternalBackupSecondary, CreateModeRestoreLongTermRetentionBackup, CreateModeSecondary}
}

// CurrentBackupStorageRedundancy enumerates the values for current backup storage redundancy.
type CurrentBackupStorageRedundancy string

const (
	// CurrentBackupStorageRedundancyGeo ...
	CurrentBackupStorageRedundancyGeo CurrentBackupStorageRedundancy = "Geo"
	// CurrentBackupStorageRedundancyLocal ...
	CurrentBackupStorageRedundancyLocal CurrentBackupStorageRedundancy = "Local"
	// CurrentBackupStorageRedundancyZone ...
	CurrentBackupStorageRedundancyZone CurrentBackupStorageRedundancy = "Zone"
)

// PossibleCurrentBackupStorageRedundancyValues returns an array of possible values for the CurrentBackupStorageRedundancy const type.
func PossibleCurrentBackupStorageRedundancyValues() []CurrentBackupStorageRedundancy {
	return []CurrentBackupStorageRedundancy{CurrentBackupStorageRedundancyGeo, CurrentBackupStorageRedundancyLocal, CurrentBackupStorageRedundancyZone}
}

// DatabaseLicenseType enumerates the values for database license type.
type DatabaseLicenseType string

const (
	// DatabaseLicenseTypeBasePrice ...
	DatabaseLicenseTypeBasePrice DatabaseLicenseType = "BasePrice"
	// DatabaseLicenseTypeLicenseIncluded ...
	DatabaseLicenseTypeLicenseIncluded DatabaseLicenseType = "LicenseIncluded"
)

// PossibleDatabaseLicenseTypeValues returns an array of possible values for the DatabaseLicenseType const type.
func PossibleDatabaseLicenseTypeValues() []DatabaseLicenseType {
	return []DatabaseLicenseType{DatabaseLicenseTypeBasePrice, DatabaseLicenseTypeLicenseIncluded}
}

// DatabaseReadScale enumerates the values for database read scale.
type DatabaseReadScale string

const (
	// DatabaseReadScaleDisabled ...
	DatabaseReadScaleDisabled DatabaseReadScale = "Disabled"
	// DatabaseReadScaleEnabled ...
	DatabaseReadScaleEnabled DatabaseReadScale = "Enabled"
)

// PossibleDatabaseReadScaleValues returns an array of possible values for the DatabaseReadScale const type.
func PossibleDatabaseReadScaleValues() []DatabaseReadScale {
	return []DatabaseReadScale{DatabaseReadScaleDisabled, DatabaseReadScaleEnabled}
}

// DatabaseState enumerates the values for database state.
type DatabaseState string

const (
	// DatabaseStateAll ...
	DatabaseStateAll DatabaseState = "All"
	// DatabaseStateDeleted ...
	DatabaseStateDeleted DatabaseState = "Deleted"
	// DatabaseStateLive ...
	DatabaseStateLive DatabaseState = "Live"
)

// PossibleDatabaseStateValues returns an array of possible values for the DatabaseState const type.
func PossibleDatabaseStateValues() []DatabaseState {
	return []DatabaseState{DatabaseStateAll, DatabaseStateDeleted, DatabaseStateLive}
}

// DatabaseStatus enumerates the values for database status.
type DatabaseStatus string

const (
	// DatabaseStatusAutoClosed ...
	DatabaseStatusAutoClosed DatabaseStatus = "AutoClosed"
	// DatabaseStatusCopying ...
	DatabaseStatusCopying DatabaseStatus = "Copying"
	// DatabaseStatusCreating ...
	DatabaseStatusCreating DatabaseStatus = "Creating"
	// DatabaseStatusDisabled ...
	DatabaseStatusDisabled DatabaseStatus = "Disabled"
	// DatabaseStatusEmergencyMode ...
	DatabaseStatusEmergencyMode DatabaseStatus = "EmergencyMode"
	// DatabaseStatusInaccessible ...
	DatabaseStatusInaccessible DatabaseStatus = "Inaccessible"
	// DatabaseStatusOffline ...
	DatabaseStatusOffline DatabaseStatus = "Offline"
	// DatabaseStatusOfflineChangingDwPerformanceTiers ...
	DatabaseStatusOfflineChangingDwPerformanceTiers DatabaseStatus = "OfflineChangingDwPerformanceTiers"
	// DatabaseStatusOfflineSecondary ...
	DatabaseStatusOfflineSecondary DatabaseStatus = "OfflineSecondary"
	// DatabaseStatusOnline ...
	DatabaseStatusOnline DatabaseStatus = "Online"
	// DatabaseStatusOnlineChangingDwPerformanceTiers ...
	DatabaseStatusOnlineChangingDwPerformanceTiers DatabaseStatus = "OnlineChangingDwPerformanceTiers"
	// DatabaseStatusPaused ...
	DatabaseStatusPaused DatabaseStatus = "Paused"
	// DatabaseStatusPausing ...
	DatabaseStatusPausing DatabaseStatus = "Pausing"
	// DatabaseStatusRecovering ...
	DatabaseStatusRecovering DatabaseStatus = "Recovering"
	// DatabaseStatusRecoveryPending ...
	DatabaseStatusRecoveryPending DatabaseStatus = "RecoveryPending"
	// DatabaseStatusRestoring ...
	DatabaseStatusRestoring DatabaseStatus = "Restoring"
	// DatabaseStatusResuming ...
	DatabaseStatusResuming DatabaseStatus = "Resuming"
	// DatabaseStatusScaling ...
	DatabaseStatusScaling DatabaseStatus = "Scaling"
	// DatabaseStatusShutdown ...
	DatabaseStatusShutdown DatabaseStatus = "Shutdown"
	// DatabaseStatusStandby ...
	DatabaseStatusStandby DatabaseStatus = "Standby"
	// DatabaseStatusSuspect ...
	DatabaseStatusSuspect DatabaseStatus = "Suspect"
)

// PossibleDatabaseStatusValues returns an array of possible values for the DatabaseStatus const type.
func PossibleDatabaseStatusValues() []DatabaseStatus {
	return []DatabaseStatus{DatabaseStatusAutoClosed, DatabaseStatusCopying, DatabaseStatusCreating, DatabaseStatusDisabled, DatabaseStatusEmergencyMode, DatabaseStatusInaccessible, DatabaseStatusOffline, DatabaseStatusOfflineChangingDwPerformanceTiers, DatabaseStatusOfflineSecondary, DatabaseStatusOnline, DatabaseStatusOnlineChangingDwPerformanceTiers, DatabaseStatusPaused, DatabaseStatusPausing, DatabaseStatusRecovering, DatabaseStatusRecoveryPending, DatabaseStatusRestoring, DatabaseStatusResuming, DatabaseStatusScaling, DatabaseStatusShutdown, DatabaseStatusStandby, DatabaseStatusSuspect}
}

// DataMaskingFunction enumerates the values for data masking function.
type DataMaskingFunction string

const (
	// DataMaskingFunctionCCN ...
	DataMaskingFunctionCCN DataMaskingFunction = "CCN"
	// DataMaskingFunctionDefault ...
	DataMaskingFunctionDefault DataMaskingFunction = "Default"
	// DataMaskingFunctionEmail ...
	DataMaskingFunctionEmail DataMaskingFunction = "Email"
	// DataMaskingFunctionNumber ...
	DataMaskingFunctionNumber DataMaskingFunction = "Number"
	// DataMaskingFunctionSSN ...
	DataMaskingFunctionSSN DataMaskingFunction = "SSN"
	// DataMaskingFunctionText ...
	DataMaskingFunctionText DataMaskingFunction = "Text"
)

// PossibleDataMaskingFunctionValues returns an array of possible values for the DataMaskingFunction const type.
func PossibleDataMaskingFunctionValues() []DataMaskingFunction {
	return []DataMaskingFunction{DataMaskingFunctionCCN, DataMaskingFunctionDefault, DataMaskingFunctionEmail, DataMaskingFunctionNumber, DataMaskingFunctionSSN, DataMaskingFunctionText}
}

// DataMaskingRuleState enumerates the values for data masking rule state.
type DataMaskingRuleState string

const (
	// DataMaskingRuleStateDisabled ...
	DataMaskingRuleStateDisabled DataMaskingRuleState = "Disabled"
	// DataMaskingRuleStateEnabled ...
	DataMaskingRuleStateEnabled DataMaskingRuleState = "Enabled"
)

// PossibleDataMaskingRuleStateValues returns an array of possible values for the DataMaskingRuleState const type.
func PossibleDataMaskingRuleStateValues() []DataMaskingRuleState {
	return []DataMaskingRuleState{DataMaskingRuleStateDisabled, DataMaskingRuleStateEnabled}
}

// DataMaskingState enumerates the values for data masking state.
type DataMaskingState string

const (
	// DataMaskingStateDisabled ...
	DataMaskingStateDisabled DataMaskingState = "Disabled"
	// DataMaskingStateEnabled ...
	DataMaskingStateEnabled DataMaskingState = "Enabled"
)

// PossibleDataMaskingStateValues returns an array of possible values for the DataMaskingState const type.
func PossibleDataMaskingStateValues() []DataMaskingState {
	return []DataMaskingState{DataMaskingStateDisabled, DataMaskingStateEnabled}
}

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// DayOfWeekFriday ...
	DayOfWeekFriday DayOfWeek = "Friday"
	// DayOfWeekMonday ...
	DayOfWeekMonday DayOfWeek = "Monday"
	// DayOfWeekSaturday ...
	DayOfWeekSaturday DayOfWeek = "Saturday"
	// DayOfWeekSunday ...
	DayOfWeekSunday DayOfWeek = "Sunday"
	// DayOfWeekThursday ...
	DayOfWeekThursday DayOfWeek = "Thursday"
	// DayOfWeekTuesday ...
	DayOfWeekTuesday DayOfWeek = "Tuesday"
	// DayOfWeekWednesday ...
	DayOfWeekWednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{DayOfWeekFriday, DayOfWeekMonday, DayOfWeekSaturday, DayOfWeekSunday, DayOfWeekThursday, DayOfWeekTuesday, DayOfWeekWednesday}
}

// ElasticPoolLicenseType enumerates the values for elastic pool license type.
type ElasticPoolLicenseType string

const (
	// ElasticPoolLicenseTypeBasePrice ...
	ElasticPoolLicenseTypeBasePrice ElasticPoolLicenseType = "BasePrice"
	// ElasticPoolLicenseTypeLicenseIncluded ...
	ElasticPoolLicenseTypeLicenseIncluded ElasticPoolLicenseType = "LicenseIncluded"
)

// PossibleElasticPoolLicenseTypeValues returns an array of possible values for the ElasticPoolLicenseType const type.
func PossibleElasticPoolLicenseTypeValues() []ElasticPoolLicenseType {
	return []ElasticPoolLicenseType{ElasticPoolLicenseTypeBasePrice, ElasticPoolLicenseTypeLicenseIncluded}
}

// ElasticPoolState enumerates the values for elastic pool state.
type ElasticPoolState string

const (
	// ElasticPoolStateCreating ...
	ElasticPoolStateCreating ElasticPoolState = "Creating"
	// ElasticPoolStateDisabled ...
	ElasticPoolStateDisabled ElasticPoolState = "Disabled"
	// ElasticPoolStateReady ...
	ElasticPoolStateReady ElasticPoolState = "Ready"
)

// PossibleElasticPoolStateValues returns an array of possible values for the ElasticPoolState const type.
func PossibleElasticPoolStateValues() []ElasticPoolState {
	return []ElasticPoolState{ElasticPoolStateCreating, ElasticPoolStateDisabled, ElasticPoolStateReady}
}

// FailoverGroupReplicationRole enumerates the values for failover group replication role.
type FailoverGroupReplicationRole string

const (
	// FailoverGroupReplicationRolePrimary ...
	FailoverGroupReplicationRolePrimary FailoverGroupReplicationRole = "Primary"
	// FailoverGroupReplicationRoleSecondary ...
	FailoverGroupReplicationRoleSecondary FailoverGroupReplicationRole = "Secondary"
)

// PossibleFailoverGroupReplicationRoleValues returns an array of possible values for the FailoverGroupReplicationRole const type.
func PossibleFailoverGroupReplicationRoleValues() []FailoverGroupReplicationRole {
	return []FailoverGroupReplicationRole{FailoverGroupReplicationRolePrimary, FailoverGroupReplicationRoleSecondary}
}

// GeoBackupPolicyState enumerates the values for geo backup policy state.
type GeoBackupPolicyState string

const (
	// GeoBackupPolicyStateDisabled ...
	GeoBackupPolicyStateDisabled GeoBackupPolicyState = "Disabled"
	// GeoBackupPolicyStateEnabled ...
	GeoBackupPolicyStateEnabled GeoBackupPolicyState = "Enabled"
)

// PossibleGeoBackupPolicyStateValues returns an array of possible values for the GeoBackupPolicyState const type.
func PossibleGeoBackupPolicyStateValues() []GeoBackupPolicyState {
	return []GeoBackupPolicyState{GeoBackupPolicyStateDisabled, GeoBackupPolicyStateEnabled}
}

// IdentityType enumerates the values for identity type.
type IdentityType string

const (
	// IdentityTypeNone ...
	IdentityTypeNone IdentityType = "None"
	// IdentityTypeSystemAssigned ...
	IdentityTypeSystemAssigned IdentityType = "SystemAssigned"
	// IdentityTypeUserAssigned ...
	IdentityTypeUserAssigned IdentityType = "UserAssigned"
)

// PossibleIdentityTypeValues returns an array of possible values for the IdentityType const type.
func PossibleIdentityTypeValues() []IdentityType {
	return []IdentityType{IdentityTypeNone, IdentityTypeSystemAssigned, IdentityTypeUserAssigned}
}

// ImplementationMethod enumerates the values for implementation method.
type ImplementationMethod string

const (
	// ImplementationMethodAzurePowerShell ...
	ImplementationMethodAzurePowerShell ImplementationMethod = "AzurePowerShell"
	// ImplementationMethodTSQL ...
	ImplementationMethodTSQL ImplementationMethod = "TSql"
)

// PossibleImplementationMethodValues returns an array of possible values for the ImplementationMethod const type.
func PossibleImplementationMethodValues() []ImplementationMethod {
	return []ImplementationMethod{ImplementationMethodAzurePowerShell, ImplementationMethodTSQL}
}

// InstanceFailoverGroupReplicationRole enumerates the values for instance failover group replication role.
type InstanceFailoverGroupReplicationRole string

const (
	// InstanceFailoverGroupReplicationRolePrimary ...
	InstanceFailoverGroupReplicationRolePrimary InstanceFailoverGroupReplicationRole = "Primary"
	// InstanceFailoverGroupReplicationRoleSecondary ...
	InstanceFailoverGroupReplicationRoleSecondary InstanceFailoverGroupReplicationRole = "Secondary"
)

// PossibleInstanceFailoverGroupReplicationRoleValues returns an array of possible values for the InstanceFailoverGroupReplicationRole const type.
func PossibleInstanceFailoverGroupReplicationRoleValues() []InstanceFailoverGroupReplicationRole {
	return []InstanceFailoverGroupReplicationRole{InstanceFailoverGroupReplicationRolePrimary, InstanceFailoverGroupReplicationRoleSecondary}
}

// InstancePoolLicenseType enumerates the values for instance pool license type.
type InstancePoolLicenseType string

const (
	// InstancePoolLicenseTypeBasePrice ...
	InstancePoolLicenseTypeBasePrice InstancePoolLicenseType = "BasePrice"
	// InstancePoolLicenseTypeLicenseIncluded ...
	InstancePoolLicenseTypeLicenseIncluded InstancePoolLicenseType = "LicenseIncluded"
)

// PossibleInstancePoolLicenseTypeValues returns an array of possible values for the InstancePoolLicenseType const type.
func PossibleInstancePoolLicenseTypeValues() []InstancePoolLicenseType {
	return []InstancePoolLicenseType{InstancePoolLicenseTypeBasePrice, InstancePoolLicenseTypeLicenseIncluded}
}

// IsRetryable enumerates the values for is retryable.
type IsRetryable string

const (
	// IsRetryableNo ...
	IsRetryableNo IsRetryable = "No"
	// IsRetryableYes ...
	IsRetryableYes IsRetryable = "Yes"
)

// PossibleIsRetryableValues returns an array of possible values for the IsRetryable const type.
func PossibleIsRetryableValues() []IsRetryable {
	return []IsRetryable{IsRetryableNo, IsRetryableYes}
}

// JobAgentState enumerates the values for job agent state.
type JobAgentState string

const (
	// JobAgentStateCreating ...
	JobAgentStateCreating JobAgentState = "Creating"
	// JobAgentStateDeleting ...
	JobAgentStateDeleting JobAgentState = "Deleting"
	// JobAgentStateDisabled ...
	JobAgentStateDisabled JobAgentState = "Disabled"
	// JobAgentStateReady ...
	JobAgentStateReady JobAgentState = "Ready"
	// JobAgentStateUpdating ...
	JobAgentStateUpdating JobAgentState = "Updating"
)

// PossibleJobAgentStateValues returns an array of possible values for the JobAgentState const type.
func PossibleJobAgentStateValues() []JobAgentState {
	return []JobAgentState{JobAgentStateCreating, JobAgentStateDeleting, JobAgentStateDisabled, JobAgentStateReady, JobAgentStateUpdating}
}

// JobExecutionLifecycle enumerates the values for job execution lifecycle.
type JobExecutionLifecycle string

const (
	// JobExecutionLifecycleCanceled ...
	JobExecutionLifecycleCanceled JobExecutionLifecycle = "Canceled"
	// JobExecutionLifecycleCreated ...
	JobExecutionLifecycleCreated JobExecutionLifecycle = "Created"
	// JobExecutionLifecycleFailed ...
	JobExecutionLifecycleFailed JobExecutionLifecycle = "Failed"
	// JobExecutionLifecycleInProgress ...
	JobExecutionLifecycleInProgress JobExecutionLifecycle = "InProgress"
	// JobExecutionLifecycleSkipped ...
	JobExecutionLifecycleSkipped JobExecutionLifecycle = "Skipped"
	// JobExecutionLifecycleSucceeded ...
	JobExecutionLifecycleSucceeded JobExecutionLifecycle = "Succeeded"
	// JobExecutionLifecycleSucceededWithSkipped ...
	JobExecutionLifecycleSucceededWithSkipped JobExecutionLifecycle = "SucceededWithSkipped"
	// JobExecutionLifecycleTimedOut ...
	JobExecutionLifecycleTimedOut JobExecutionLifecycle = "TimedOut"
	// JobExecutionLifecycleWaitingForChildJobExecutions ...
	JobExecutionLifecycleWaitingForChildJobExecutions JobExecutionLifecycle = "WaitingForChildJobExecutions"
	// JobExecutionLifecycleWaitingForRetry ...
	JobExecutionLifecycleWaitingForRetry JobExecutionLifecycle = "WaitingForRetry"
)

// PossibleJobExecutionLifecycleValues returns an array of possible values for the JobExecutionLifecycle const type.
func PossibleJobExecutionLifecycleValues() []JobExecutionLifecycle {
	return []JobExecutionLifecycle{JobExecutionLifecycleCanceled, JobExecutionLifecycleCreated, JobExecutionLifecycleFailed, JobExecutionLifecycleInProgress, JobExecutionLifecycleSkipped, JobExecutionLifecycleSucceeded, JobExecutionLifecycleSucceededWithSkipped, JobExecutionLifecycleTimedOut, JobExecutionLifecycleWaitingForChildJobExecutions, JobExecutionLifecycleWaitingForRetry}
}

// JobScheduleType enumerates the values for job schedule type.
type JobScheduleType string

const (
	// JobScheduleTypeOnce ...
	JobScheduleTypeOnce JobScheduleType = "Once"
	// JobScheduleTypeRecurring ...
	JobScheduleTypeRecurring JobScheduleType = "Recurring"
)

// PossibleJobScheduleTypeValues returns an array of possible values for the JobScheduleType const type.
func PossibleJobScheduleTypeValues() []JobScheduleType {
	return []JobScheduleType{JobScheduleTypeOnce, JobScheduleTypeRecurring}
}

// JobStepActionSource enumerates the values for job step action source.
type JobStepActionSource string

const (
	// JobStepActionSourceInline ...
	JobStepActionSourceInline JobStepActionSource = "Inline"
)

// PossibleJobStepActionSourceValues returns an array of possible values for the JobStepActionSource const type.
func PossibleJobStepActionSourceValues() []JobStepActionSource {
	return []JobStepActionSource{JobStepActionSourceInline}
}

// JobStepActionType enumerates the values for job step action type.
type JobStepActionType string

const (
	// JobStepActionTypeTSQL ...
	JobStepActionTypeTSQL JobStepActionType = "TSql"
)

// PossibleJobStepActionTypeValues returns an array of possible values for the JobStepActionType const type.
func PossibleJobStepActionTypeValues() []JobStepActionType {
	return []JobStepActionType{JobStepActionTypeTSQL}
}

// JobStepOutputType enumerates the values for job step output type.
type JobStepOutputType string

const (
	// JobStepOutputTypeSQLDatabase ...
	JobStepOutputTypeSQLDatabase JobStepOutputType = "SqlDatabase"
)

// PossibleJobStepOutputTypeValues returns an array of possible values for the JobStepOutputType const type.
func PossibleJobStepOutputTypeValues() []JobStepOutputType {
	return []JobStepOutputType{JobStepOutputTypeSQLDatabase}
}

// JobTargetGroupMembershipType enumerates the values for job target group membership type.
type JobTargetGroupMembershipType string

const (
	// JobTargetGroupMembershipTypeExclude ...
	JobTargetGroupMembershipTypeExclude JobTargetGroupMembershipType = "Exclude"
	// JobTargetGroupMembershipTypeInclude ...
	JobTargetGroupMembershipTypeInclude JobTargetGroupMembershipType = "Include"
)

// PossibleJobTargetGroupMembershipTypeValues returns an array of possible values for the JobTargetGroupMembershipType const type.
func PossibleJobTargetGroupMembershipTypeValues() []JobTargetGroupMembershipType {
	return []JobTargetGroupMembershipType{JobTargetGroupMembershipTypeExclude, JobTargetGroupMembershipTypeInclude}
}

// JobTargetType enumerates the values for job target type.
type JobTargetType string

const (
	// JobTargetTypeSQLDatabase ...
	JobTargetTypeSQLDatabase JobTargetType = "SqlDatabase"
	// JobTargetTypeSQLElasticPool ...
	JobTargetTypeSQLElasticPool JobTargetType = "SqlElasticPool"
	// JobTargetTypeSQLServer ...
	JobTargetTypeSQLServer JobTargetType = "SqlServer"
	// JobTargetTypeSQLShardMap ...
	JobTargetTypeSQLShardMap JobTargetType = "SqlShardMap"
	// JobTargetTypeTargetGroup ...
	JobTargetTypeTargetGroup JobTargetType = "TargetGroup"
)

// PossibleJobTargetTypeValues returns an array of possible values for the JobTargetType const type.
func PossibleJobTargetTypeValues() []JobTargetType {
	return []JobTargetType{JobTargetTypeSQLDatabase, JobTargetTypeSQLElasticPool, JobTargetTypeSQLServer, JobTargetTypeSQLShardMap, JobTargetTypeTargetGroup}
}

// LedgerDigestUploadsState enumerates the values for ledger digest uploads state.
type LedgerDigestUploadsState string

const (
	// LedgerDigestUploadsStateDisabled ...
	LedgerDigestUploadsStateDisabled LedgerDigestUploadsState = "Disabled"
	// LedgerDigestUploadsStateEnabled ...
	LedgerDigestUploadsStateEnabled LedgerDigestUploadsState = "Enabled"
)

// PossibleLedgerDigestUploadsStateValues returns an array of possible values for the LedgerDigestUploadsState const type.
func PossibleLedgerDigestUploadsStateValues() []LedgerDigestUploadsState {
	return []LedgerDigestUploadsState{LedgerDigestUploadsStateDisabled, LedgerDigestUploadsStateEnabled}
}

// LogSizeUnit enumerates the values for log size unit.
type LogSizeUnit string

const (
	// LogSizeUnitGigabytes ...
	LogSizeUnitGigabytes LogSizeUnit = "Gigabytes"
	// LogSizeUnitMegabytes ...
	LogSizeUnitMegabytes LogSizeUnit = "Megabytes"
	// LogSizeUnitPercent ...
	LogSizeUnitPercent LogSizeUnit = "Percent"
	// LogSizeUnitPetabytes ...
	LogSizeUnitPetabytes LogSizeUnit = "Petabytes"
	// LogSizeUnitTerabytes ...
	LogSizeUnitTerabytes LogSizeUnit = "Terabytes"
)

// PossibleLogSizeUnitValues returns an array of possible values for the LogSizeUnit const type.
func PossibleLogSizeUnitValues() []LogSizeUnit {
	return []LogSizeUnit{LogSizeUnitGigabytes, LogSizeUnitMegabytes, LogSizeUnitPercent, LogSizeUnitPetabytes, LogSizeUnitTerabytes}
}

// ManagedDatabaseCreateMode enumerates the values for managed database create mode.
type ManagedDatabaseCreateMode string

const (
	// ManagedDatabaseCreateModeDefault ...
	ManagedDatabaseCreateModeDefault ManagedDatabaseCreateMode = "Default"
	// ManagedDatabaseCreateModePointInTimeRestore ...
	ManagedDatabaseCreateModePointInTimeRestore ManagedDatabaseCreateMode = "PointInTimeRestore"
	// ManagedDatabaseCreateModeRecovery ...
	ManagedDatabaseCreateModeRecovery ManagedDatabaseCreateMode = "Recovery"
	// ManagedDatabaseCreateModeRestoreExternalBackup ...
	ManagedDatabaseCreateModeRestoreExternalBackup ManagedDatabaseCreateMode = "RestoreExternalBackup"
	// ManagedDatabaseCreateModeRestoreLongTermRetentionBackup ...
	ManagedDatabaseCreateModeRestoreLongTermRetentionBackup ManagedDatabaseCreateMode = "RestoreLongTermRetentionBackup"
)

// PossibleManagedDatabaseCreateModeValues returns an array of possible values for the ManagedDatabaseCreateMode const type.
func PossibleManagedDatabaseCreateModeValues() []ManagedDatabaseCreateMode {
	return []ManagedDatabaseCreateMode{ManagedDatabaseCreateModeDefault, ManagedDatabaseCreateModePointInTimeRestore, ManagedDatabaseCreateModeRecovery, ManagedDatabaseCreateModeRestoreExternalBackup, ManagedDatabaseCreateModeRestoreLongTermRetentionBackup}
}

// ManagedDatabaseStatus enumerates the values for managed database status.
type ManagedDatabaseStatus string

const (
	// ManagedDatabaseStatusCreating ...
	ManagedDatabaseStatusCreating ManagedDatabaseStatus = "Creating"
	// ManagedDatabaseStatusInaccessible ...
	ManagedDatabaseStatusInaccessible ManagedDatabaseStatus = "Inaccessible"
	// ManagedDatabaseStatusOffline ...
	ManagedDatabaseStatusOffline ManagedDatabaseStatus = "Offline"
	// ManagedDatabaseStatusOnline ...
	ManagedDatabaseStatusOnline ManagedDatabaseStatus = "Online"
	// ManagedDatabaseStatusRestoring ...
	ManagedDatabaseStatusRestoring ManagedDatabaseStatus = "Restoring"
	// ManagedDatabaseStatusShutdown ...
	ManagedDatabaseStatusShutdown ManagedDatabaseStatus = "Shutdown"
	// ManagedDatabaseStatusUpdating ...
	ManagedDatabaseStatusUpdating ManagedDatabaseStatus = "Updating"
)

// PossibleManagedDatabaseStatusValues returns an array of possible values for the ManagedDatabaseStatus const type.
func PossibleManagedDatabaseStatusValues() []ManagedDatabaseStatus {
	return []ManagedDatabaseStatus{ManagedDatabaseStatusCreating, ManagedDatabaseStatusInaccessible, ManagedDatabaseStatusOffline, ManagedDatabaseStatusOnline, ManagedDatabaseStatusRestoring, ManagedDatabaseStatusShutdown, ManagedDatabaseStatusUpdating}
}

// ManagedInstanceLicenseType enumerates the values for managed instance license type.
type ManagedInstanceLicenseType string

const (
	// ManagedInstanceLicenseTypeBasePrice ...
	ManagedInstanceLicenseTypeBasePrice ManagedInstanceLicenseType = "BasePrice"
	// ManagedInstanceLicenseTypeLicenseIncluded ...
	ManagedInstanceLicenseTypeLicenseIncluded ManagedInstanceLicenseType = "LicenseIncluded"
)

// PossibleManagedInstanceLicenseTypeValues returns an array of possible values for the ManagedInstanceLicenseType const type.
func PossibleManagedInstanceLicenseTypeValues() []ManagedInstanceLicenseType {
	return []ManagedInstanceLicenseType{ManagedInstanceLicenseTypeBasePrice, ManagedInstanceLicenseTypeLicenseIncluded}
}

// ManagedInstanceProxyOverride enumerates the values for managed instance proxy override.
type ManagedInstanceProxyOverride string

const (
	// ManagedInstanceProxyOverrideDefault ...
	ManagedInstanceProxyOverrideDefault ManagedInstanceProxyOverride = "Default"
	// ManagedInstanceProxyOverrideProxy ...
	ManagedInstanceProxyOverrideProxy ManagedInstanceProxyOverride = "Proxy"
	// ManagedInstanceProxyOverrideRedirect ...
	ManagedInstanceProxyOverrideRedirect ManagedInstanceProxyOverride = "Redirect"
)

// PossibleManagedInstanceProxyOverrideValues returns an array of possible values for the ManagedInstanceProxyOverride const type.
func PossibleManagedInstanceProxyOverrideValues() []ManagedInstanceProxyOverride {
	return []ManagedInstanceProxyOverride{ManagedInstanceProxyOverrideDefault, ManagedInstanceProxyOverrideProxy, ManagedInstanceProxyOverrideRedirect}
}

// ManagedServerCreateMode enumerates the values for managed server create mode.
type ManagedServerCreateMode string

const (
	// ManagedServerCreateModeDefault ...
	ManagedServerCreateModeDefault ManagedServerCreateMode = "Default"
	// ManagedServerCreateModePointInTimeRestore ...
	ManagedServerCreateModePointInTimeRestore ManagedServerCreateMode = "PointInTimeRestore"
)

// PossibleManagedServerCreateModeValues returns an array of possible values for the ManagedServerCreateMode const type.
func PossibleManagedServerCreateModeValues() []ManagedServerCreateMode {
	return []ManagedServerCreateMode{ManagedServerCreateModeDefault, ManagedServerCreateModePointInTimeRestore}
}

// ManagementOperationState enumerates the values for management operation state.
type ManagementOperationState string

const (
	// ManagementOperationStateCancelInProgress ...
	ManagementOperationStateCancelInProgress ManagementOperationState = "CancelInProgress"
	// ManagementOperationStateCancelled ...
	ManagementOperationStateCancelled ManagementOperationState = "Cancelled"
	// ManagementOperationStateFailed ...
	ManagementOperationStateFailed ManagementOperationState = "Failed"
	// ManagementOperationStateInProgress ...
	ManagementOperationStateInProgress ManagementOperationState = "InProgress"
	// ManagementOperationStatePending ...
	ManagementOperationStatePending ManagementOperationState = "Pending"
	// ManagementOperationStateSucceeded ...
	ManagementOperationStateSucceeded ManagementOperationState = "Succeeded"
)

// PossibleManagementOperationStateValues returns an array of possible values for the ManagementOperationState const type.
func PossibleManagementOperationStateValues() []ManagementOperationState {
	return []ManagementOperationState{ManagementOperationStateCancelInProgress, ManagementOperationStateCancelled, ManagementOperationStateFailed, ManagementOperationStateInProgress, ManagementOperationStatePending, ManagementOperationStateSucceeded}
}

// MaxSizeUnit enumerates the values for max size unit.
type MaxSizeUnit string

const (
	// MaxSizeUnitGigabytes ...
	MaxSizeUnitGigabytes MaxSizeUnit = "Gigabytes"
	// MaxSizeUnitMegabytes ...
	MaxSizeUnitMegabytes MaxSizeUnit = "Megabytes"
	// MaxSizeUnitPetabytes ...
	MaxSizeUnitPetabytes MaxSizeUnit = "Petabytes"
	// MaxSizeUnitTerabytes ...
	MaxSizeUnitTerabytes MaxSizeUnit = "Terabytes"
)

// PossibleMaxSizeUnitValues returns an array of possible values for the MaxSizeUnit const type.
func PossibleMaxSizeUnitValues() []MaxSizeUnit {
	return []MaxSizeUnit{MaxSizeUnitGigabytes, MaxSizeUnitMegabytes, MaxSizeUnitPetabytes, MaxSizeUnitTerabytes}
}

// MetricType enumerates the values for metric type.
type MetricType string

const (
	// MetricTypeCPU ...
	MetricTypeCPU MetricType = "cpu"
	// MetricTypeDtu ...
	MetricTypeDtu MetricType = "dtu"
	// MetricTypeDuration ...
	MetricTypeDuration MetricType = "duration"
	// MetricTypeIo ...
	MetricTypeIo MetricType = "io"
	// MetricTypeLogIo ...
	MetricTypeLogIo MetricType = "logIo"
)

// PossibleMetricTypeValues returns an array of possible values for the MetricType const type.
func PossibleMetricTypeValues() []MetricType {
	return []MetricType{MetricTypeCPU, MetricTypeDtu, MetricTypeDuration, MetricTypeIo, MetricTypeLogIo}
}

// OperationOrigin enumerates the values for operation origin.
type OperationOrigin string

const (
	// OperationOriginSystem ...
	OperationOriginSystem OperationOrigin = "system"
	// OperationOriginUser ...
	OperationOriginUser OperationOrigin = "user"
)

// PossibleOperationOriginValues returns an array of possible values for the OperationOrigin const type.
func PossibleOperationOriginValues() []OperationOrigin {
	return []OperationOrigin{OperationOriginSystem, OperationOriginUser}
}

// PauseDelayTimeUnit enumerates the values for pause delay time unit.
type PauseDelayTimeUnit string

const (
	// PauseDelayTimeUnitMinutes ...
	PauseDelayTimeUnitMinutes PauseDelayTimeUnit = "Minutes"
)

// PossiblePauseDelayTimeUnitValues returns an array of possible values for the PauseDelayTimeUnit const type.
func PossiblePauseDelayTimeUnitValues() []PauseDelayTimeUnit {
	return []PauseDelayTimeUnit{PauseDelayTimeUnitMinutes}
}

// PerformanceLevelUnit enumerates the values for performance level unit.
type PerformanceLevelUnit string

const (
	// PerformanceLevelUnitDTU ...
	PerformanceLevelUnitDTU PerformanceLevelUnit = "DTU"
	// PerformanceLevelUnitVCores ...
	PerformanceLevelUnitVCores PerformanceLevelUnit = "VCores"
)

// PossiblePerformanceLevelUnitValues returns an array of possible values for the PerformanceLevelUnit const type.
func PossiblePerformanceLevelUnitValues() []PerformanceLevelUnit {
	return []PerformanceLevelUnit{PerformanceLevelUnitDTU, PerformanceLevelUnitVCores}
}

// PrimaryAggregationType enumerates the values for primary aggregation type.
type PrimaryAggregationType string

const (
	// PrimaryAggregationTypeAverage ...
	PrimaryAggregationTypeAverage PrimaryAggregationType = "Average"
	// PrimaryAggregationTypeCount ...
	PrimaryAggregationTypeCount PrimaryAggregationType = "Count"
	// PrimaryAggregationTypeMaximum ...
	PrimaryAggregationTypeMaximum PrimaryAggregationType = "Maximum"
	// PrimaryAggregationTypeMinimum ...
	PrimaryAggregationTypeMinimum PrimaryAggregationType = "Minimum"
	// PrimaryAggregationTypeNone ...
	PrimaryAggregationTypeNone PrimaryAggregationType = "None"
	// PrimaryAggregationTypeTotal ...
	PrimaryAggregationTypeTotal PrimaryAggregationType = "Total"
)

// PossiblePrimaryAggregationTypeValues returns an array of possible values for the PrimaryAggregationType const type.
func PossiblePrimaryAggregationTypeValues() []PrimaryAggregationType {
	return []PrimaryAggregationType{PrimaryAggregationTypeAverage, PrimaryAggregationTypeCount, PrimaryAggregationTypeMaximum, PrimaryAggregationTypeMinimum, PrimaryAggregationTypeNone, PrimaryAggregationTypeTotal}
}

// PrincipalType enumerates the values for principal type.
type PrincipalType string

const (
	// PrincipalTypeApplication ...
	PrincipalTypeApplication PrincipalType = "Application"
	// PrincipalTypeGroup ...
	PrincipalTypeGroup PrincipalType = "Group"
	// PrincipalTypeUser ...
	PrincipalTypeUser PrincipalType = "User"
)

// PossiblePrincipalTypeValues returns an array of possible values for the PrincipalType const type.
func PossiblePrincipalTypeValues() []PrincipalType {
	return []PrincipalType{PrincipalTypeApplication, PrincipalTypeGroup, PrincipalTypeUser}
}

// PrivateEndpointProvisioningState enumerates the values for private endpoint provisioning state.
type PrivateEndpointProvisioningState string

const (
	// PrivateEndpointProvisioningStateApproving ...
	PrivateEndpointProvisioningStateApproving PrivateEndpointProvisioningState = "Approving"
	// PrivateEndpointProvisioningStateDropping ...
	PrivateEndpointProvisioningStateDropping PrivateEndpointProvisioningState = "Dropping"
	// PrivateEndpointProvisioningStateFailed ...
	PrivateEndpointProvisioningStateFailed PrivateEndpointProvisioningState = "Failed"
	// PrivateEndpointProvisioningStateReady ...
	PrivateEndpointProvisioningStateReady PrivateEndpointProvisioningState = "Ready"
	// PrivateEndpointProvisioningStateRejecting ...
	PrivateEndpointProvisioningStateRejecting PrivateEndpointProvisioningState = "Rejecting"
)

// PossiblePrivateEndpointProvisioningStateValues returns an array of possible values for the PrivateEndpointProvisioningState const type.
func PossiblePrivateEndpointProvisioningStateValues() []PrivateEndpointProvisioningState {
	return []PrivateEndpointProvisioningState{PrivateEndpointProvisioningStateApproving, PrivateEndpointProvisioningStateDropping, PrivateEndpointProvisioningStateFailed, PrivateEndpointProvisioningStateReady, PrivateEndpointProvisioningStateRejecting}
}

// PrivateLinkServiceConnectionStateActionsRequire enumerates the values for private link service connection
// state actions require.
type PrivateLinkServiceConnectionStateActionsRequire string

const (
	// PrivateLinkServiceConnectionStateActionsRequireNone ...
	PrivateLinkServiceConnectionStateActionsRequireNone PrivateLinkServiceConnectionStateActionsRequire = "None"
)

// PossiblePrivateLinkServiceConnectionStateActionsRequireValues returns an array of possible values for the PrivateLinkServiceConnectionStateActionsRequire const type.
func PossiblePrivateLinkServiceConnectionStateActionsRequireValues() []PrivateLinkServiceConnectionStateActionsRequire {
	return []PrivateLinkServiceConnectionStateActionsRequire{PrivateLinkServiceConnectionStateActionsRequireNone}
}

// PrivateLinkServiceConnectionStateStatus enumerates the values for private link service connection state
// status.
type PrivateLinkServiceConnectionStateStatus string

const (
	// PrivateLinkServiceConnectionStateStatusApproved ...
	PrivateLinkServiceConnectionStateStatusApproved PrivateLinkServiceConnectionStateStatus = "Approved"
	// PrivateLinkServiceConnectionStateStatusDisconnected ...
	PrivateLinkServiceConnectionStateStatusDisconnected PrivateLinkServiceConnectionStateStatus = "Disconnected"
	// PrivateLinkServiceConnectionStateStatusPending ...
	PrivateLinkServiceConnectionStateStatusPending PrivateLinkServiceConnectionStateStatus = "Pending"
	// PrivateLinkServiceConnectionStateStatusRejected ...
	PrivateLinkServiceConnectionStateStatusRejected PrivateLinkServiceConnectionStateStatus = "Rejected"
)

// PossiblePrivateLinkServiceConnectionStateStatusValues returns an array of possible values for the PrivateLinkServiceConnectionStateStatus const type.
func PossiblePrivateLinkServiceConnectionStateStatusValues() []PrivateLinkServiceConnectionStateStatus {
	return []PrivateLinkServiceConnectionStateStatus{PrivateLinkServiceConnectionStateStatusApproved, PrivateLinkServiceConnectionStateStatusDisconnected, PrivateLinkServiceConnectionStateStatusPending, PrivateLinkServiceConnectionStateStatusRejected}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// ProvisioningStateCanceled ...
	ProvisioningStateCanceled ProvisioningState = "Canceled"
	// ProvisioningStateCreated ...
	ProvisioningStateCreated ProvisioningState = "Created"
	// ProvisioningStateFailed ...
	ProvisioningStateFailed ProvisioningState = "Failed"
	// ProvisioningStateInProgress ...
	ProvisioningStateInProgress ProvisioningState = "InProgress"
	// ProvisioningStateSucceeded ...
	ProvisioningStateSucceeded ProvisioningState = "Succeeded"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{ProvisioningStateCanceled, ProvisioningStateCreated, ProvisioningStateFailed, ProvisioningStateInProgress, ProvisioningStateSucceeded}
}

// ProvisioningState1 enumerates the values for provisioning state 1.
type ProvisioningState1 string

const (
	// ProvisioningState1Creating ...
	ProvisioningState1Creating ProvisioningState1 = "Creating"
	// ProvisioningState1Deleting ...
	ProvisioningState1Deleting ProvisioningState1 = "Deleting"
	// ProvisioningState1Failed ...
	ProvisioningState1Failed ProvisioningState1 = "Failed"
	// ProvisioningState1Succeeded ...
	ProvisioningState1Succeeded ProvisioningState1 = "Succeeded"
	// ProvisioningState1Unknown ...
	ProvisioningState1Unknown ProvisioningState1 = "Unknown"
	// ProvisioningState1Updating ...
	ProvisioningState1Updating ProvisioningState1 = "Updating"
)

// PossibleProvisioningState1Values returns an array of possible values for the ProvisioningState1 const type.
func PossibleProvisioningState1Values() []ProvisioningState1 {
	return []ProvisioningState1{ProvisioningState1Creating, ProvisioningState1Deleting, ProvisioningState1Failed, ProvisioningState1Succeeded, ProvisioningState1Unknown, ProvisioningState1Updating}
}

// QueryMetricUnitType enumerates the values for query metric unit type.
type QueryMetricUnitType string

const (
	// QueryMetricUnitTypeCount ...
	QueryMetricUnitTypeCount QueryMetricUnitType = "count"
	// QueryMetricUnitTypeKB ...
	QueryMetricUnitTypeKB QueryMetricUnitType = "KB"
	// QueryMetricUnitTypeMicroseconds ...
	QueryMetricUnitTypeMicroseconds QueryMetricUnitType = "microseconds"
	// QueryMetricUnitTypePercentage ...
	QueryMetricUnitTypePercentage QueryMetricUnitType = "percentage"
)

// PossibleQueryMetricUnitTypeValues returns an array of possible values for the QueryMetricUnitType const type.
func PossibleQueryMetricUnitTypeValues() []QueryMetricUnitType {
	return []QueryMetricUnitType{QueryMetricUnitTypeCount, QueryMetricUnitTypeKB, QueryMetricUnitTypeMicroseconds, QueryMetricUnitTypePercentage}
}

// QueryTimeGrainType enumerates the values for query time grain type.
type QueryTimeGrainType string

const (
	// QueryTimeGrainTypeP1D ...
	QueryTimeGrainTypeP1D QueryTimeGrainType = "P1D"
	// QueryTimeGrainTypePT1H ...
	QueryTimeGrainTypePT1H QueryTimeGrainType = "PT1H"
)

// PossibleQueryTimeGrainTypeValues returns an array of possible values for the QueryTimeGrainType const type.
func PossibleQueryTimeGrainTypeValues() []QueryTimeGrainType {
	return []QueryTimeGrainType{QueryTimeGrainTypeP1D, QueryTimeGrainTypePT1H}
}

// ReadOnlyEndpointFailoverPolicy enumerates the values for read only endpoint failover policy.
type ReadOnlyEndpointFailoverPolicy string

const (
	// ReadOnlyEndpointFailoverPolicyDisabled ...
	ReadOnlyEndpointFailoverPolicyDisabled ReadOnlyEndpointFailoverPolicy = "Disabled"
	// ReadOnlyEndpointFailoverPolicyEnabled ...
	ReadOnlyEndpointFailoverPolicyEnabled ReadOnlyEndpointFailoverPolicy = "Enabled"
)

// PossibleReadOnlyEndpointFailoverPolicyValues returns an array of possible values for the ReadOnlyEndpointFailoverPolicy const type.
func PossibleReadOnlyEndpointFailoverPolicyValues() []ReadOnlyEndpointFailoverPolicy {
	return []ReadOnlyEndpointFailoverPolicy{ReadOnlyEndpointFailoverPolicyDisabled, ReadOnlyEndpointFailoverPolicyEnabled}
}

// ReadWriteEndpointFailoverPolicy enumerates the values for read write endpoint failover policy.
type ReadWriteEndpointFailoverPolicy string

const (
	// ReadWriteEndpointFailoverPolicyAutomatic ...
	ReadWriteEndpointFailoverPolicyAutomatic ReadWriteEndpointFailoverPolicy = "Automatic"
	// ReadWriteEndpointFailoverPolicyManual ...
	ReadWriteEndpointFailoverPolicyManual ReadWriteEndpointFailoverPolicy = "Manual"
)

// PossibleReadWriteEndpointFailoverPolicyValues returns an array of possible values for the ReadWriteEndpointFailoverPolicy const type.
func PossibleReadWriteEndpointFailoverPolicyValues() []ReadWriteEndpointFailoverPolicy {
	return []ReadWriteEndpointFailoverPolicy{ReadWriteEndpointFailoverPolicyAutomatic, ReadWriteEndpointFailoverPolicyManual}
}

// RecommendedActionCurrentState enumerates the values for recommended action current state.
type RecommendedActionCurrentState string

const (
	// RecommendedActionCurrentStateActive ...
	RecommendedActionCurrentStateActive RecommendedActionCurrentState = "Active"
	// RecommendedActionCurrentStateError ...
	RecommendedActionCurrentStateError RecommendedActionCurrentState = "Error"
	// RecommendedActionCurrentStateExecuting ...
	RecommendedActionCurrentStateExecuting RecommendedActionCurrentState = "Executing"
	// RecommendedActionCurrentStateExpired ...
	RecommendedActionCurrentStateExpired RecommendedActionCurrentState = "Expired"
	// RecommendedActionCurrentStateIgnored ...
	RecommendedActionCurrentStateIgnored RecommendedActionCurrentState = "Ignored"
	// RecommendedActionCurrentStateMonitoring ...
	RecommendedActionCurrentStateMonitoring RecommendedActionCurrentState = "Monitoring"
	// RecommendedActionCurrentStatePending ...
	RecommendedActionCurrentStatePending RecommendedActionCurrentState = "Pending"
	// RecommendedActionCurrentStatePendingRevert ...
	RecommendedActionCurrentStatePendingRevert RecommendedActionCurrentState = "PendingRevert"
	// RecommendedActionCurrentStateResolved ...
	RecommendedActionCurrentStateResolved RecommendedActionCurrentState = "Resolved"
	// RecommendedActionCurrentStateRevertCancelled ...
	RecommendedActionCurrentStateRevertCancelled RecommendedActionCurrentState = "RevertCancelled"
	// RecommendedActionCurrentStateReverted ...
	RecommendedActionCurrentStateReverted RecommendedActionCurrentState = "Reverted"
	// RecommendedActionCurrentStateReverting ...
	RecommendedActionCurrentStateReverting RecommendedActionCurrentState = "Reverting"
	// RecommendedActionCurrentStateSuccess ...
	RecommendedActionCurrentStateSuccess RecommendedActionCurrentState = "Success"
	// RecommendedActionCurrentStateVerifying ...
	RecommendedActionCurrentStateVerifying RecommendedActionCurrentState = "Verifying"
)

// PossibleRecommendedActionCurrentStateValues returns an array of possible values for the RecommendedActionCurrentState const type.
func PossibleRecommendedActionCurrentStateValues() []RecommendedActionCurrentState {
	return []RecommendedActionCurrentState{RecommendedActionCurrentStateActive, RecommendedActionCurrentStateError, RecommendedActionCurrentStateExecuting, RecommendedActionCurrentStateExpired, RecommendedActionCurrentStateIgnored, RecommendedActionCurrentStateMonitoring, RecommendedActionCurrentStatePending, RecommendedActionCurrentStatePendingRevert, RecommendedActionCurrentStateResolved, RecommendedActionCurrentStateRevertCancelled, RecommendedActionCurrentStateReverted, RecommendedActionCurrentStateReverting, RecommendedActionCurrentStateSuccess, RecommendedActionCurrentStateVerifying}
}

// RecommendedActionInitiatedBy enumerates the values for recommended action initiated by.
type RecommendedActionInitiatedBy string

const (
	// RecommendedActionInitiatedBySystem ...
	RecommendedActionInitiatedBySystem RecommendedActionInitiatedBy = "System"
	// RecommendedActionInitiatedByUser ...
	RecommendedActionInitiatedByUser RecommendedActionInitiatedBy = "User"
)

// PossibleRecommendedActionInitiatedByValues returns an array of possible values for the RecommendedActionInitiatedBy const type.
func PossibleRecommendedActionInitiatedByValues() []RecommendedActionInitiatedBy {
	return []RecommendedActionInitiatedBy{RecommendedActionInitiatedBySystem, RecommendedActionInitiatedByUser}
}

// RecommendedSensitivityLabelUpdateKind enumerates the values for recommended sensitivity label update kind.
type RecommendedSensitivityLabelUpdateKind string

const (
	// RecommendedSensitivityLabelUpdateKindDisable ...
	RecommendedSensitivityLabelUpdateKindDisable RecommendedSensitivityLabelUpdateKind = "disable"
	// RecommendedSensitivityLabelUpdateKindEnable ...
	RecommendedSensitivityLabelUpdateKindEnable RecommendedSensitivityLabelUpdateKind = "enable"
)

// PossibleRecommendedSensitivityLabelUpdateKindValues returns an array of possible values for the RecommendedSensitivityLabelUpdateKind const type.
func PossibleRecommendedSensitivityLabelUpdateKindValues() []RecommendedSensitivityLabelUpdateKind {
	return []RecommendedSensitivityLabelUpdateKind{RecommendedSensitivityLabelUpdateKindDisable, RecommendedSensitivityLabelUpdateKindEnable}
}

// ReplicationLinkType enumerates the values for replication link type.
type ReplicationLinkType string

const (
	// ReplicationLinkTypeGEO ...
	ReplicationLinkTypeGEO ReplicationLinkType = "GEO"
	// ReplicationLinkTypeNAMED ...
	ReplicationLinkTypeNAMED ReplicationLinkType = "NAMED"
)

// PossibleReplicationLinkTypeValues returns an array of possible values for the ReplicationLinkType const type.
func PossibleReplicationLinkTypeValues() []ReplicationLinkType {
	return []ReplicationLinkType{ReplicationLinkTypeGEO, ReplicationLinkTypeNAMED}
}

// ReplicationRole enumerates the values for replication role.
type ReplicationRole string

const (
	// ReplicationRoleCopy ...
	ReplicationRoleCopy ReplicationRole = "Copy"
	// ReplicationRoleNonReadableSecondary ...
	ReplicationRoleNonReadableSecondary ReplicationRole = "NonReadableSecondary"
	// ReplicationRolePrimary ...
	ReplicationRolePrimary ReplicationRole = "Primary"
	// ReplicationRoleSecondary ...
	ReplicationRoleSecondary ReplicationRole = "Secondary"
	// ReplicationRoleSource ...
	ReplicationRoleSource ReplicationRole = "Source"
)

// PossibleReplicationRoleValues returns an array of possible values for the ReplicationRole const type.
func PossibleReplicationRoleValues() []ReplicationRole {
	return []ReplicationRole{ReplicationRoleCopy, ReplicationRoleNonReadableSecondary, ReplicationRolePrimary, ReplicationRoleSecondary, ReplicationRoleSource}
}

// ReplicationState enumerates the values for replication state.
type ReplicationState string

const (
	// ReplicationStateCATCHUP ...
	ReplicationStateCATCHUP ReplicationState = "CATCH_UP"
	// ReplicationStatePENDING ...
	ReplicationStatePENDING ReplicationState = "PENDING"
	// ReplicationStateSEEDING ...
	ReplicationStateSEEDING ReplicationState = "SEEDING"
	// ReplicationStateSUSPENDED ...
	ReplicationStateSUSPENDED ReplicationState = "SUSPENDED"
)

// PossibleReplicationStateValues returns an array of possible values for the ReplicationState const type.
func PossibleReplicationStateValues() []ReplicationState {
	return []ReplicationState{ReplicationStateCATCHUP, ReplicationStatePENDING, ReplicationStateSEEDING, ReplicationStateSUSPENDED}
}

// ReplicaType enumerates the values for replica type.
type ReplicaType string

const (
	// ReplicaTypePrimary ...
	ReplicaTypePrimary ReplicaType = "Primary"
	// ReplicaTypeReadableSecondary ...
	ReplicaTypeReadableSecondary ReplicaType = "ReadableSecondary"
)

// PossibleReplicaTypeValues returns an array of possible values for the ReplicaType const type.
func PossibleReplicaTypeValues() []ReplicaType {
	return []ReplicaType{ReplicaTypePrimary, ReplicaTypeReadableSecondary}
}

// RequestedBackupStorageRedundancy enumerates the values for requested backup storage redundancy.
type RequestedBackupStorageRedundancy string

const (
	// RequestedBackupStorageRedundancyGeo ...
	RequestedBackupStorageRedundancyGeo RequestedBackupStorageRedundancy = "Geo"
	// RequestedBackupStorageRedundancyLocal ...
	RequestedBackupStorageRedundancyLocal RequestedBackupStorageRedundancy = "Local"
	// RequestedBackupStorageRedundancyZone ...
	RequestedBackupStorageRedundancyZone RequestedBackupStorageRedundancy = "Zone"
)

// PossibleRequestedBackupStorageRedundancyValues returns an array of possible values for the RequestedBackupStorageRedundancy const type.
func PossibleRequestedBackupStorageRedundancyValues() []RequestedBackupStorageRedundancy {
	return []RequestedBackupStorageRedundancy{RequestedBackupStorageRedundancyGeo, RequestedBackupStorageRedundancyLocal, RequestedBackupStorageRedundancyZone}
}

// RestorePointType enumerates the values for restore point type.
type RestorePointType string

const (
	// RestorePointTypeCONTINUOUS ...
	RestorePointTypeCONTINUOUS RestorePointType = "CONTINUOUS"
	// RestorePointTypeDISCRETE ...
	RestorePointTypeDISCRETE RestorePointType = "DISCRETE"
)

// PossibleRestorePointTypeValues returns an array of possible values for the RestorePointType const type.
func PossibleRestorePointTypeValues() []RestorePointType {
	return []RestorePointType{RestorePointTypeCONTINUOUS, RestorePointTypeDISCRETE}
}

// SampleName enumerates the values for sample name.
type SampleName string

const (
	// SampleNameAdventureWorksLT ...
	SampleNameAdventureWorksLT SampleName = "AdventureWorksLT"
	// SampleNameWideWorldImportersFull ...
	SampleNameWideWorldImportersFull SampleName = "WideWorldImportersFull"
	// SampleNameWideWorldImportersStd ...
	SampleNameWideWorldImportersStd SampleName = "WideWorldImportersStd"
)

// PossibleSampleNameValues returns an array of possible values for the SampleName const type.
func PossibleSampleNameValues() []SampleName {
	return []SampleName{SampleNameAdventureWorksLT, SampleNameWideWorldImportersFull, SampleNameWideWorldImportersStd}
}

// SecondaryType enumerates the values for secondary type.
type SecondaryType string

const (
	// SecondaryTypeGeo ...
	SecondaryTypeGeo SecondaryType = "Geo"
	// SecondaryTypeNamed ...
	SecondaryTypeNamed SecondaryType = "Named"
)

// PossibleSecondaryTypeValues returns an array of possible values for the SecondaryType const type.
func PossibleSecondaryTypeValues() []SecondaryType {
	return []SecondaryType{SecondaryTypeGeo, SecondaryTypeNamed}
}

// SecurityAlertPolicyState enumerates the values for security alert policy state.
type SecurityAlertPolicyState string

const (
	// SecurityAlertPolicyStateDisabled ...
	SecurityAlertPolicyStateDisabled SecurityAlertPolicyState = "Disabled"
	// SecurityAlertPolicyStateEnabled ...
	SecurityAlertPolicyStateEnabled SecurityAlertPolicyState = "Enabled"
	// SecurityAlertPolicyStateNew ...
	SecurityAlertPolicyStateNew SecurityAlertPolicyState = "New"
)

// PossibleSecurityAlertPolicyStateValues returns an array of possible values for the SecurityAlertPolicyState const type.
func PossibleSecurityAlertPolicyStateValues() []SecurityAlertPolicyState {
	return []SecurityAlertPolicyState{SecurityAlertPolicyStateDisabled, SecurityAlertPolicyStateEnabled, SecurityAlertPolicyStateNew}
}

// SecurityAlertsPolicyState enumerates the values for security alerts policy state.
type SecurityAlertsPolicyState string

const (
	// SecurityAlertsPolicyStateDisabled ...
	SecurityAlertsPolicyStateDisabled SecurityAlertsPolicyState = "Disabled"
	// SecurityAlertsPolicyStateEnabled ...
	SecurityAlertsPolicyStateEnabled SecurityAlertsPolicyState = "Enabled"
)

// PossibleSecurityAlertsPolicyStateValues returns an array of possible values for the SecurityAlertsPolicyState const type.
func PossibleSecurityAlertsPolicyStateValues() []SecurityAlertsPolicyState {
	return []SecurityAlertsPolicyState{SecurityAlertsPolicyStateDisabled, SecurityAlertsPolicyStateEnabled}
}

// SecurityEventType enumerates the values for security event type.
type SecurityEventType string

const (
	// SecurityEventTypeSQLInjectionExploit ...
	SecurityEventTypeSQLInjectionExploit SecurityEventType = "SqlInjectionExploit"
	// SecurityEventTypeSQLInjectionVulnerability ...
	SecurityEventTypeSQLInjectionVulnerability SecurityEventType = "SqlInjectionVulnerability"
	// SecurityEventTypeUndefined ...
	SecurityEventTypeUndefined SecurityEventType = "Undefined"
)

// PossibleSecurityEventTypeValues returns an array of possible values for the SecurityEventType const type.
func PossibleSecurityEventTypeValues() []SecurityEventType {
	return []SecurityEventType{SecurityEventTypeSQLInjectionExploit, SecurityEventTypeSQLInjectionVulnerability, SecurityEventTypeUndefined}
}

// SensitivityLabelRank enumerates the values for sensitivity label rank.
type SensitivityLabelRank string

const (
	// SensitivityLabelRankCritical ...
	SensitivityLabelRankCritical SensitivityLabelRank = "Critical"
	// SensitivityLabelRankHigh ...
	SensitivityLabelRankHigh SensitivityLabelRank = "High"
	// SensitivityLabelRankLow ...
	SensitivityLabelRankLow SensitivityLabelRank = "Low"
	// SensitivityLabelRankMedium ...
	SensitivityLabelRankMedium SensitivityLabelRank = "Medium"
	// SensitivityLabelRankNone ...
	SensitivityLabelRankNone SensitivityLabelRank = "None"
)

// PossibleSensitivityLabelRankValues returns an array of possible values for the SensitivityLabelRank const type.
func PossibleSensitivityLabelRankValues() []SensitivityLabelRank {
	return []SensitivityLabelRank{SensitivityLabelRankCritical, SensitivityLabelRankHigh, SensitivityLabelRankLow, SensitivityLabelRankMedium, SensitivityLabelRankNone}
}

// SensitivityLabelSource enumerates the values for sensitivity label source.
type SensitivityLabelSource string

const (
	// SensitivityLabelSourceCurrent ...
	SensitivityLabelSourceCurrent SensitivityLabelSource = "current"
	// SensitivityLabelSourceRecommended ...
	SensitivityLabelSourceRecommended SensitivityLabelSource = "recommended"
)

// PossibleSensitivityLabelSourceValues returns an array of possible values for the SensitivityLabelSource const type.
func PossibleSensitivityLabelSourceValues() []SensitivityLabelSource {
	return []SensitivityLabelSource{SensitivityLabelSourceCurrent, SensitivityLabelSourceRecommended}
}

// SensitivityLabelUpdateKind enumerates the values for sensitivity label update kind.
type SensitivityLabelUpdateKind string

const (
	// SensitivityLabelUpdateKindRemove ...
	SensitivityLabelUpdateKindRemove SensitivityLabelUpdateKind = "remove"
	// SensitivityLabelUpdateKindSet ...
	SensitivityLabelUpdateKindSet SensitivityLabelUpdateKind = "set"
)

// PossibleSensitivityLabelUpdateKindValues returns an array of possible values for the SensitivityLabelUpdateKind const type.
func PossibleSensitivityLabelUpdateKindValues() []SensitivityLabelUpdateKind {
	return []SensitivityLabelUpdateKind{SensitivityLabelUpdateKindRemove, SensitivityLabelUpdateKindSet}
}

// ServerConnectionType enumerates the values for server connection type.
type ServerConnectionType string

const (
	// ServerConnectionTypeDefault ...
	ServerConnectionTypeDefault ServerConnectionType = "Default"
	// ServerConnectionTypeProxy ...
	ServerConnectionTypeProxy ServerConnectionType = "Proxy"
	// ServerConnectionTypeRedirect ...
	ServerConnectionTypeRedirect ServerConnectionType = "Redirect"
)

// PossibleServerConnectionTypeValues returns an array of possible values for the ServerConnectionType const type.
func PossibleServerConnectionTypeValues() []ServerConnectionType {
	return []ServerConnectionType{ServerConnectionTypeDefault, ServerConnectionTypeProxy, ServerConnectionTypeRedirect}
}

// ServerKeyType enumerates the values for server key type.
type ServerKeyType string

const (
	// ServerKeyTypeAzureKeyVault ...
	ServerKeyTypeAzureKeyVault ServerKeyType = "AzureKeyVault"
	// ServerKeyTypeServiceManaged ...
	ServerKeyTypeServiceManaged ServerKeyType = "ServiceManaged"
)

// PossibleServerKeyTypeValues returns an array of possible values for the ServerKeyType const type.
func PossibleServerKeyTypeValues() []ServerKeyType {
	return []ServerKeyType{ServerKeyTypeAzureKeyVault, ServerKeyTypeServiceManaged}
}

// ServerNetworkAccessFlag enumerates the values for server network access flag.
type ServerNetworkAccessFlag string

const (
	// ServerNetworkAccessFlagDisabled ...
	ServerNetworkAccessFlagDisabled ServerNetworkAccessFlag = "Disabled"
	// ServerNetworkAccessFlagEnabled ...
	ServerNetworkAccessFlagEnabled ServerNetworkAccessFlag = "Enabled"
)

// PossibleServerNetworkAccessFlagValues returns an array of possible values for the ServerNetworkAccessFlag const type.
func PossibleServerNetworkAccessFlagValues() []ServerNetworkAccessFlag {
	return []ServerNetworkAccessFlag{ServerNetworkAccessFlagDisabled, ServerNetworkAccessFlagEnabled}
}

// ServerWorkspaceFeature enumerates the values for server workspace feature.
type ServerWorkspaceFeature string

const (
	// ServerWorkspaceFeatureConnected ...
	ServerWorkspaceFeatureConnected ServerWorkspaceFeature = "Connected"
	// ServerWorkspaceFeatureDisconnected ...
	ServerWorkspaceFeatureDisconnected ServerWorkspaceFeature = "Disconnected"
)

// PossibleServerWorkspaceFeatureValues returns an array of possible values for the ServerWorkspaceFeature const type.
func PossibleServerWorkspaceFeatureValues() []ServerWorkspaceFeature {
	return []ServerWorkspaceFeature{ServerWorkspaceFeatureConnected, ServerWorkspaceFeatureDisconnected}
}

// ServiceObjectiveName enumerates the values for service objective name.
type ServiceObjectiveName string

const (
	// ServiceObjectiveNameBasic ...
	ServiceObjectiveNameBasic ServiceObjectiveName = "Basic"
	// ServiceObjectiveNameDS100 ...
	ServiceObjectiveNameDS100 ServiceObjectiveName = "DS100"
	// ServiceObjectiveNameDS1000 ...
	ServiceObjectiveNameDS1000 ServiceObjectiveName = "DS1000"
	// ServiceObjectiveNameDS1200 ...
	ServiceObjectiveNameDS1200 ServiceObjectiveName = "DS1200"
	// ServiceObjectiveNameDS1500 ...
	ServiceObjectiveNameDS1500 ServiceObjectiveName = "DS1500"
	// ServiceObjectiveNameDS200 ...
	ServiceObjectiveNameDS200 ServiceObjectiveName = "DS200"
	// ServiceObjectiveNameDS2000 ...
	ServiceObjectiveNameDS2000 ServiceObjectiveName = "DS2000"
	// ServiceObjectiveNameDS300 ...
	ServiceObjectiveNameDS300 ServiceObjectiveName = "DS300"
	// ServiceObjectiveNameDS400 ...
	ServiceObjectiveNameDS400 ServiceObjectiveName = "DS400"
	// ServiceObjectiveNameDS500 ...
	ServiceObjectiveNameDS500 ServiceObjectiveName = "DS500"
	// ServiceObjectiveNameDS600 ...
	ServiceObjectiveNameDS600 ServiceObjectiveName = "DS600"
	// ServiceObjectiveNameDW100 ...
	ServiceObjectiveNameDW100 ServiceObjectiveName = "DW100"
	// ServiceObjectiveNameDW1000 ...
	ServiceObjectiveNameDW1000 ServiceObjectiveName = "DW1000"
	// ServiceObjectiveNameDW10000c ...
	ServiceObjectiveNameDW10000c ServiceObjectiveName = "DW10000c"
	// ServiceObjectiveNameDW1000c ...
	ServiceObjectiveNameDW1000c ServiceObjectiveName = "DW1000c"
	// ServiceObjectiveNameDW1200 ...
	ServiceObjectiveNameDW1200 ServiceObjectiveName = "DW1200"
	// ServiceObjectiveNameDW1500 ...
	ServiceObjectiveNameDW1500 ServiceObjectiveName = "DW1500"
	// ServiceObjectiveNameDW15000c ...
	ServiceObjectiveNameDW15000c ServiceObjectiveName = "DW15000c"
	// ServiceObjectiveNameDW1500c ...
	ServiceObjectiveNameDW1500c ServiceObjectiveName = "DW1500c"
	// ServiceObjectiveNameDW200 ...
	ServiceObjectiveNameDW200 ServiceObjectiveName = "DW200"
	// ServiceObjectiveNameDW2000 ...
	ServiceObjectiveNameDW2000 ServiceObjectiveName = "DW2000"
	// ServiceObjectiveNameDW2000c ...
	ServiceObjectiveNameDW2000c ServiceObjectiveName = "DW2000c"
	// ServiceObjectiveNameDW2500c ...
	ServiceObjectiveNameDW2500c ServiceObjectiveName = "DW2500c"
	// ServiceObjectiveNameDW300 ...
	ServiceObjectiveNameDW300 ServiceObjectiveName = "DW300"
	// ServiceObjectiveNameDW3000 ...
	ServiceObjectiveNameDW3000 ServiceObjectiveName = "DW3000"
	// ServiceObjectiveNameDW30000c ...
	ServiceObjectiveNameDW30000c ServiceObjectiveName = "DW30000c"
	// ServiceObjectiveNameDW3000c ...
	ServiceObjectiveNameDW3000c ServiceObjectiveName = "DW3000c"
	// ServiceObjectiveNameDW400 ...
	ServiceObjectiveNameDW400 ServiceObjectiveName = "DW400"
	// ServiceObjectiveNameDW500 ...
	ServiceObjectiveNameDW500 ServiceObjectiveName = "DW500"
	// ServiceObjectiveNameDW5000c ...
	ServiceObjectiveNameDW5000c ServiceObjectiveName = "DW5000c"
	// ServiceObjectiveNameDW600 ...
	ServiceObjectiveNameDW600 ServiceObjectiveName = "DW600"
	// ServiceObjectiveNameDW6000 ...
	ServiceObjectiveNameDW6000 ServiceObjectiveName = "DW6000"
	// ServiceObjectiveNameDW6000c ...
	ServiceObjectiveNameDW6000c ServiceObjectiveName = "DW6000c"
	// ServiceObjectiveNameDW7500c ...
	ServiceObjectiveNameDW7500c ServiceObjectiveName = "DW7500c"
	// ServiceObjectiveNameElasticPool ...
	ServiceObjectiveNameElasticPool ServiceObjectiveName = "ElasticPool"
	// ServiceObjectiveNameFree ...
	ServiceObjectiveNameFree ServiceObjectiveName = "Free"
	// ServiceObjectiveNameP1 ...
	ServiceObjectiveNameP1 ServiceObjectiveName = "P1"
	// ServiceObjectiveNameP11 ...
	ServiceObjectiveNameP11 ServiceObjectiveName = "P11"
	// ServiceObjectiveNameP15 ...
	ServiceObjectiveNameP15 ServiceObjectiveName = "P15"
	// ServiceObjectiveNameP2 ...
	ServiceObjectiveNameP2 ServiceObjectiveName = "P2"
	// ServiceObjectiveNameP3 ...
	ServiceObjectiveNameP3 ServiceObjectiveName = "P3"
	// ServiceObjectiveNameP4 ...
	ServiceObjectiveNameP4 ServiceObjectiveName = "P4"
	// ServiceObjectiveNameP6 ...
	ServiceObjectiveNameP6 ServiceObjectiveName = "P6"
	// ServiceObjectiveNamePRS1 ...
	ServiceObjectiveNamePRS1 ServiceObjectiveName = "PRS1"
	// ServiceObjectiveNamePRS2 ...
	ServiceObjectiveNamePRS2 ServiceObjectiveName = "PRS2"
	// ServiceObjectiveNamePRS4 ...
	ServiceObjectiveNamePRS4 ServiceObjectiveName = "PRS4"
	// ServiceObjectiveNamePRS6 ...
	ServiceObjectiveNamePRS6 ServiceObjectiveName = "PRS6"
	// ServiceObjectiveNameS0 ...
	ServiceObjectiveNameS0 ServiceObjectiveName = "S0"
	// ServiceObjectiveNameS1 ...
	ServiceObjectiveNameS1 ServiceObjectiveName = "S1"
	// ServiceObjectiveNameS12 ...
	ServiceObjectiveNameS12 ServiceObjectiveName = "S12"
	// ServiceObjectiveNameS2 ...
	ServiceObjectiveNameS2 ServiceObjectiveName = "S2"
	// ServiceObjectiveNameS3 ...
	ServiceObjectiveNameS3 ServiceObjectiveName = "S3"
	// ServiceObjectiveNameS4 ...
	ServiceObjectiveNameS4 ServiceObjectiveName = "S4"
	// ServiceObjectiveNameS6 ...
	ServiceObjectiveNameS6 ServiceObjectiveName = "S6"
	// ServiceObjectiveNameS7 ...
	ServiceObjectiveNameS7 ServiceObjectiveName = "S7"
	// ServiceObjectiveNameS9 ...
	ServiceObjectiveNameS9 ServiceObjectiveName = "S9"
	// ServiceObjectiveNameSystem ...
	ServiceObjectiveNameSystem ServiceObjectiveName = "System"
	// ServiceObjectiveNameSystem0 ...
	ServiceObjectiveNameSystem0 ServiceObjectiveName = "System0"
	// ServiceObjectiveNameSystem1 ...
	ServiceObjectiveNameSystem1 ServiceObjectiveName = "System1"
	// ServiceObjectiveNameSystem2 ...
	ServiceObjectiveNameSystem2 ServiceObjectiveName = "System2"
	// ServiceObjectiveNameSystem2L ...
	ServiceObjectiveNameSystem2L ServiceObjectiveName = "System2L"
	// ServiceObjectiveNameSystem3 ...
	ServiceObjectiveNameSystem3 ServiceObjectiveName = "System3"
	// ServiceObjectiveNameSystem3L ...
	ServiceObjectiveNameSystem3L ServiceObjectiveName = "System3L"
	// ServiceObjectiveNameSystem4 ...
	ServiceObjectiveNameSystem4 ServiceObjectiveName = "System4"
	// ServiceObjectiveNameSystem4L ...
	ServiceObjectiveNameSystem4L ServiceObjectiveName = "System4L"
)

// PossibleServiceObjectiveNameValues returns an array of possible values for the ServiceObjectiveName const type.
func PossibleServiceObjectiveNameValues() []ServiceObjectiveName {
	return []ServiceObjectiveName{ServiceObjectiveNameBasic, ServiceObjectiveNameDS100, ServiceObjectiveNameDS1000, ServiceObjectiveNameDS1200, ServiceObjectiveNameDS1500, ServiceObjectiveNameDS200, ServiceObjectiveNameDS2000, ServiceObjectiveNameDS300, ServiceObjectiveNameDS400, ServiceObjectiveNameDS500, ServiceObjectiveNameDS600, ServiceObjectiveNameDW100, ServiceObjectiveNameDW1000, ServiceObjectiveNameDW10000c, ServiceObjectiveNameDW1000c, ServiceObjectiveNameDW1200, ServiceObjectiveNameDW1500, ServiceObjectiveNameDW15000c, ServiceObjectiveNameDW1500c, ServiceObjectiveNameDW200, ServiceObjectiveNameDW2000, ServiceObjectiveNameDW2000c, ServiceObjectiveNameDW2500c, ServiceObjectiveNameDW300, ServiceObjectiveNameDW3000, ServiceObjectiveNameDW30000c, ServiceObjectiveNameDW3000c, ServiceObjectiveNameDW400, ServiceObjectiveNameDW500, ServiceObjectiveNameDW5000c, ServiceObjectiveNameDW600, ServiceObjectiveNameDW6000, ServiceObjectiveNameDW6000c, ServiceObjectiveNameDW7500c, ServiceObjectiveNameElasticPool, ServiceObjectiveNameFree, ServiceObjectiveNameP1, ServiceObjectiveNameP11, ServiceObjectiveNameP15, ServiceObjectiveNameP2, ServiceObjectiveNameP3, ServiceObjectiveNameP4, ServiceObjectiveNameP6, ServiceObjectiveNamePRS1, ServiceObjectiveNamePRS2, ServiceObjectiveNamePRS4, ServiceObjectiveNamePRS6, ServiceObjectiveNameS0, ServiceObjectiveNameS1, ServiceObjectiveNameS12, ServiceObjectiveNameS2, ServiceObjectiveNameS3, ServiceObjectiveNameS4, ServiceObjectiveNameS6, ServiceObjectiveNameS7, ServiceObjectiveNameS9, ServiceObjectiveNameSystem, ServiceObjectiveNameSystem0, ServiceObjectiveNameSystem1, ServiceObjectiveNameSystem2, ServiceObjectiveNameSystem2L, ServiceObjectiveNameSystem3, ServiceObjectiveNameSystem3L, ServiceObjectiveNameSystem4, ServiceObjectiveNameSystem4L}
}

// State enumerates the values for state.
type State string

const (
	// StateDisabled ...
	StateDisabled State = "Disabled"
	// StateEnabled ...
	StateEnabled State = "Enabled"
)

// PossibleStateValues returns an array of possible values for the State const type.
func PossibleStateValues() []State {
	return []State{StateDisabled, StateEnabled}
}

// Status enumerates the values for status.
type Status string

const (
	// StatusCanceled ...
	StatusCanceled Status = "Canceled"
	// StatusCompleted ...
	StatusCompleted Status = "Completed"
	// StatusFailed ...
	StatusFailed Status = "Failed"
	// StatusInProgress ...
	StatusInProgress Status = "InProgress"
	// StatusNotStarted ...
	StatusNotStarted Status = "NotStarted"
	// StatusSlowedDown ...
	StatusSlowedDown Status = "SlowedDown"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{StatusCanceled, StatusCompleted, StatusFailed, StatusInProgress, StatusNotStarted, StatusSlowedDown}
}

// Status1 enumerates the values for status 1.
type Status1 string

const (
	// Status1Failed ...
	Status1Failed Status1 = "Failed"
	// Status1Succeeded ...
	Status1Succeeded Status1 = "Succeeded"
)

// PossibleStatus1Values returns an array of possible values for the Status1 const type.
func PossibleStatus1Values() []Status1 {
	return []Status1{Status1Failed, Status1Succeeded}
}

// StorageAccountType enumerates the values for storage account type.
type StorageAccountType string

const (
	// StorageAccountTypeGRS ...
	StorageAccountTypeGRS StorageAccountType = "GRS"
	// StorageAccountTypeLRS ...
	StorageAccountTypeLRS StorageAccountType = "LRS"
	// StorageAccountTypeZRS ...
	StorageAccountTypeZRS StorageAccountType = "ZRS"
)

// PossibleStorageAccountTypeValues returns an array of possible values for the StorageAccountType const type.
func PossibleStorageAccountTypeValues() []StorageAccountType {
	return []StorageAccountType{StorageAccountTypeGRS, StorageAccountTypeLRS, StorageAccountTypeZRS}
}

// StorageAccountType1 enumerates the values for storage account type 1.
type StorageAccountType1 string

const (
	// StorageAccountType1GRS ...
	StorageAccountType1GRS StorageAccountType1 = "GRS"
	// StorageAccountType1LRS ...
	StorageAccountType1LRS StorageAccountType1 = "LRS"
	// StorageAccountType1ZRS ...
	StorageAccountType1ZRS StorageAccountType1 = "ZRS"
)

// PossibleStorageAccountType1Values returns an array of possible values for the StorageAccountType1 const type.
func PossibleStorageAccountType1Values() []StorageAccountType1 {
	return []StorageAccountType1{StorageAccountType1GRS, StorageAccountType1LRS, StorageAccountType1ZRS}
}

// StorageKeyType enumerates the values for storage key type.
type StorageKeyType string

const (
	// StorageKeyTypeSharedAccessKey ...
	StorageKeyTypeSharedAccessKey StorageKeyType = "SharedAccessKey"
	// StorageKeyTypeStorageAccessKey ...
	StorageKeyTypeStorageAccessKey StorageKeyType = "StorageAccessKey"
)

// PossibleStorageKeyTypeValues returns an array of possible values for the StorageKeyType const type.
func PossibleStorageKeyTypeValues() []StorageKeyType {
	return []StorageKeyType{StorageKeyTypeSharedAccessKey, StorageKeyTypeStorageAccessKey}
}

// SyncAgentState enumerates the values for sync agent state.
type SyncAgentState string

const (
	// SyncAgentStateNeverConnected ...
	SyncAgentStateNeverConnected SyncAgentState = "NeverConnected"
	// SyncAgentStateOffline ...
	SyncAgentStateOffline SyncAgentState = "Offline"
	// SyncAgentStateOnline ...
	SyncAgentStateOnline SyncAgentState = "Online"
)

// PossibleSyncAgentStateValues returns an array of possible values for the SyncAgentState const type.
func PossibleSyncAgentStateValues() []SyncAgentState {
	return []SyncAgentState{SyncAgentStateNeverConnected, SyncAgentStateOffline, SyncAgentStateOnline}
}

// SyncConflictResolutionPolicy enumerates the values for sync conflict resolution policy.
type SyncConflictResolutionPolicy string

const (
	// SyncConflictResolutionPolicyHubWin ...
	SyncConflictResolutionPolicyHubWin SyncConflictResolutionPolicy = "HubWin"
	// SyncConflictResolutionPolicyMemberWin ...
	SyncConflictResolutionPolicyMemberWin SyncConflictResolutionPolicy = "MemberWin"
)

// PossibleSyncConflictResolutionPolicyValues returns an array of possible values for the SyncConflictResolutionPolicy const type.
func PossibleSyncConflictResolutionPolicyValues() []SyncConflictResolutionPolicy {
	return []SyncConflictResolutionPolicy{SyncConflictResolutionPolicyHubWin, SyncConflictResolutionPolicyMemberWin}
}

// SyncDirection enumerates the values for sync direction.
type SyncDirection string

const (
	// SyncDirectionBidirectional ...
	SyncDirectionBidirectional SyncDirection = "Bidirectional"
	// SyncDirectionOneWayHubToMember ...
	SyncDirectionOneWayHubToMember SyncDirection = "OneWayHubToMember"
	// SyncDirectionOneWayMemberToHub ...
	SyncDirectionOneWayMemberToHub SyncDirection = "OneWayMemberToHub"
)

// PossibleSyncDirectionValues returns an array of possible values for the SyncDirection const type.
func PossibleSyncDirectionValues() []SyncDirection {
	return []SyncDirection{SyncDirectionBidirectional, SyncDirectionOneWayHubToMember, SyncDirectionOneWayMemberToHub}
}

// SyncGroupLogType enumerates the values for sync group log type.
type SyncGroupLogType string

const (
	// SyncGroupLogTypeAll ...
	SyncGroupLogTypeAll SyncGroupLogType = "All"
	// SyncGroupLogTypeError ...
	SyncGroupLogTypeError SyncGroupLogType = "Error"
	// SyncGroupLogTypeSuccess ...
	SyncGroupLogTypeSuccess SyncGroupLogType = "Success"
	// SyncGroupLogTypeWarning ...
	SyncGroupLogTypeWarning SyncGroupLogType = "Warning"
)

// PossibleSyncGroupLogTypeValues returns an array of possible values for the SyncGroupLogType const type.
func PossibleSyncGroupLogTypeValues() []SyncGroupLogType {
	return []SyncGroupLogType{SyncGroupLogTypeAll, SyncGroupLogTypeError, SyncGroupLogTypeSuccess, SyncGroupLogTypeWarning}
}

// SyncGroupState enumerates the values for sync group state.
type SyncGroupState string

const (
	// SyncGroupStateError ...
	SyncGroupStateError SyncGroupState = "Error"
	// SyncGroupStateGood ...
	SyncGroupStateGood SyncGroupState = "Good"
	// SyncGroupStateNotReady ...
	SyncGroupStateNotReady SyncGroupState = "NotReady"
	// SyncGroupStateProgressing ...
	SyncGroupStateProgressing SyncGroupState = "Progressing"
	// SyncGroupStateWarning ...
	SyncGroupStateWarning SyncGroupState = "Warning"
)

// PossibleSyncGroupStateValues returns an array of possible values for the SyncGroupState const type.
func PossibleSyncGroupStateValues() []SyncGroupState {
	return []SyncGroupState{SyncGroupStateError, SyncGroupStateGood, SyncGroupStateNotReady, SyncGroupStateProgressing, SyncGroupStateWarning}
}

// SyncMemberDbType enumerates the values for sync member db type.
type SyncMemberDbType string

const (
	// SyncMemberDbTypeAzureSQLDatabase ...
	SyncMemberDbTypeAzureSQLDatabase SyncMemberDbType = "AzureSqlDatabase"
	// SyncMemberDbTypeSQLServerDatabase ...
	SyncMemberDbTypeSQLServerDatabase SyncMemberDbType = "SqlServerDatabase"
)

// PossibleSyncMemberDbTypeValues returns an array of possible values for the SyncMemberDbType const type.
func PossibleSyncMemberDbTypeValues() []SyncMemberDbType {
	return []SyncMemberDbType{SyncMemberDbTypeAzureSQLDatabase, SyncMemberDbTypeSQLServerDatabase}
}

// SyncMemberState enumerates the values for sync member state.
type SyncMemberState string

const (
	// SyncMemberStateDeProvisioned ...
	SyncMemberStateDeProvisioned SyncMemberState = "DeProvisioned"
	// SyncMemberStateDeProvisionFailed ...
	SyncMemberStateDeProvisionFailed SyncMemberState = "DeProvisionFailed"
	// SyncMemberStateDeProvisioning ...
	SyncMemberStateDeProvisioning SyncMemberState = "DeProvisioning"
	// SyncMemberStateDisabledBackupRestore ...
	SyncMemberStateDisabledBackupRestore SyncMemberState = "DisabledBackupRestore"
	// SyncMemberStateDisabledTombstoneCleanup ...
	SyncMemberStateDisabledTombstoneCleanup SyncMemberState = "DisabledTombstoneCleanup"
	// SyncMemberStateProvisioned ...
	SyncMemberStateProvisioned SyncMemberState = "Provisioned"
	// SyncMemberStateProvisionFailed ...
	SyncMemberStateProvisionFailed SyncMemberState = "ProvisionFailed"
	// SyncMemberStateProvisioning ...
	SyncMemberStateProvisioning SyncMemberState = "Provisioning"
	// SyncMemberStateReprovisionFailed ...
	SyncMemberStateReprovisionFailed SyncMemberState = "ReprovisionFailed"
	// SyncMemberStateReprovisioning ...
	SyncMemberStateReprovisioning SyncMemberState = "Reprovisioning"
	// SyncMemberStateSyncCancelled ...
	SyncMemberStateSyncCancelled SyncMemberState = "SyncCancelled"
	// SyncMemberStateSyncCancelling ...
	SyncMemberStateSyncCancelling SyncMemberState = "SyncCancelling"
	// SyncMemberStateSyncFailed ...
	SyncMemberStateSyncFailed SyncMemberState = "SyncFailed"
	// SyncMemberStateSyncInProgress ...
	SyncMemberStateSyncInProgress SyncMemberState = "SyncInProgress"
	// SyncMemberStateSyncSucceeded ...
	SyncMemberStateSyncSucceeded SyncMemberState = "SyncSucceeded"
	// SyncMemberStateSyncSucceededWithWarnings ...
	SyncMemberStateSyncSucceededWithWarnings SyncMemberState = "SyncSucceededWithWarnings"
	// SyncMemberStateUnProvisioned ...
	SyncMemberStateUnProvisioned SyncMemberState = "UnProvisioned"
	// SyncMemberStateUnReprovisioned ...
	SyncMemberStateUnReprovisioned SyncMemberState = "UnReprovisioned"
)

// PossibleSyncMemberStateValues returns an array of possible values for the SyncMemberState const type.
func PossibleSyncMemberStateValues() []SyncMemberState {
	return []SyncMemberState{SyncMemberStateDeProvisioned, SyncMemberStateDeProvisionFailed, SyncMemberStateDeProvisioning, SyncMemberStateDisabledBackupRestore, SyncMemberStateDisabledTombstoneCleanup, SyncMemberStateProvisioned, SyncMemberStateProvisionFailed, SyncMemberStateProvisioning, SyncMemberStateReprovisionFailed, SyncMemberStateReprovisioning, SyncMemberStateSyncCancelled, SyncMemberStateSyncCancelling, SyncMemberStateSyncFailed, SyncMemberStateSyncInProgress, SyncMemberStateSyncSucceeded, SyncMemberStateSyncSucceededWithWarnings, SyncMemberStateUnProvisioned, SyncMemberStateUnReprovisioned}
}

// TableTemporalType enumerates the values for table temporal type.
type TableTemporalType string

const (
	// TableTemporalTypeHistoryTable ...
	TableTemporalTypeHistoryTable TableTemporalType = "HistoryTable"
	// TableTemporalTypeNonTemporalTable ...
	TableTemporalTypeNonTemporalTable TableTemporalType = "NonTemporalTable"
	// TableTemporalTypeSystemVersionedTemporalTable ...
	TableTemporalTypeSystemVersionedTemporalTable TableTemporalType = "SystemVersionedTemporalTable"
)

// PossibleTableTemporalTypeValues returns an array of possible values for the TableTemporalType const type.
func PossibleTableTemporalTypeValues() []TableTemporalType {
	return []TableTemporalType{TableTemporalTypeHistoryTable, TableTemporalTypeNonTemporalTable, TableTemporalTypeSystemVersionedTemporalTable}
}

// TargetBackupStorageRedundancy enumerates the values for target backup storage redundancy.
type TargetBackupStorageRedundancy string

const (
	// TargetBackupStorageRedundancyGeo ...
	TargetBackupStorageRedundancyGeo TargetBackupStorageRedundancy = "Geo"
	// TargetBackupStorageRedundancyLocal ...
	TargetBackupStorageRedundancyLocal TargetBackupStorageRedundancy = "Local"
	// TargetBackupStorageRedundancyZone ...
	TargetBackupStorageRedundancyZone TargetBackupStorageRedundancy = "Zone"
)

// PossibleTargetBackupStorageRedundancyValues returns an array of possible values for the TargetBackupStorageRedundancy const type.
func PossibleTargetBackupStorageRedundancyValues() []TargetBackupStorageRedundancy {
	return []TargetBackupStorageRedundancy{TargetBackupStorageRedundancyGeo, TargetBackupStorageRedundancyLocal, TargetBackupStorageRedundancyZone}
}

// TransparentDataEncryptionActivityStatus enumerates the values for transparent data encryption activity
// status.
type TransparentDataEncryptionActivityStatus string

const (
	// TransparentDataEncryptionActivityStatusDecrypting ...
	TransparentDataEncryptionActivityStatusDecrypting TransparentDataEncryptionActivityStatus = "Decrypting"
	// TransparentDataEncryptionActivityStatusEncrypting ...
	TransparentDataEncryptionActivityStatusEncrypting TransparentDataEncryptionActivityStatus = "Encrypting"
)

// PossibleTransparentDataEncryptionActivityStatusValues returns an array of possible values for the TransparentDataEncryptionActivityStatus const type.
func PossibleTransparentDataEncryptionActivityStatusValues() []TransparentDataEncryptionActivityStatus {
	return []TransparentDataEncryptionActivityStatus{TransparentDataEncryptionActivityStatusDecrypting, TransparentDataEncryptionActivityStatusEncrypting}
}

// TransparentDataEncryptionState enumerates the values for transparent data encryption state.
type TransparentDataEncryptionState string

const (
	// TransparentDataEncryptionStateDisabled ...
	TransparentDataEncryptionStateDisabled TransparentDataEncryptionState = "Disabled"
	// TransparentDataEncryptionStateEnabled ...
	TransparentDataEncryptionStateEnabled TransparentDataEncryptionState = "Enabled"
)

// PossibleTransparentDataEncryptionStateValues returns an array of possible values for the TransparentDataEncryptionState const type.
func PossibleTransparentDataEncryptionStateValues() []TransparentDataEncryptionState {
	return []TransparentDataEncryptionState{TransparentDataEncryptionStateDisabled, TransparentDataEncryptionStateEnabled}
}

// TransparentDataEncryptionStatus enumerates the values for transparent data encryption status.
type TransparentDataEncryptionStatus string

const (
	// TransparentDataEncryptionStatusDisabled ...
	TransparentDataEncryptionStatusDisabled TransparentDataEncryptionStatus = "Disabled"
	// TransparentDataEncryptionStatusEnabled ...
	TransparentDataEncryptionStatusEnabled TransparentDataEncryptionStatus = "Enabled"
)

// PossibleTransparentDataEncryptionStatusValues returns an array of possible values for the TransparentDataEncryptionStatus const type.
func PossibleTransparentDataEncryptionStatusValues() []TransparentDataEncryptionStatus {
	return []TransparentDataEncryptionStatus{TransparentDataEncryptionStatusDisabled, TransparentDataEncryptionStatusEnabled}
}

// UnitDefinitionType enumerates the values for unit definition type.
type UnitDefinitionType string

const (
	// UnitDefinitionTypeBytes ...
	UnitDefinitionTypeBytes UnitDefinitionType = "Bytes"
	// UnitDefinitionTypeBytesPerSecond ...
	UnitDefinitionTypeBytesPerSecond UnitDefinitionType = "BytesPerSecond"
	// UnitDefinitionTypeCount ...
	UnitDefinitionTypeCount UnitDefinitionType = "Count"
	// UnitDefinitionTypeCountPerSecond ...
	UnitDefinitionTypeCountPerSecond UnitDefinitionType = "CountPerSecond"
	// UnitDefinitionTypePercent ...
	UnitDefinitionTypePercent UnitDefinitionType = "Percent"
	// UnitDefinitionTypeSeconds ...
	UnitDefinitionTypeSeconds UnitDefinitionType = "Seconds"
)

// PossibleUnitDefinitionTypeValues returns an array of possible values for the UnitDefinitionType const type.
func PossibleUnitDefinitionTypeValues() []UnitDefinitionType {
	return []UnitDefinitionType{UnitDefinitionTypeBytes, UnitDefinitionTypeBytesPerSecond, UnitDefinitionTypeCount, UnitDefinitionTypeCountPerSecond, UnitDefinitionTypePercent, UnitDefinitionTypeSeconds}
}

// UnitType enumerates the values for unit type.
type UnitType string

const (
	// UnitTypeBytes ...
	UnitTypeBytes UnitType = "bytes"
	// UnitTypeBytesPerSecond ...
	UnitTypeBytesPerSecond UnitType = "bytesPerSecond"
	// UnitTypeCount ...
	UnitTypeCount UnitType = "count"
	// UnitTypeCountPerSecond ...
	UnitTypeCountPerSecond UnitType = "countPerSecond"
	// UnitTypePercent ...
	UnitTypePercent UnitType = "percent"
	// UnitTypeSeconds ...
	UnitTypeSeconds UnitType = "seconds"
)

// PossibleUnitTypeValues returns an array of possible values for the UnitType const type.
func PossibleUnitTypeValues() []UnitType {
	return []UnitType{UnitTypeBytes, UnitTypeBytesPerSecond, UnitTypeCount, UnitTypeCountPerSecond, UnitTypePercent, UnitTypeSeconds}
}

// VirtualNetworkRuleState enumerates the values for virtual network rule state.
type VirtualNetworkRuleState string

const (
	// VirtualNetworkRuleStateDeleting ...
	VirtualNetworkRuleStateDeleting VirtualNetworkRuleState = "Deleting"
	// VirtualNetworkRuleStateFailed ...
	VirtualNetworkRuleStateFailed VirtualNetworkRuleState = "Failed"
	// VirtualNetworkRuleStateInitializing ...
	VirtualNetworkRuleStateInitializing VirtualNetworkRuleState = "Initializing"
	// VirtualNetworkRuleStateInProgress ...
	VirtualNetworkRuleStateInProgress VirtualNetworkRuleState = "InProgress"
	// VirtualNetworkRuleStateReady ...
	VirtualNetworkRuleStateReady VirtualNetworkRuleState = "Ready"
	// VirtualNetworkRuleStateUnknown ...
	VirtualNetworkRuleStateUnknown VirtualNetworkRuleState = "Unknown"
)

// PossibleVirtualNetworkRuleStateValues returns an array of possible values for the VirtualNetworkRuleState const type.
func PossibleVirtualNetworkRuleStateValues() []VirtualNetworkRuleState {
	return []VirtualNetworkRuleState{VirtualNetworkRuleStateDeleting, VirtualNetworkRuleStateFailed, VirtualNetworkRuleStateInitializing, VirtualNetworkRuleStateInProgress, VirtualNetworkRuleStateReady, VirtualNetworkRuleStateUnknown}
}

// VulnerabilityAssessmentPolicyBaselineName enumerates the values for vulnerability assessment policy baseline
// name.
type VulnerabilityAssessmentPolicyBaselineName string

const (
	// VulnerabilityAssessmentPolicyBaselineNameDefault ...
	VulnerabilityAssessmentPolicyBaselineNameDefault VulnerabilityAssessmentPolicyBaselineName = "default"
	// VulnerabilityAssessmentPolicyBaselineNameMaster ...
	VulnerabilityAssessmentPolicyBaselineNameMaster VulnerabilityAssessmentPolicyBaselineName = "master"
)

// PossibleVulnerabilityAssessmentPolicyBaselineNameValues returns an array of possible values for the VulnerabilityAssessmentPolicyBaselineName const type.
func PossibleVulnerabilityAssessmentPolicyBaselineNameValues() []VulnerabilityAssessmentPolicyBaselineName {
	return []VulnerabilityAssessmentPolicyBaselineName{VulnerabilityAssessmentPolicyBaselineNameDefault, VulnerabilityAssessmentPolicyBaselineNameMaster}
}

// VulnerabilityAssessmentScanState enumerates the values for vulnerability assessment scan state.
type VulnerabilityAssessmentScanState string

const (
	// VulnerabilityAssessmentScanStateFailed ...
	VulnerabilityAssessmentScanStateFailed VulnerabilityAssessmentScanState = "Failed"
	// VulnerabilityAssessmentScanStateFailedToRun ...
	VulnerabilityAssessmentScanStateFailedToRun VulnerabilityAssessmentScanState = "FailedToRun"
	// VulnerabilityAssessmentScanStateInProgress ...
	VulnerabilityAssessmentScanStateInProgress VulnerabilityAssessmentScanState = "InProgress"
	// VulnerabilityAssessmentScanStatePassed ...
	VulnerabilityAssessmentScanStatePassed VulnerabilityAssessmentScanState = "Passed"
)

// PossibleVulnerabilityAssessmentScanStateValues returns an array of possible values for the VulnerabilityAssessmentScanState const type.
func PossibleVulnerabilityAssessmentScanStateValues() []VulnerabilityAssessmentScanState {
	return []VulnerabilityAssessmentScanState{VulnerabilityAssessmentScanStateFailed, VulnerabilityAssessmentScanStateFailedToRun, VulnerabilityAssessmentScanStateInProgress, VulnerabilityAssessmentScanStatePassed}
}

// VulnerabilityAssessmentScanTriggerType enumerates the values for vulnerability assessment scan trigger type.
type VulnerabilityAssessmentScanTriggerType string

const (
	// VulnerabilityAssessmentScanTriggerTypeOnDemand ...
	VulnerabilityAssessmentScanTriggerTypeOnDemand VulnerabilityAssessmentScanTriggerType = "OnDemand"
	// VulnerabilityAssessmentScanTriggerTypeRecurring ...
	VulnerabilityAssessmentScanTriggerTypeRecurring VulnerabilityAssessmentScanTriggerType = "Recurring"
)

// PossibleVulnerabilityAssessmentScanTriggerTypeValues returns an array of possible values for the VulnerabilityAssessmentScanTriggerType const type.
func PossibleVulnerabilityAssessmentScanTriggerTypeValues() []VulnerabilityAssessmentScanTriggerType {
	return []VulnerabilityAssessmentScanTriggerType{VulnerabilityAssessmentScanTriggerTypeOnDemand, VulnerabilityAssessmentScanTriggerTypeRecurring}
}
