package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryDataMessage invokes the airec.QueryDataMessage API synchronously
func (client *Client) QueryDataMessage(request *QueryDataMessageRequest) (response *QueryDataMessageResponse, err error) {
	response = CreateQueryDataMessageResponse()
	err = client.DoAction(request, response)
	return
}

// QueryDataMessageWithChan invokes the airec.QueryDataMessage API asynchronously
func (client *Client) QueryDataMessageWithChan(request *QueryDataMessageRequest) (<-chan *QueryDataMessageResponse, <-chan error) {
	responseChan := make(chan *QueryDataMessageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryDataMessage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryDataMessageWithCallback invokes the airec.QueryDataMessage API asynchronously
func (client *Client) QueryDataMessageWithCallback(request *QueryDataMessageRequest, callback func(response *QueryDataMessageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryDataMessageResponse
		var err error
		defer close(result)
		response, err = client.QueryDataMessage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryDataMessageRequest is the request struct for api QueryDataMessage
type QueryDataMessageRequest struct {
	*requests.RoaRequest
	TraceId       string           `position:"Query" name:"traceId"`
	MessageSource string           `position:"Query" name:"messageSource"`
	EndTime       requests.Integer `position:"Query" name:"endTime"`
	UserType      string           `position:"Query" name:"userType"`
	StartTime     requests.Integer `position:"Query" name:"startTime"`
	UserId        string           `position:"Query" name:"userId"`
	ItemId        string           `position:"Query" name:"itemId"`
	InstanceId    string           `position:"Path" name:"instanceId"`
	ItemType      string           `position:"Query" name:"itemType"`
	CmdType       string           `position:"Query" name:"cmdType"`
	Size          requests.Integer `position:"Query" name:"size"`
	SceneId       string           `position:"Query" name:"sceneId"`
	BhvType       string           `position:"Query" name:"bhvType"`
	Page          requests.Integer `position:"Query" name:"page"`
	Table         string           `position:"Path" name:"table"`
}

// QueryDataMessageResponse is the response struct for api QueryDataMessage
type QueryDataMessageResponse struct {
	*responses.BaseResponse
	Code      string                 `json:"code" xml:"code"`
	Message   string                 `json:"message" xml:"message"`
	RequestId string                 `json:"requestId" xml:"requestId"`
	Result    map[string]interface{} `json:"result" xml:"result"`
}

// CreateQueryDataMessageRequest creates a request to invoke QueryDataMessage API
func CreateQueryDataMessageRequest() (request *QueryDataMessageRequest) {
	request = &QueryDataMessageRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "QueryDataMessage", "/v2/openapi/instances/[instanceId]/tables/[table]/data-message", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateQueryDataMessageResponse creates a response to parse from QueryDataMessage response
func CreateQueryDataMessageResponse() (response *QueryDataMessageResponse) {
	response = &QueryDataMessageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
