package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAppGroupMetrics invokes the opensearch.ListAppGroupMetrics API synchronously
func (client *Client) ListAppGroupMetrics(request *ListAppGroupMetricsRequest) (response *ListAppGroupMetricsResponse, err error) {
	response = CreateListAppGroupMetricsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAppGroupMetricsWithChan invokes the opensearch.ListAppGroupMetrics API asynchronously
func (client *Client) ListAppGroupMetricsWithChan(request *ListAppGroupMetricsRequest) (<-chan *ListAppGroupMetricsResponse, <-chan error) {
	responseChan := make(chan *ListAppGroupMetricsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAppGroupMetrics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAppGroupMetricsWithCallback invokes the opensearch.ListAppGroupMetrics API asynchronously
func (client *Client) ListAppGroupMetricsWithCallback(request *ListAppGroupMetricsRequest, callback func(response *ListAppGroupMetricsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAppGroupMetricsResponse
		var err error
		defer close(result)
		response, err = client.ListAppGroupMetrics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAppGroupMetricsRequest is the request struct for api ListAppGroupMetrics
type ListAppGroupMetricsRequest struct {
	*requests.RoaRequest
	MetricType       string           `position:"Query" name:"metricType"`
	Indexes          string           `position:"Query" name:"indexes"`
	EndTime          requests.Integer `position:"Query" name:"endTime"`
	StartTime        requests.Integer `position:"Query" name:"startTime"`
	AppGroupIdentity string           `position:"Path" name:"appGroupIdentity"`
}

// ListAppGroupMetricsResponse is the response struct for api ListAppGroupMetrics
type ListAppGroupMetricsResponse struct {
	*responses.BaseResponse
	RequestId string                   `json:"requestId" xml:"requestId"`
	Result    []map[string]interface{} `json:"result" xml:"result"`
}

// CreateListAppGroupMetricsRequest creates a request to invoke ListAppGroupMetrics API
func CreateListAppGroupMetricsRequest() (request *ListAppGroupMetricsRequest) {
	request = &ListAppGroupMetricsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "ListAppGroupMetrics", "/v4/openapi/app-groups/[appGroupIdentity]/metrics", "opensearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListAppGroupMetricsResponse creates a response to parse from ListAppGroupMetrics response
func CreateListAppGroupMetricsResponse() (response *ListAppGroupMetricsResponse) {
	response = &ListAppGroupMetricsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
