package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFabricConsortiums invokes the baas.DescribeFabricConsortiums API synchronously
// api document: https://help.aliyun.com/api/baas/describefabricconsortiums.html
func (client *Client) DescribeFabricConsortiums(request *DescribeFabricConsortiumsRequest) (response *DescribeFabricConsortiumsResponse, err error) {
	response = CreateDescribeFabricConsortiumsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFabricConsortiumsWithChan invokes the baas.DescribeFabricConsortiums API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricconsortiums.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricConsortiumsWithChan(request *DescribeFabricConsortiumsRequest) (<-chan *DescribeFabricConsortiumsResponse, <-chan error) {
	responseChan := make(chan *DescribeFabricConsortiumsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFabricConsortiums(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFabricConsortiumsWithCallback invokes the baas.DescribeFabricConsortiums API asynchronously
// api document: https://help.aliyun.com/api/baas/describefabricconsortiums.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeFabricConsortiumsWithCallback(request *DescribeFabricConsortiumsRequest, callback func(response *DescribeFabricConsortiumsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFabricConsortiumsResponse
		var err error
		defer close(result)
		response, err = client.DescribeFabricConsortiums(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFabricConsortiumsRequest is the request struct for api DescribeFabricConsortiums
type DescribeFabricConsortiumsRequest struct {
	*requests.RpcRequest
	Location     string `position:"Body" name:"Location"`
	ConsortiumId string `position:"Query" name:"ConsortiumId"`
}

// DescribeFabricConsortiumsResponse is the response struct for api DescribeFabricConsortiums
type DescribeFabricConsortiumsResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Success   bool         `json:"Success" xml:"Success"`
	ErrorCode int          `json:"ErrorCode" xml:"ErrorCode"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateDescribeFabricConsortiumsRequest creates a request to invoke DescribeFabricConsortiums API
func CreateDescribeFabricConsortiumsRequest() (request *DescribeFabricConsortiumsRequest) {
	request = &DescribeFabricConsortiumsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "DescribeFabricConsortiums", "baas", "openAPI")
	return
}

// CreateDescribeFabricConsortiumsResponse creates a response to parse from DescribeFabricConsortiums response
func CreateDescribeFabricConsortiumsResponse() (response *DescribeFabricConsortiumsResponse) {
	response = &DescribeFabricConsortiumsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
