package sae

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAppSecurityGroup invokes the sae.UpdateAppSecurityGroup API synchronously
func (client *Client) UpdateAppSecurityGroup(request *UpdateAppSecurityGroupRequest) (response *UpdateAppSecurityGroupResponse, err error) {
	response = CreateUpdateAppSecurityGroupResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAppSecurityGroupWithChan invokes the sae.UpdateAppSecurityGroup API asynchronously
func (client *Client) UpdateAppSecurityGroupWithChan(request *UpdateAppSecurityGroupRequest) (<-chan *UpdateAppSecurityGroupResponse, <-chan error) {
	responseChan := make(chan *UpdateAppSecurityGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAppSecurityGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAppSecurityGroupWithCallback invokes the sae.UpdateAppSecurityGroup API asynchronously
func (client *Client) UpdateAppSecurityGroupWithCallback(request *UpdateAppSecurityGroupRequest, callback func(response *UpdateAppSecurityGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAppSecurityGroupResponse
		var err error
		defer close(result)
		response, err = client.UpdateAppSecurityGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAppSecurityGroupRequest is the request struct for api UpdateAppSecurityGroup
type UpdateAppSecurityGroupRequest struct {
	*requests.RoaRequest
	AppId           string `position:"Query" name:"AppId"`
	SecurityGroupId string `position:"Query" name:"SecurityGroupId"`
}

// UpdateAppSecurityGroupResponse is the response struct for api UpdateAppSecurityGroup
type UpdateAppSecurityGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	TraceId   string `json:"TraceId" xml:"TraceId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateUpdateAppSecurityGroupRequest creates a request to invoke UpdateAppSecurityGroup API
func CreateUpdateAppSecurityGroupRequest() (request *UpdateAppSecurityGroupRequest) {
	request = &UpdateAppSecurityGroupRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("sae", "2019-05-06", "UpdateAppSecurityGroup", "/pop/v1/sam/app/updateAppSecurityGroup", "serverless", "openAPI")
	request.Method = requests.PUT
	return
}

// CreateUpdateAppSecurityGroupResponse creates a response to parse from UpdateAppSecurityGroup response
func CreateUpdateAppSecurityGroupResponse() (response *UpdateAppSecurityGroupResponse) {
	response = &UpdateAppSecurityGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
