package webplus

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeConfigOptions invokes the webplus.DescribeConfigOptions API synchronously
// api document: https://help.aliyun.com/api/webplus/describeconfigoptions.html
func (client *Client) DescribeConfigOptions(request *DescribeConfigOptionsRequest) (response *DescribeConfigOptionsResponse, err error) {
	response = CreateDescribeConfigOptionsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeConfigOptionsWithChan invokes the webplus.DescribeConfigOptions API asynchronously
// api document: https://help.aliyun.com/api/webplus/describeconfigoptions.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConfigOptionsWithChan(request *DescribeConfigOptionsRequest) (<-chan *DescribeConfigOptionsResponse, <-chan error) {
	responseChan := make(chan *DescribeConfigOptionsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeConfigOptions(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeConfigOptionsWithCallback invokes the webplus.DescribeConfigOptions API asynchronously
// api document: https://help.aliyun.com/api/webplus/describeconfigoptions.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeConfigOptionsWithCallback(request *DescribeConfigOptionsRequest, callback func(response *DescribeConfigOptionsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeConfigOptionsResponse
		var err error
		defer close(result)
		response, err = client.DescribeConfigOptions(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeConfigOptionsRequest is the request struct for api DescribeConfigOptions
type DescribeConfigOptionsRequest struct {
	*requests.RoaRequest
	StackId     string `position:"Query" name:"StackId"`
	ProfileName string `position:"Query" name:"ProfileName"`
	EnvId       string `position:"Query" name:"EnvId"`
}

// DescribeConfigOptionsResponse is the response struct for api DescribeConfigOptions
type DescribeConfigOptionsResponse struct {
	*responses.BaseResponse
	RequestId         string            `json:"RequestId" xml:"RequestId"`
	Code              string            `json:"Code" xml:"Code"`
	Message           string            `json:"Message" xml:"Message"`
	StackConfigOption StackConfigOption `json:"StackConfigOption" xml:"StackConfigOption"`
}

// CreateDescribeConfigOptionsRequest creates a request to invoke DescribeConfigOptions API
func CreateDescribeConfigOptionsRequest() (request *DescribeConfigOptionsRequest) {
	request = &DescribeConfigOptionsRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("WebPlus", "2019-03-20", "DescribeConfigOptions", "/pop/v1/wam/config/configOption", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeConfigOptionsResponse creates a response to parse from DescribeConfigOptions response
func CreateDescribeConfigOptionsResponse() (response *DescribeConfigOptionsResponse) {
	response = &DescribeConfigOptionsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
