/*
 * MetaSound decoder
 * Copyright (c) 2013 Konstantin Shishkov
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef AVCODEC_METASOUND_TWINVQ_DATA_H
#define AVCODEC_METASOUND_TWINVQ_DATA_H

#include "twinvq.h"

const float ff_metasound_lsp8[] = {
     0.2702,  0.5096,  0.6437,  0.7672,  0.9639,  1.0696,  1.2625,  1.5789,
     1.9285,  2.2383,  2.5129,  2.8470,  0.1740,  0.3677,  0.6082,  0.8387,
     1.1084,  1.3721,  1.6362,  1.8733,  2.0640,  2.3442,  2.6087,  2.8548,
     0.1536,  0.3279,  0.5143,  0.6859,  0.9763,  1.2744,  1.5605,  1.8566,
     2.1007,  2.3450,  2.6075,  2.8850,  0.2075,  0.4533,  0.7709,  1.0377,
     1.2953,  1.5132,  1.7826,  2.0351,  2.2590,  2.4996,  2.6795,  2.8748,
     0.1393,  0.2453,  0.3754,  0.5453,  0.8148,  1.1289,  1.4389,  1.7592,
     2.0353,  2.3215,  2.5934,  2.8588,  0.1250,  0.3627,  0.7613,  1.1380,
     1.4163,  1.5565,  1.6920,  1.8130,  1.8678,  2.0427,  2.4318,  2.8544,
     0.2256,  0.4223,  0.6452,  0.8599,  1.0673,  1.3118,  1.5486,  1.8366,
     2.0759,  2.3026,  2.5284,  2.8030,  0.2304,  0.4404,  0.6891,  0.8964,
     1.1510,  1.4202,  1.6483,  1.8580,  2.1181,  2.3686,  2.6078,  2.9128,
     0.2230,  0.3816,  0.5520,  0.6062,  0.7909,  1.0988,  1.4330,  1.7846,
     2.0713,  2.3457,  2.6048,  2.8708,  0.2447,  0.5800,  0.8249,  0.9905,
     1.1721,  1.3990,  1.6694,  1.9064,  2.1307,  2.4255,  2.6815,  2.9117,
     0.1974,  0.3812,  0.5802,  0.7759,  0.9280,  1.1547,  1.4170,  1.6369,
     1.8890,  2.2587,  2.5626,  2.8239,  0.1209,  0.2510,  0.4841,  0.8048,
     1.1197,  1.3563,  1.6073,  1.8926,  2.1350,  2.3669,  2.6291,  2.8985,
     0.2352,  0.4347,  0.6582,  0.8178,  0.9548,  1.1654,  1.4942,  1.8812,
     2.1703,  2.3779,  2.6412,  2.8871,  0.2091,  0.4084,  0.6730,  0.9151,
     1.1259,  1.3262,  1.5937,  1.8129,  2.0237,  2.3317,  2.5778,  2.8620,
     0.1167,  0.2406,  0.4520,  0.7298,  0.9848,  1.2448,  1.5137,  1.7874,
     2.0280,  2.3020,  2.5914,  2.8794,  0.3003,  0.4966,  0.6520,  0.8505,
     1.1600,  1.3981,  1.5805,  1.8346,  2.0757,  2.3102,  2.5760,  2.8499,
     0.2451,  0.4163,  0.5960,  0.7805,  0.9507,  1.2438,  1.5587,  1.8581,
     2.0735,  2.3198,  2.5704,  2.8220,  0.3112,  0.5517,  0.7032,  0.8528,
     1.1489,  1.4257,  1.6848,  1.9388,  2.1577,  2.4265,  2.6678,  2.9051,
     0.2249,  0.3897,  0.5559,  0.7473,  1.0158,  1.3581,  1.6914,  1.9930,
     2.1843,  2.3534,  2.5512,  2.8065,  0.2600,  0.4574,  0.7349,  0.9691,
     1.1696,  1.3848,  1.6335,  1.9021,  2.1174,  2.3481,  2.5902,  2.8390,
     0.2246,  0.3372,  0.4560,  0.5249,  0.7056,  1.0273,  1.3810,  1.7132,
     1.9819,  2.2574,  2.5410,  2.8491,  0.1419,  0.4834,  0.8835,  1.1453,
     1.2839,  1.4224,  1.5593,  1.7877,  2.1285,  2.4070,  2.6043,  2.8511,
     0.1886,  0.3677,  0.5617,  0.8099,  1.1277,  1.3841,  1.5804,  1.8136,
     2.0307,  2.2805,  2.5399,  2.8322,  0.2351,  0.4151,  0.6675,  0.8713,
     1.0464,  1.3292,  1.6586,  1.9281,  2.1355,  2.3495,  2.6222,  2.8782,
     0.2700,  0.4489,  0.6206,  0.7121,  0.7737,  0.9848,  1.3658,  1.7433,
     2.0139,  2.2243,  2.4806,  2.8175,  0.2479,  0.4425,  0.6490,  0.8745,
     1.1161,  1.3849,  1.6773,  1.9566,  2.1491,  2.3624,  2.5685,  2.8114,
     0.2035,  0.3701,  0.5567,  0.7953,  1.0082,  1.2758,  1.5373,  1.7822,
     2.0175,  2.2601,  2.4759,  2.7771,  0.1856,  0.3461,  0.5998,  0.9041,
     1.2383,  1.4612,  1.6667,  1.9305,  2.1617,  2.4107,  2.6477,  2.8656,
     0.2107,  0.3715,  0.5289,  0.6651,  0.8420,  1.1168,  1.4401,  1.7230,
     1.9901,  2.2687,  2.5452,  2.8655,  0.1218,  0.2999,  0.6348,  0.9482,
     1.2745,  1.5876,  1.9129,  2.2348,  2.4020,  2.4922,  2.6351,  2.8357,
     0.1617,  0.3483,  0.5869,  0.8163,  1.0366,  1.2344,  1.4609,  1.7029,
     1.9476,  2.2337,  2.5258,  2.8442,  0.2505,  0.4894,  0.7510,  0.9152,
     1.0845,  1.3657,  1.6528,  1.8346,  2.0160,  2.2811,  2.5338,  2.8136,
     0.0947,  0.1158,  0.0578, -0.0337, -0.0066,  0.0104, -0.0447, -0.0505,
    -0.0778, -0.0293,  0.0251, -0.0143,  0.0349, -0.0227, -0.0909,  0.0523,
     0.0325, -0.0410, -0.1045, -0.0899, -0.0009,  0.0075, -0.0575, -0.0855,
    -0.0129,  0.0575,  0.0597,  0.0391,  0.0371, -0.0184, -0.0083,  0.0287,
     0.0143,  0.0167,  0.0120, -0.0168,  0.0452,  0.0223, -0.0352,  0.0119,
    -0.0496, -0.0965, -0.0661, -0.0072,  0.1099,  0.0843, -0.0087, -0.0478,
    -0.0128, -0.0120, -0.0004,  0.0731,  0.1047,  0.0630,  0.0196, -0.0103,
    -0.0399, -0.0986, -0.0912, -0.0390, -0.0247, -0.0694, -0.0749, -0.0066,
     0.0223,  0.0634,  0.0343, -0.0134,  0.0727,  0.0241,  0.0066,  0.0437,
     0.0610,  0.0364,  0.0248, -0.0358, -0.0686, -0.0104,  0.0426,  0.0088,
    -0.0137, -0.0165,  0.0671,  0.0815, -0.0863, -0.0644, -0.0088,  0.0023,
     0.0482,  0.1174,  0.1270,  0.0594,  0.0165,  0.0949,  0.1098,  0.0137,
     0.4951,  0.4999,  0.4958,  0.4907,  0.4984,  0.4965,  0.4958,  0.4996,
     0.4987,  0.4958,  0.4986,  0.4977,  0.2841,  0.2186,  0.1474,  0.1687,
     0.2217,  0.2632,  0.2706,  0.2624,  0.2162,  0.2453,  0.2460,  0.2531,
};

const float ff_metasound_lsp11[] = {
     0.1103,  0.3862,  0.6863,  0.8447,  0.9231,  1.0261,  1.1248,  1.4057,
     1.6621,  1.8010,  1.8692,  2.0704,  2.3490,  2.6060,  2.7539,  2.8977,
     0.1273,  0.2407,  0.3812,  0.6004,  0.7767,  0.9383,  1.1344,  1.3351,
     1.5233,  1.7262,  1.9466,  2.1739,  2.3495,  2.5162,  2.7164,  2.9202,
     0.2010,  0.3330,  0.4488,  0.6465,  0.8046,  0.9889,  1.1479,  1.2964,
     1.4770,  1.6606,  1.8789,  2.1155,  2.3287,  2.5199,  2.7101,  2.9119,
     0.1168,  0.2197,  0.3279,  0.4691,  0.6268,  0.8251,  1.0533,  1.2714,
     1.4712,  1.6762,  1.8831,  2.1114,  2.3230,  2.5297,  2.7365,  2.9270,
     0.1405,  0.3109,  0.4986,  0.6891,  0.8634,  1.0583,  1.2594,  1.4349,
     1.6232,  1.8116,  1.9905,  2.1935,  2.3799,  2.5656,  2.7661,  2.9486,
     0.1703,  0.3057,  0.4403,  0.5225,  0.5969,  0.8110,  1.0729,  1.3215,
     1.5407,  1.7381,  1.9477,  2.1680,  2.3586,  2.5612,  2.7630,  2.9410,
     0.1128,  0.2628,  0.4523,  0.6495,  0.8176,  0.9816,  1.1746,  1.3710,
     1.5568,  1.7518,  1.9497,  2.1452,  2.3346,  2.5389,  2.7362,  2.9264,
     0.1809,  0.3287,  0.5205,  0.7264,  0.9298,  1.1217,  1.2970,  1.4894,
     1.6874,  1.8493,  2.0576,  2.2382,  2.4097,  2.6041,  2.7796,  2.9389,
     0.2502,  0.4709,  0.6892,  0.8346,  0.9209,  1.0455,  1.2399,  1.4616,
     1.6463,  1.8380,  2.0475,  2.2397,  2.4665,  2.6550,  2.7701,  2.8895,
     0.1040,  0.2340,  0.3964,  0.5740,  0.7764,  0.9941,  1.2000,  1.4014,
     1.6024,  1.7974,  1.9939,  2.1959,  2.3783,  2.5663,  2.7613,  2.9484,
     0.1912,  0.3393,  0.4743,  0.6313,  0.8014,  0.9879,  1.1855,  1.3922,
     1.5678,  1.7289,  1.9271,  2.1165,  2.3089,  2.5414,  2.7448,  2.9269,
     0.0965,  0.2025,  0.3398,  0.4990,  0.6934,  0.9386,  1.1730,  1.3766,
     1.5783,  1.7783,  1.9790,  2.1831,  2.3670,  2.5578,  2.7641,  2.9516,
     0.2126,  0.3652,  0.5545,  0.7170,  0.8674,  1.0640,  1.2558,  1.4061,
     1.5904,  1.8095,  1.9760,  2.1505,  2.3549,  2.5575,  2.7023,  2.8877,
     0.1827,  0.3426,  0.4894,  0.6488,  0.7960,  0.9535,  1.1217,  1.2798,
     1.4566,  1.6453,  1.8044,  2.0042,  2.2379,  2.4611,  2.6697,  2.8966,
     0.2034,  0.3822,  0.5231,  0.6960,  0.9200,  1.0394,  1.1616,  1.3772,
     1.5493,  1.7330,  1.9646,  2.1233,  2.3334,  2.5361,  2.7087,  2.9470,
     0.1050,  0.2060,  0.3705,  0.5998,  0.8337,  1.0577,  1.2559,  1.4327,
     1.6334,  1.8165,  1.9853,  2.2058,  2.4063,  2.5818,  2.7625,  2.9458,
     0.1419,  0.4053,  0.6660,  0.8911,  1.0405,  1.1547,  1.2506,  1.3926,
     1.5669,  1.7527,  1.9694,  2.2054,  2.3889,  2.5743,  2.7586,  2.9174,
     0.1514,  0.2825,  0.4309,  0.5772,  0.7470,  0.9703,  1.1462,  1.3316,
     1.5321,  1.7259,  1.9282,  2.1266,  2.3106,  2.5064,  2.7067,  2.9094,
     0.1693,  0.3156,  0.4878,  0.6635,  0.8206,  0.9569,  1.1154,  1.3064,
     1.5109,  1.7184,  1.9179,  2.1036,  2.2763,  2.4820,  2.6949,  2.9105,
     0.1432,  0.2718,  0.4241,  0.5564,  0.6939,  0.9011,  1.1582,  1.3948,
     1.6181,  1.8024,  1.9814,  2.1740,  2.3459,  2.5456,  2.7491,  2.9307,
     0.2294,  0.3857,  0.5590,  0.7434,  0.9189,  1.0941,  1.2740,  1.4456,
     1.6178,  1.7994,  1.9689,  2.1644,  2.3525,  2.5385,  2.7468,  2.9405,
     0.1667,  0.3109,  0.4612,  0.6032,  0.7375,  0.8866,  1.0840,  1.3053,
     1.4982,  1.7044,  1.9146,  2.1117,  2.2942,  2.4983,  2.7084,  2.9132,
     0.1810,  0.3205,  0.4696,  0.6231,  0.7641,  0.9959,  1.2427,  1.4361,
     1.5889,  1.7544,  1.9083,  2.0733,  2.2457,  2.4461,  2.6793,  2.9098,
     0.1164,  0.3753,  0.6068,  0.7503,  1.0100,  1.2131,  1.3793,  1.5302,
     1.6300,  1.7950,  1.9057,  2.1031,  2.3830,  2.5745,  2.6949,  2.8779,
     0.1571,  0.4378,  0.6735,  0.8312,  0.8944,  0.9818,  1.1622,  1.4094,
     1.6423,  1.8066,  1.9258,  2.1838,  2.4363,  2.6279,  2.7358,  2.8790,
     0.1398,  0.2686,  0.4248,  0.6156,  0.7870,  1.0035,  1.2012,  1.3689,
     1.5363,  1.7398,  1.9604,  2.1619,  2.3345,  2.5097,  2.7271,  2.9368,
     0.1913,  0.3338,  0.4987,  0.6446,  0.7852,  1.0163,  1.1886,  1.3610,
     1.5379,  1.7230,  1.8880,  2.0862,  2.2960,  2.4928,  2.7122,  2.9151,
     0.0908,  0.1752,  0.2899,  0.5365,  0.7761,  1.0100,  1.2124,  1.4060,
     1.6019,  1.8010,  1.9774,  2.1905,  2.3733,  2.5623,  2.7660,  2.9565,
     0.1773,  0.3179,  0.4925,  0.6864,  0.8452,  0.9897,  1.1860,  1.3722,
     1.5515,  1.7658,  1.9802,  2.1819,  2.3620,  2.5442,  2.7250,  2.9220,
     0.1286,  0.2341,  0.3689,  0.5364,  0.7176,  0.9350,  1.1083,  1.2943,
     1.4974,  1.7059,  1.9047,  2.1145,  2.3242,  2.5361,  2.7453,  2.9329,
     0.2273,  0.3834,  0.5565,  0.7192,  0.8431,  0.9962,  1.1763,  1.3571,
     1.5774,  1.7419,  1.9202,  2.1131,  2.2919,  2.4898,  2.6895,  2.9180,
     0.1775,  0.3058,  0.4274,  0.6023,  0.8151,  1.0734,  1.3211,  1.5178,
     1.6706,  1.8154,  1.9686,  2.1537,  2.3461,  2.5276,  2.7181,  2.9121,
     0.1653,  0.4304,  0.6361,  0.7824,  0.9183,  1.0452,  1.2071,  1.4077,
     1.6206,  1.8299,  2.0089,  2.1948,  2.3900,  2.5982,  2.7844,  2.9487,
     0.1492,  0.2609,  0.3820,  0.5485,  0.7243,  0.9319,  1.1538,  1.3579,
     1.5266,  1.7002,  1.8873,  2.1016,  2.3175,  2.5221,  2.7241,  2.9243,
     0.2074,  0.3781,  0.5209,  0.6869,  0.8577,  0.9875,  1.1849,  1.3568,
     1.4907,  1.7335,  1.8902,  2.1224,  2.3099,  2.4918,  2.7023,  2.8765,
     0.1359,  0.2254,  0.3286,  0.4432,  0.6586,  0.8964,  1.1125,  1.3523,
     1.5626,  1.7579,  1.9846,  2.1905,  2.3548,  2.5542,  2.7663,  2.9346,
     0.1430,  0.2966,  0.4685,  0.6493,  0.8315,  1.0304,  1.2220,  1.4082,
     1.5995,  1.7888,  1.9774,  2.1737,  2.3607,  2.5577,  2.7558,  2.9405,
     0.1477,  0.2694,  0.4056,  0.5626,  0.7051,  0.8647,  1.0491,  1.2488,
     1.4814,  1.7072,  1.9150,  2.1147,  2.3038,  2.5144,  2.7184,  2.9202,
     0.1690,  0.3033,  0.4580,  0.6686,  0.8536,  1.0293,  1.2124,  1.3998,
     1.5718,  1.7607,  1.9580,  2.1245,  2.2971,  2.4762,  2.6896,  2.9177,
     0.1092,  0.2779,  0.4853,  0.6880,  0.9011,  1.0953,  1.2752,  1.4618,
     1.6623,  1.8484,  2.0264,  2.2152,  2.4017,  2.5835,  2.7671,  2.9436,
     0.1497,  0.3637,  0.6014,  0.8032,  0.9963,  1.1835,  1.3741,  1.5698,
     1.7382,  1.9094,  2.0710,  2.2392,  2.4082,  2.5926,  2.7762,  2.9536,
     0.1434,  0.2492,  0.3966,  0.5934,  0.8033,  1.0657,  1.2796,  1.4276,
     1.5745,  1.7833,  1.9288,  2.1247,  2.3543,  2.5412,  2.7049,  2.8872,
     0.1612,  0.2926,  0.4574,  0.6387,  0.8265,  1.0180,  1.1808,  1.3526,
     1.5564,  1.7536,  1.9187,  2.1192,  2.3149,  2.5006,  2.7101,  2.9217,
     0.0828,  0.1863,  0.3235,  0.5050,  0.7250,  0.9867,  1.2093,  1.3941,
     1.5980,  1.7932,  1.9809,  2.1894,  2.3918,  2.5773,  2.7540,  2.9329,
     0.2001,  0.3655,  0.5290,  0.6761,  0.8027,  0.9972,  1.2090,  1.4255,
     1.6085,  1.7825,  1.9804,  2.1681,  2.3457,  2.5325,  2.7319,  2.9196,
     0.1505,  0.2767,  0.4254,  0.6054,  0.7821,  0.9567,  1.1294,  1.3080,
     1.4984,  1.6954,  1.8666,  2.0736,  2.2875,  2.4969,  2.7072,  2.9163,
     0.1589,  0.4151,  0.5749,  0.6651,  0.8061,  1.0470,  1.2616,  1.3690,
     1.4985,  1.7808,  1.9825,  2.1068,  2.2751,  2.5448,  2.7133,  2.8689,
     0.0916,  0.1846,  0.3788,  0.6329,  0.8774,  1.0687,  1.2653,  1.4561,
     1.6573,  1.8449,  2.0402,  2.2254,  2.3968,  2.5861,  2.7792,  2.9508,
     0.2282,  0.4159,  0.5834,  0.6899,  0.8108,  1.0321,  1.2795,  1.5262,
     1.6936,  1.8469,  2.0922,  2.2607,  2.3795,  2.5301,  2.7386,  2.9530,
     0.1651,  0.3004,  0.4555,  0.6179,  0.7891,  0.9584,  1.1372,  1.3707,
     1.5951,  1.7880,  1.9434,  2.1465,  2.3311,  2.5081,  2.6977,  2.8970,
     0.1279,  0.3828,  0.6330,  0.8323,  0.9652,  1.1175,  1.2319,  1.3511,
     1.5115,  1.6392,  1.7835,  1.9558,  2.2008,  2.4635,  2.6910,  2.9058,
     0.1193,  0.2185,  0.3521,  0.5311,  0.7378,  0.9239,  1.1105,  1.3217,
     1.5362,  1.7504,  1.9536,  2.1627,  2.3560,  2.5506,  2.7548,  2.9453,
     0.1806,  0.3432,  0.4981,  0.6948,  0.8928,  1.0527,  1.2467,  1.4140,
     1.6326,  1.7950,  1.9935,  2.1969,  2.3512,  2.5682,  2.7445,  2.9277,
     0.1846,  0.3112,  0.4568,  0.5891,  0.7317,  0.8493,  1.0204,  1.2022,
     1.3688,  1.6020,  1.8428,  2.0710,  2.2725,  2.4879,  2.7057,  2.9160,
     0.0880,  0.2514,  0.5332,  0.7272,  0.8906,  1.1354,  1.3199,  1.4941,
     1.6010,  1.7151,  1.8712,  2.0643,  2.2755,  2.5375,  2.7054,  2.8891,
     0.1382,  0.2833,  0.4658,  0.6897,  0.9071,  1.0716,  1.2469,  1.4143,
     1.5910,  1.7947,  1.9805,  2.1581,  2.3338,  2.5215,  2.7292,  2.9211,
     0.1061,  0.3494,  0.6327,  0.8570,  0.9748,  1.0560,  1.1529,  1.3250,
     1.6032,  1.8340,  1.9711,  2.1157,  2.3011,  2.5464,  2.8078,  2.9803,
     0.1603,  0.2839,  0.4307,  0.5980,  0.7980,  1.0399,  1.1971,  1.3524,
     1.5715,  1.7838,  1.9468,  2.1498,  2.3627,  2.5514,  2.7327,  2.9148,
     0.1691,  0.3117,  0.4796,  0.6895,  0.8732,  1.0164,  1.1916,  1.3707,
     1.5384,  1.7202,  1.8857,  2.0672,  2.2487,  2.4593,  2.6789,  2.8940,
     0.0965,  0.1702,  0.3191,  0.5721,  0.8100,  1.0241,  1.2272,  1.4196,
     1.6093,  1.8057,  1.9884,  2.2037,  2.3925,  2.5805,  2.7578,  2.9366,
     0.1950,  0.3519,  0.5272,  0.6973,  0.8732,  1.0656,  1.2112,  1.3959,
     1.6116,  1.7821,  1.9445,  2.1592,  2.3348,  2.5142,  2.7440,  2.9297,
     0.1388,  0.2557,  0.4120,  0.5727,  0.7354,  0.9196,  1.0985,  1.2805,
     1.4643,  1.6535,  1.8340,  2.0546,  2.2758,  2.4778,  2.6921,  2.9122,
     0.1823,  0.3336,  0.4957,  0.6771,  0.8563,  1.0137,  1.2299,  1.3849,
     1.5718,  1.7667,  1.9193,  2.1326,  2.3135,  2.5268,  2.7133,  2.8998,
     0.0790,  0.1901,  0.4083,  0.6456,  0.8463,  1.0285,  1.2297,  1.4181,
     1.6159,  1.8056,  1.9971,  2.1912,  2.3816,  2.5746,  2.7692,  2.9497,
     0.0049,  0.0116,  0.0045,  0.0039, -0.0010, -0.0122, -0.0205, -0.0034,
    -0.0140, -0.0041,  0.0191, -0.0322,  0.0002, -0.0124, -0.0269,  0.0059,
     0.0586,  0.0339, -0.0389, -0.0319, -0.0079, -0.0205, -0.0363, -0.0211,
     0.0241,  0.0595,  0.0469,  0.0283,  0.0176, -0.0183, -0.0173, -0.0004,
     0.0024,  0.0145,  0.0534,  0.0197, -0.0065, -0.0067,  0.0133,  0.0358,
    -0.0104, -0.0386, -0.0109, -0.0078,  0.0275,  0.0565,  0.0251, -0.0027,
    -0.0053,  0.0171,  0.0088,  0.0495,  0.0141,  0.0039, -0.0445, -0.0426,
    -0.0184, -0.0280, -0.0223,  0.0039, -0.0171, -0.0606, -0.0786, -0.0430,
     0.0544,  0.0595,  0.0320, -0.0012,  0.0108,  0.0185,  0.0066,  0.0408,
     0.0552, -0.0073, -0.0247, -0.0480, -0.0288,  0.0186,  0.0212, -0.0013,
     0.0403,  0.0598,  0.0690,  0.0516, -0.0298, -0.0177,  0.0278,  0.0168,
    -0.0106,  0.0251,  0.0386,  0.0331, -0.0052,  0.0133,  0.0291, -0.0158,
    -0.0329, -0.0367,  0.0287,  0.0462, -0.0176,  0.0049,  0.0242, -0.0034,
     0.0135,  0.0086, -0.0149,  0.0241,  0.0504,  0.0246, -0.0273, -0.0369,
    -0.0108, -0.0449, -0.0625, -0.0414, -0.0292, -0.0571, -0.0440, -0.0088,
     0.0098,  0.0009, -0.0004,  0.0007, -0.0314, -0.0208, -0.0138, -0.0277,
    -0.0044,  0.0522,  0.0315, -0.0270, -0.0277, -0.0256, -0.0103, -0.0201,
    -0.0287, -0.0279, -0.0182,  0.0472,  0.0613,  0.0450,  0.0413,  0.0333,
     0.0444,  0.0223,  0.0061,  0.0316,  0.0321,  0.0501,  0.0460,  0.0250,
     0.0227,  0.0235,  0.0099,  0.0185, -0.0347, -0.0684, -0.0189,  0.0242,
    -0.0190, -0.0273, -0.0012, -0.0253,  0.0293, -0.0231, -0.0219, -0.0010,
     0.0153,  0.0128, -0.0166, -0.0435, -0.0417, -0.0121, -0.0351, -0.0390,
     0.0077, -0.0278, -0.0355,  0.0092, -0.0063,  0.0005,  0.0216,  0.0461,
     0.0538,  0.0451,  0.0298, -0.0130,  0.0058,  0.0206,  0.0471,  0.0499,
     0.0280,  0.0086, -0.0007, -0.0317,  0.0259,  0.0176,  0.0043,  0.0212,
     0.0138,  0.0106,  0.0220, -0.0025,  0.0050,  0.0122, -0.0051, -0.0086,
    -0.0472, -0.0005,  0.0193,  0.0032,  0.0246,  0.0222,  0.0090, -0.0320,
    -0.0713, -0.0526, -0.0151, -0.0440, -0.0648, -0.0466, -0.0092,  0.0115,
    -0.0129,  0.0053, -0.0344, -0.0385,  0.0392,  0.0599,  0.0414,  0.0165,
    -0.0098, -0.0320, -0.0261, -0.0055, -0.0139, -0.0110,  0.0084,  0.0172,
    -0.0492, -0.0537, -0.0320, -0.0036,  0.0265,  0.0385,  0.0064, -0.0280,
    -0.0230,  0.0134,  0.0241,  0.0106,  0.0387,  0.0105,  0.0068,  0.0260,
     0.4940,  0.4911,  0.4849,  0.4820,  0.4837,  0.4839,  0.4824,  0.4799,
     0.4812,  0.4782,  0.4788,  0.4711,  0.4706,  0.4671,  0.4601,  0.4578,
     0.2954,  0.2121,  0.1859,  0.1958,  0.1474,  0.1086,  0.1351,  0.1362,
     0.1486,  0.1342,  0.1215,  0.1423,  0.1634,  0.1588,  0.1539,  0.1857,
};

const float ff_metasound_lsp16[] = {
     0.1813,  0.3911,  0.6301,  0.8012,  1.0057,  1.2041,  1.4271,  1.6943,
     1.9402,  2.1733,  2.3521,  2.4989,  2.5839,  2.6846,  2.7634,  2.8950,
     0.1311,  0.3183,  0.4659,  0.5601,  0.6658,  0.7828,  1.0065,  1.2717,
     1.5185,  1.7339,  1.9530,  2.2189,  2.3739,  2.4991,  2.6984,  2.9256,
     0.1627,  0.4519,  0.6323,  0.7012,  0.7848,  0.9801,  1.1810,  1.3222,
     1.5413,  1.8129,  1.9338,  2.0809,  2.3180,  2.5189,  2.7066,  2.9514,
     0.1475,  0.2447,  0.4240,  0.5669,  0.7872,  0.9838,  1.1823,  1.3814,
     1.5358,  1.6820,  1.8794,  2.1419,  2.4132,  2.6112,  2.7911,  2.9511,
     0.1224,  0.2876,  0.5013,  0.6985,  0.8902,  1.0901,  1.2835,  1.4768,
     1.6596,  1.8538,  2.0467,  2.2304,  2.4124,  2.5942,  2.7729,  2.9531,
     0.1741,  0.3034,  0.4677,  0.5879,  0.7258,  0.9648,  1.1417,  1.3220,
     1.5081,  1.7151,  1.9212,  2.1286,  2.3208,  2.4938,  2.6765,  2.8891,
     0.1657,  0.3174,  0.4907,  0.6559,  0.8295,  1.0254,  1.2071,  1.3880,
     1.5737,  1.7845,  1.9027,  2.1139,  2.3323,  2.5157,  2.7323,  2.9015,
     0.1592,  0.2758,  0.4417,  0.6315,  0.8257,  0.9873,  1.1277,  1.2830,
     1.4337,  1.6315,  1.8899,  2.1356,  2.3572,  2.5632,  2.7468,  2.9420,
     0.1524,  0.4325,  0.5931,  0.7036,  0.7696,  0.8923,  1.1739,  1.4773,
     1.6609,  1.7911,  1.9666,  2.1972,  2.3754,  2.5045,  2.6613,  2.8882,
     0.2130,  0.3013,  0.3721,  0.4257,  0.5079,  0.7015,  0.9815,  1.2554,
     1.4648,  1.6966,  1.9138,  2.1075,  2.3318,  2.5292,  2.7453,  2.9347,
     0.1142,  0.3748,  0.6205,  0.7642,  0.8121,  0.9022,  0.9843,  1.1558,
     1.4467,  1.7422,  1.9574,  2.1302,  2.3812,  2.5898,  2.7720,  2.9583,
     0.1255,  0.2339,  0.3570,  0.5323,  0.7458,  1.0003,  1.1729,  1.3567,
     1.5217,  1.6977,  1.8924,  2.0942,  2.3145,  2.5408,  2.7553,  2.9337,
     0.1316,  0.2289,  0.4327,  0.6663,  0.8509,  0.9994,  1.1697,  1.3804,
     1.5609,  1.6903,  1.8572,  2.1019,  2.3687,  2.5789,  2.7715,  2.9472,
     0.1502,  0.2546,  0.3883,  0.5333,  0.6976,  0.9163,  1.1071,  1.3364,
     1.5420,  1.7525,  1.8948,  2.0839,  2.2819,  2.4651,  2.6875,  2.8987,
     0.1593,  0.3014,  0.4573,  0.6354,  0.8157,  0.9805,  1.1783,  1.3747,
     1.5678,  1.7326,  1.9286,  2.1340,  2.3253,  2.5280,  2.7180,  2.9298,
     0.1811,  0.3167,  0.4655,  0.6507,  0.8198,  1.0075,  1.1892,  1.3743,
     1.5227,  1.7090,  1.8849,  2.0743,  2.2750,  2.4830,  2.6896,  2.8953,
     0.1846,  0.3577,  0.5315,  0.7290,  0.9176,  1.1016,  1.2654,  1.4525,
     1.6315,  1.8268,  2.0238,  2.1934,  2.3868,  2.5753,  2.7682,  2.9469,
     0.0876,  0.1439,  0.2048,  0.3654,  0.6281,  0.8853,  1.0907,  1.2992,
     1.5227,  1.7373,  1.9395,  2.1419,  2.3488,  2.5486,  2.7466,  2.9348,
     0.1391,  0.4170,  0.6561,  0.7953,  0.8734,  0.9986,  1.1870,  1.4520,
     1.6042,  1.7910,  2.0135,  2.1870,  2.3358,  2.5066,  2.7409,  2.9955,
     0.0804,  0.1355,  0.2599,  0.4998,  0.7408,  0.9474,  1.1276,  1.3428,
     1.5556,  1.7712,  1.9699,  2.1535,  2.3605,  2.5548,  2.7489,  2.9325,
     0.1304,  0.3087,  0.4979,  0.6584,  0.8414,  1.0329,  1.2244,  1.4189,
     1.6118,  1.8200,  1.9985,  2.1893,  2.3915,  2.5794,  2.7647,  2.9344,
     0.1895,  0.2849,  0.3705,  0.4126,  0.6265,  0.9207,  1.1774,  1.3762,
     1.5757,  1.7728,  1.9568,  2.1662,  2.3615,  2.5575,  2.7561,  2.9416,
     0.1800,  0.3078,  0.4805,  0.6796,  0.8503,  1.0046,  1.1703,  1.3269,
     1.4862,  1.6502,  1.8454,  2.0873,  2.3175,  2.5356,  2.7516,  2.9469,
     0.1950,  0.3233,  0.4568,  0.5940,  0.7589,  0.9978,  1.1701,  1.3383,
     1.5017,  1.6565,  1.8243,  2.0605,  2.2938,  2.5147,  2.7419,  2.9396,
     0.2531,  0.4391,  0.5790,  0.7170,  0.8998,  1.1430,  1.3577,  1.5326,
     1.6328,  1.7627,  1.9726,  2.1762,  2.3563,  2.5478,  2.7385,  2.9067,
     0.1805,  0.2788,  0.3591,  0.3881,  0.5441,  0.8055,  1.0766,  1.3165,
     1.5316,  1.7508,  1.9477,  2.1374,  2.3438,  2.5484,  2.7501,  2.9410,
     0.2044,  0.3671,  0.5396,  0.7042,  0.8582,  0.9831,  1.1261,  1.3194,
     1.4769,  1.6979,  1.8717,  2.0463,  2.2620,  2.4739,  2.7054,  2.9208,
     0.1048,  0.2175,  0.4206,  0.5923,  0.7483,  0.9400,  1.1356,  1.3799,
     1.5958,  1.7320,  1.8984,  2.1296,  2.3594,  2.5492,  2.7387,  2.9305,
     0.0842,  0.1729,  0.3951,  0.6447,  0.8688,  1.0605,  1.2472,  1.4330,
     1.6232,  1.8144,  2.0216,  2.1915,  2.3878,  2.5763,  2.7685,  2.9464,
     0.1461,  0.2593,  0.4105,  0.5677,  0.7328,  0.8919,  1.0484,  1.2302,
     1.4386,  1.6635,  1.8873,  2.1024,  2.3116,  2.5268,  2.7273,  2.9269,
     0.1503,  0.3108,  0.4756,  0.6731,  0.8600,  1.0233,  1.2115,  1.3971,
     1.5915,  1.7892,  1.9517,  2.1603,  2.3487,  2.5460,  2.7308,  2.8998,
     0.2163,  0.3669,  0.5125,  0.6709,  0.8143,  0.9930,  1.2095,  1.4205,
     1.6176,  1.7112,  1.8398,  2.0896,  2.3513,  2.5290,  2.6667,  2.8960,
     0.2133,  0.4382,  0.6287,  0.8702,  1.1088,  1.3749,  1.6062,  1.7446,
     1.8333,  1.9122,  1.9614,  2.0669,  2.1789,  2.3449,  2.6038,  2.8849,
     0.1598,  0.2719,  0.3877,  0.4815,  0.5926,  0.7795,  1.0449,  1.3045,
     1.5210,  1.7391,  1.9462,  2.1397,  2.3553,  2.5458,  2.7540,  2.9392,
     0.2918,  0.5607,  0.6801,  0.7404,  0.8285,  0.9431,  1.1579,  1.4080,
     1.6332,  1.8472,  1.9738,  2.0771,  2.2890,  2.5178,  2.7445,  2.9830,
     0.1664,  0.2842,  0.3965,  0.5463,  0.8162,  1.0346,  1.1849,  1.3446,
     1.5122,  1.7563,  1.9960,  2.2002,  2.3796,  2.5689,  2.7712,  2.9550,
     0.0911,  0.2397,  0.5052,  0.7868,  1.0299,  1.1311,  1.2244,  1.3333,
     1.4395,  1.6790,  1.9369,  2.1717,  2.3689,  2.5538,  2.7340,  2.9326,
     0.1647,  0.2931,  0.3836,  0.4978,  0.6255,  0.9243,  1.1339,  1.3001,
     1.5269,  1.8010,  1.9715,  2.1419,  2.3784,  2.5503,  2.6719,  2.8745,
     0.2440,  0.3802,  0.4756,  0.6613,  0.8627,  1.0292,  1.2291,  1.4060,
     1.5198,  1.7354,  1.9044,  2.1010,  2.3147,  2.4996,  2.7171,  2.9041,
     0.1590,  0.2876,  0.4572,  0.5996,  0.7713,  0.9490,  1.1205,  1.2815,
     1.4516,  1.6385,  1.8179,  2.0457,  2.2759,  2.4785,  2.6861,  2.9080,
     0.2297,  0.4309,  0.5712,  0.6717,  0.8138,  1.0463,  1.2492,  1.4560,
     1.6796,  1.8458,  1.9642,  2.1452,  2.3636,  2.5395,  2.7456,  2.9495,
     0.2975,  0.4678,  0.4996,  0.5809,  0.6279,  0.6884,  0.8606,  1.1386,
     1.4412,  1.6876,  1.8760,  2.0932,  2.3178,  2.5166,  2.7345,  2.9280,
     0.1278,  0.3737,  0.6004,  0.7069,  0.8147,  1.0180,  1.2581,  1.3812,
     1.4855,  1.7268,  1.9970,  2.1258,  2.2936,  2.5702,  2.7563,  2.8983,
     0.1314,  0.2508,  0.3999,  0.5680,  0.7424,  0.9367,  1.1286,  1.3175,
     1.5336,  1.7404,  1.9317,  2.1404,  2.3514,  2.5562,  2.7510,  2.9402,
     0.1043,  0.2367,  0.4293,  0.6376,  0.8160,  0.9836,  1.1779,  1.3850,
     1.5835,  1.7875,  1.9765,  2.1593,  2.3654,  2.5577,  2.7465,  2.9398,
     0.1529,  0.2515,  0.3454,  0.4374,  0.7011,  0.9015,  1.0744,  1.3532,
     1.5699,  1.7545,  2.0021,  2.1259,  2.2278,  2.4546,  2.7264,  2.9425,
     0.1429,  0.2808,  0.4395,  0.6334,  0.8069,  0.9705,  1.1520,  1.3250,
     1.5109,  1.7285,  1.9356,  2.1469,  2.3479,  2.5554,  2.7512,  2.9348,
     0.1625,  0.3022,  0.4756,  0.6315,  0.8032,  0.9924,  1.1596,  1.3204,
     1.4994,  1.6929,  1.8955,  2.1090,  2.3025,  2.5018,  2.6908,  2.8980,
     0.1692,  0.3427,  0.5228,  0.7756,  0.9688,  1.0950,  1.3056,  1.4360,
     1.5675,  1.8049,  1.9376,  2.1151,  2.3407,  2.5012,  2.7192,  2.9258,
     0.0474,  0.1251,  0.1939,  0.3841,  0.6501,  0.9231,  1.1153,  1.3240,
     1.5478,  1.7599,  1.9651,  2.1510,  2.3645,  2.5552,  2.7542,  2.9393,
     0.2196,  0.4656,  0.7492,  0.9922,  1.1678,  1.2489,  1.3112,  1.3657,
     1.4223,  1.5302,  1.7212,  1.9996,  2.2523,  2.4844,  2.7036,  2.9145,
     0.1128,  0.2368,  0.3704,  0.5476,  0.7723,  0.9968,  1.1930,  1.3992,
     1.6013,  1.7957,  1.9888,  2.1857,  2.3825,  2.5705,  2.7616,  2.9434,
     0.1341,  0.2768,  0.4510,  0.6359,  0.8332,  1.0335,  1.2004,  1.3952,
     1.5762,  1.7681,  1.9815,  2.1735,  2.3657,  2.5552,  2.7514,  2.9498,
     0.1247,  0.2559,  0.3516,  0.4726,  0.6861,  0.9483,  1.1852,  1.3858,
     1.5851,  1.7815,  1.9778,  2.1737,  2.3729,  2.5664,  2.7620,  2.9429,
     0.1988,  0.3320,  0.4777,  0.6737,  0.8425,  1.0265,  1.1694,  1.3655,
     1.5463,  1.7135,  1.9385,  2.1650,  2.3529,  2.5367,  2.7545,  2.9585,
     0.1376,  0.2620,  0.4273,  0.6169,  0.7755,  0.9441,  1.1169,  1.3157,
     1.5179,  1.7020,  1.8931,  2.1059,  2.3112,  2.5136,  2.7169,  2.9198,
     0.2112,  0.4385,  0.6091,  0.7618,  0.9553,  1.1543,  1.3445,  1.5396,
     1.7153,  1.9192,  2.1263,  2.3593,  2.5958,  2.8171,  2.9394,  3.0409,
     0.1347,  0.2099,  0.2646,  0.3453,  0.5266,  0.7869,  1.0513,  1.2795,
     1.4880,  1.7181,  1.9294,  2.1332,  2.3362,  2.5442,  2.7433,  2.9362,
     0.3141,  0.5935,  0.7517,  0.8313,  0.8568,  0.9570,  1.0250,  1.1275,
     1.3422,  1.6303,  1.8577,  2.0705,  2.2957,  2.5095,  2.7244,  2.9262,
     0.0962,  0.2116,  0.3961,  0.5641,  0.7122,  0.8883,  1.1023,  1.3481,
     1.5623,  1.7554,  1.9618,  2.1675,  2.3706,  2.5556,  2.7430,  2.9337,
     0.0898,  0.1510,  0.3060,  0.5820,  0.8221,  1.0388,  1.2261,  1.4289,
     1.6054,  1.8103,  1.9941,  2.1844,  2.3742,  2.5711,  2.7632,  2.9474,
     0.1326,  0.2316,  0.3761,  0.5177,  0.6782,  0.8761,  1.0952,  1.3175,
     1.5078,  1.7034,  1.9051,  2.1245,  2.3424,  2.5484,  2.7444,  2.9389,
     0.1740,  0.3293,  0.5174,  0.6824,  0.8394,  1.0372,  1.2046,  1.3723,
     1.5656,  1.7444,  1.9442,  2.1386,  2.3139,  2.4960,  2.7071,  2.9297,
     0.2304,  0.3775,  0.4865,  0.6182,  0.7842,  0.9208,  1.1151,  1.2843,
     1.4641,  1.6988,  1.9209,  2.1260,  2.3099,  2.5229,  2.7414,  2.9276,
     0.0094,  0.0261, -0.0037,  0.0041, -0.0092, -0.0044, -0.0232, -0.0073,
    -0.0047, -0.0021,  0.0250, -0.0580, -0.0140, -0.0342, -0.0586,  0.0020,
     0.0449,  0.0155, -0.0523, -0.0279,  0.0299, -0.0183, -0.0736, -0.0639,
    -0.0017,  0.0336,  0.0209,  0.0046,  0.0077, -0.0148, -0.0114, -0.0120,
     0.0115, -0.0050,  0.0445,  0.0048,  0.0188, -0.0137, -0.0080,  0.0239,
    -0.0184, -0.0524, -0.0195, -0.0126,  0.0284,  0.0632,  0.0141, -0.0093,
    -0.0096,  0.0196,  0.0230,  0.0379,  0.0308,  0.0237, -0.0224, -0.0600,
    -0.0755, -0.1074, -0.0988, -0.0606, -0.1038, -0.1552, -0.1480, -0.0672,
     0.0504,  0.0676,  0.0336, -0.0042,  0.0729,  0.1013,  0.0868,  0.0846,
     0.0954,  0.0515, -0.0066, -0.0851, -0.0485,  0.0294,  0.0395,  0.0087,
     0.0078,  0.0446,  0.0881,  0.0672, -0.0384, -0.0025,  0.0415,  0.0353,
     0.0080,  0.0052,  0.0190,  0.0182,  0.0069,  0.0168,  0.0374,  0.0037,
    -0.0292, -0.0429,  0.0302,  0.0681, -0.0233, -0.0238, -0.0003, -0.0043,
     0.0054, -0.0029, -0.0149,  0.0642,  0.0622,  0.0341, -0.0232, -0.0461,
    -0.0082, -0.0469, -0.0618, -0.0326, -0.0452, -0.0649, -0.0597, -0.0398,
    -0.0318, -0.0116,  0.0011,  0.0009, -0.0384, -0.0384, -0.0156, -0.0260,
    -0.0007,  0.0473,  0.0111, -0.0358, -0.0484, -0.0204, -0.0029, -0.0090,
    -0.0285, -0.0495, -0.0376,  0.0917,  0.1192,  0.1026,  0.0745,  0.0397,
     0.0463,  0.0253,  0.0025,  0.0465,  0.0100,  0.0488,  0.0416,  0.0223,
     0.0263,  0.0072, -0.0053,  0.0595,  0.0060, -0.0518, -0.0316, -0.0043,
    -0.0133, -0.0233, -0.0075, -0.0251,  0.0277, -0.0067, -0.0136, -0.0004,
     0.0235,  0.0112, -0.0182, -0.0324, -0.0210, -0.0035, -0.0395, -0.0384,
     0.0005, -0.0150, -0.0356,  0.0127, -0.0033, -0.0034,  0.0205,  0.0747,
     0.1138,  0.1015,  0.0995, -0.0161, -0.0045,  0.0129,  0.0472,  0.0575,
     0.0222,  0.0091,  0.0037, -0.0471,  0.0371,  0.0132,  0.0208,  0.0247,
     0.0117,  0.0164,  0.0225,  0.0124, -0.0023,  0.0088, -0.0046,  0.0047,
    -0.0393,  0.0018,  0.0148,  0.0020,  0.0044,  0.0165,  0.0229, -0.0208,
    -0.0477, -0.0310, -0.0164, -0.0390, -0.0764, -0.0525, -0.0094,  0.0075,
    -0.0102, -0.0045, -0.0504, -0.0709,  0.0822,  0.0710,  0.0426,  0.0014,
    -0.0371, -0.0400, -0.0157, -0.0155, -0.0173, -0.0138, -0.0015,  0.0134,
    -0.0418, -0.0682, -0.0256,  0.0050,  0.0360,  0.0354,  0.0074, -0.0396,
    -0.0235,  0.0284,  0.0494,  0.0153,  0.0448,  0.0025, -0.0061,  0.0252,
     0.1000,  0.2260,  0.2158,  0.2116,  0.2198,  0.2055,  0.2110,  0.1873,
     0.1907,  0.2071,  0.2164,  0.2009,  0.2059,  0.2124,  0.2141,  0.2093,
     0.0875,  0.0981,  0.1177,  0.1071,  0.1033,  0.1248,  0.1048,  0.1238,
     0.1166,  0.1008,  0.1062,  0.0992,  0.0994,  0.1067,  0.0999,  0.1187,
     0.0750,  0.0794,  0.0828,  0.0854,  0.0859,  0.0801,  0.0891,  0.0933,
     0.0969,  0.0920,  0.0915,  0.0862,  0.0868,  0.0891,  0.0842,  0.0824,
     0.0625,  0.0930,  0.0815,  0.0853,  0.0898,  0.0828,  0.0822,  0.0910,
     0.0873,  0.0906,  0.0856,  0.0840,  0.0774,  0.0785,  0.0684,  0.0711,
     0.3319,  0.4219,  0.4588,  0.4090,  0.4092,  0.4014,  0.3548,  0.3353,
     0.3708,  0.3352,  0.3720,  0.3538,  0.4084,  0.4289,  0.4060,  0.4210,
     0.0588,  0.0209, -0.0082, -0.0115, -0.0343, -0.0621, -0.0541, -0.0346,
    -0.0346, -0.0366, -0.0220, -0.0265, -0.0102,  0.0374,  0.0306,  0.0404,
     0.0306,  0.0090, -0.0054,  0.0333,  0.0047,  0.0238,  0.0141,  0.0165,
     0.0306,  0.0420,  0.0159,  0.0124,  0.0414,  0.0158, -0.0237,  0.0141,
     0.0765,  0.0057, -0.0260, -0.0426, -0.0395, -0.0126, -0.0579, -0.0417,
    -0.0429, -0.0615, -0.0893, -0.0618, -0.0384, -0.0134, -0.0232, -0.0238,
};

const float ff_metasound_lsp22[] = {
     0.0664,  0.1875,  0.4300,  0.6730,  0.8793,  1.0640,  1.2563,  1.4433,
     1.6394,  1.8176,  2.0029,  2.1921,  2.3796,  2.5671,  2.7595,  2.9536,
     0.2128,  0.4052,  0.5311,  0.6404,  0.7875,  0.8775,  1.0974,  1.3261,
     1.5563,  1.6790,  1.8339,  2.1195,  2.3226,  2.4609,  2.6440,  2.8947,
     0.2024,  0.3362,  0.4834,  0.6784,  0.9088,  1.0850,  1.2188,  1.4054,
     1.6102,  1.7767,  1.9679,  2.1436,  2.3445,  2.5467,  2.7429,  2.9320,
     0.1181,  0.2279,  0.4413,  0.6114,  0.7710,  0.9427,  1.1142,  1.2707,
     1.4892,  1.7416,  1.9526,  2.1466,  2.3629,  2.5445,  2.7293,  2.9205,
     0.1155,  0.2720,  0.4886,  0.6812,  0.8594,  1.0422,  1.2315,  1.4116,
     1.6137,  1.8020,  1.9758,  2.1743,  2.3602,  2.5568,  2.7472,  2.9374,
     0.1110,  0.3312,  0.4735,  0.5612,  0.7129,  0.8146,  1.0233,  1.3155,
     1.5765,  1.7746,  1.9574,  2.1416,  2.3220,  2.5384,  2.7334,  2.9318,
     0.1656,  0.3350,  0.4215,  0.5609,  0.6759,  0.8503,  1.1405,  1.4094,
     1.6057,  1.6860,  1.7639,  2.0031,  2.2680,  2.5076,  2.7263,  2.9368,
     0.1466,  0.3638,  0.4587,  0.5674,  0.7381,  0.8669,  0.9619,  1.1658,
     1.4667,  1.7440,  1.9335,  2.1018,  2.3022,  2.5281,  2.7359,  2.9261,
     0.1061,  0.2566,  0.4739,  0.6751,  0.8711,  1.0704,  1.2720,  1.4655,
     1.6605,  1.8494,  2.0290,  2.2197,  2.4008,  2.5912,  2.7772,  2.9513,
     0.1116,  0.2364,  0.3971,  0.6316,  0.8583,  1.0335,  1.1686,  1.3302,
     1.5612,  1.7877,  1.9829,  2.2052,  2.3596,  2.5460,  2.7341,  2.9290,
     0.2661,  0.4186,  0.5126,  0.6477,  0.8818,  1.1045,  1.2852,  1.4128,
     1.5851,  1.7593,  1.9399,  2.1757,  2.3684,  2.5136,  2.6927,  2.9064,
     0.1495,  0.2749,  0.4391,  0.6304,  0.8239,  1.0181,  1.1995,  1.3759,
     1.5669,  1.7722,  1.9671,  2.1635,  2.3586,  2.5528,  2.7445,  2.9311,
     0.0912,  0.1759,  0.3066,  0.5660,  0.8005,  0.9568,  1.1832,  1.4504,
     1.6259,  1.7948,  2.0113,  2.2002,  2.3654,  2.5583,  2.7929,  2.9735,
     0.1353,  0.2747,  0.4078,  0.5977,  0.7658,  0.9124,  1.1081,  1.3630,
     1.5875,  1.7847,  1.9323,  2.1181,  2.3321,  2.5046,  2.7183,  2.9225,
     0.1938,  0.4063,  0.4982,  0.6002,  0.7702,  0.9071,  1.1631,  1.3885,
     1.6043,  1.8118,  1.9306,  2.0893,  2.2724,  2.4609,  2.6283,  2.8802,
     0.1857,  0.3351,  0.4381,  0.6101,  0.7561,  0.8555,  1.0384,  1.3171,
     1.5667,  1.6904,  1.7552,  1.9689,  2.2597,  2.5260,  2.7272,  2.9337,
     0.1037,  0.2159,  0.4188,  0.6174,  0.8035,  1.0285,  1.2256,  1.4230,
     1.6400,  1.8322,  2.0144,  2.1988,  2.3810,  2.5682,  2.7613,  2.9438,
     0.1625,  0.2776,  0.4225,  0.6001,  0.7879,  0.9087,  1.0801,  1.2759,
     1.4899,  1.7448,  1.9911,  2.1770,  2.3723,  2.5777,  2.7971,  2.9444,
     0.2111,  0.3640,  0.5839,  0.7290,  0.8051,  1.0023,  1.2315,  1.4143,
     1.5878,  1.7755,  1.9804,  2.1498,  2.3312,  2.5350,  2.7613,  2.9472,
     0.1423,  0.2646,  0.4136,  0.6350,  0.8070,  0.9514,  1.1168,  1.3213,
     1.5776,  1.7721,  1.9404,  2.1545,  2.3385,  2.5137,  2.7396,  2.9553,
     0.1132,  0.2386,  0.4103,  0.5931,  0.7808,  0.9881,  1.1840,  1.3860,
     1.6021,  1.7990,  1.9922,  2.1885,  2.3852,  2.5717,  2.7640,  2.9510,
     0.1267,  0.2602,  0.3913,  0.5944,  0.7598,  0.9198,  1.0781,  1.2715,
     1.5299,  1.7573,  1.9308,  2.1346,  2.3267,  2.5419,  2.7466,  2.9320,
     0.2023,  0.3417,  0.4392,  0.6141,  0.7439,  0.8593,  1.1096,  1.3543,
     1.5185,  1.6553,  1.7862,  2.0341,  2.2718,  2.4834,  2.7103,  2.9466,
     0.1113,  0.2470,  0.3677,  0.5686,  0.7700,  0.9356,  1.0806,  1.2452,
     1.4830,  1.7344,  1.9268,  2.1404,  2.3371,  2.5169,  2.7329,  2.9012,
     0.1664,  0.3554,  0.5573,  0.7471,  0.9245,  1.0998,  1.2787,  1.4655,
     1.6654,  1.8346,  2.0179,  2.2159,  2.4096,  2.5946,  2.7790,  2.9530,
     0.1313,  0.2625,  0.4731,  0.6444,  0.8110,  0.9878,  1.1493,  1.3212,
     1.5719,  1.8138,  1.9861,  2.1943,  2.3714,  2.5578,  2.7346,  2.9296,
     0.1186,  0.3035,  0.5049,  0.6860,  0.8670,  0.9975,  1.1364,  1.3471,
     1.5695,  1.7412,  1.9346,  2.1506,  2.3413,  2.5531,  2.7794,  2.9627,
     0.1108,  0.2697,  0.4787,  0.6344,  0.7909,  0.9586,  1.1440,  1.3511,
     1.5686,  1.7601,  1.9246,  2.1241,  2.3293,  2.5390,  2.7315,  2.9333,
     0.0985,  0.2302,  0.3544,  0.5759,  0.7620,  0.9651,  1.1497,  1.3080,
     1.5500,  1.7845,  1.9518,  2.1734,  2.3565,  2.5665,  2.7605,  2.9102,
     0.1208,  0.2727,  0.4381,  0.5736,  0.7382,  0.8390,  1.0102,  1.2648,
     1.5100,  1.7440,  1.9619,  2.1430,  2.3307,  2.5159,  2.7264,  2.9211,
     0.1582,  0.2777,  0.4475,  0.6551,  0.8591,  1.0084,  1.1414,  1.3291,
     1.5902,  1.7826,  1.9543,  2.1659,  2.3233,  2.5044,  2.6935,  2.9199,
     0.1360,  0.2873,  0.4585,  0.6295,  0.7592,  0.9089,  1.0492,  1.2733,
     1.5391,  1.7768,  1.9372,  2.1329,  2.3168,  2.5015,  2.6857,  2.8837,
     0.0886,  0.1829,  0.3696,  0.6126,  0.8334,  1.0135,  1.2303,  1.4674,
     1.6743,  1.8564,  2.0530,  2.2370,  2.3960,  2.5787,  2.7756,  2.9377,
     0.2005,  0.3537,  0.4700,  0.6249,  0.7385,  0.9097,  1.1759,  1.3811,
     1.5314,  1.6705,  1.8546,  2.1229,  2.3292,  2.5251,  2.7951,  2.9646,
     0.1999,  0.3112,  0.4722,  0.7146,  0.8908,  1.0028,  1.1831,  1.3903,
     1.6125,  1.7514,  1.9083,  2.1248,  2.3271,  2.5339,  2.6945,  2.8918,
     0.1243,  0.2606,  0.4382,  0.5850,  0.7705,  0.9727,  1.1214,  1.3059,
     1.5218,  1.7406,  1.9137,  2.1353,  2.3354,  2.5299,  2.7287,  2.9068,
     0.1039,  0.2426,  0.4265,  0.6284,  0.8152,  0.9941,  1.2004,  1.4038,
     1.5912,  1.7763,  1.9650,  2.1598,  2.3474,  2.5488,  2.7419,  2.9322,
     0.1364,  0.2420,  0.3886,  0.5864,  0.7663,  0.8844,  1.0860,  1.3242,
     1.5518,  1.7893,  2.0004,  2.1562,  2.3619,  2.5516,  2.7687,  2.9181,
     0.1483,  0.2851,  0.4479,  0.6312,  0.7924,  0.9821,  1.1705,  1.3386,
     1.5375,  1.7226,  1.9053,  2.0991,  2.2898,  2.4953,  2.7000,  2.9146,
     0.2332,  0.4561,  0.5407,  0.6212,  0.7524,  0.8215,  0.9522,  1.1685,
     1.5216,  1.7132,  1.8291,  2.0647,  2.2811,  2.4857,  2.7071,  2.9281,
     0.1348,  0.3126,  0.5179,  0.7192,  0.9227,  1.1363,  1.3223,  1.4756,
     1.6509,  1.8191,  1.9991,  2.1976,  2.3877,  2.5768,  2.7590,  2.9386,
     0.1093,  0.2211,  0.4763,  0.6703,  0.8282,  0.9536,  1.1202,  1.3796,
     1.6043,  1.8031,  1.9832,  2.1604,  2.3578,  2.5856,  2.7650,  2.9291,
     0.1865,  0.3027,  0.4580,  0.6719,  0.8400,  1.0082,  1.1901,  1.3782,
     1.5448,  1.6885,  1.9477,  2.1381,  2.2797,  2.5113,  2.7465,  2.9414,
     0.1575,  0.3124,  0.4649,  0.6262,  0.8095,  0.9858,  1.1676,  1.3602,
     1.5646,  1.7582,  1.9550,  2.1671,  2.3628,  2.5734,  2.7670,  2.9519,
     0.1174,  0.2777,  0.4663,  0.6333,  0.8169,  1.0096,  1.1885,  1.3847,
     1.5803,  1.7571,  1.9380,  2.1398,  2.3414,  2.5407,  2.7360,  2.9375,
     0.1073,  0.2264,  0.4083,  0.5973,  0.7474,  0.9514,  1.1349,  1.3337,
     1.5433,  1.7348,  1.9380,  2.1436,  2.3441,  2.5438,  2.7457,  2.9383,
     0.1472,  0.2880,  0.4793,  0.6268,  0.8015,  1.0063,  1.1715,  1.3644,
     1.5525,  1.7410,  1.9258,  2.1227,  2.3214,  2.5149,  2.7148,  2.9196,
     0.1414,  0.2565,  0.4349,  0.6111,  0.7695,  0.9496,  1.1212,  1.3265,
     1.5218,  1.7209,  1.9015,  2.0887,  2.3158,  2.5077,  2.7233,  2.9421,
     0.1252,  0.2667,  0.4454,  0.6431,  0.8371,  1.0124,  1.2110,  1.4160,
     1.6240,  1.8242,  2.0047,  2.1974,  2.3902,  2.5778,  2.7637,  2.9481,
     0.1321,  0.2565,  0.3846,  0.5847,  0.7578,  0.9259,  1.0637,  1.2239,
     1.4690,  1.7346,  1.9750,  2.1882,  2.3712,  2.5509,  2.7280,  2.8885,
     0.1437,  0.2930,  0.4428,  0.6156,  0.8045,  0.9638,  1.1450,  1.3138,
     1.5144,  1.7355,  1.9469,  2.1534,  2.3414,  2.5452,  2.7353,  2.9334,
     0.1692,  0.2770,  0.3831,  0.6100,  0.7825,  0.9302,  1.0690,  1.2481,
     1.4615,  1.6799,  1.9165,  2.1739,  2.3435,  2.5349,  2.7520,  2.9163,
     0.1235,  0.2489,  0.4354,  0.6343,  0.8236,  1.0066,  1.1908,  1.3474,
     1.5656,  1.8275,  2.0620,  2.2548,  2.4135,  2.5913,  2.7639,  2.9334,
     0.1090,  0.1961,  0.3854,  0.5701,  0.7024,  0.8843,  1.1393,  1.3785,
     1.5940,  1.7797,  1.9442,  2.1740,  2.3853,  2.5773,  2.7727,  2.9406,
     0.1560,  0.3477,  0.5011,  0.6287,  0.7612,  0.9896,  1.1510,  1.3420,
     1.5435,  1.6816,  1.8731,  2.0651,  2.2613,  2.4999,  2.7027,  2.8971,
     0.1459,  0.2416,  0.3833,  0.5450,  0.7916,  0.9223,  1.0662,  1.1953,
     1.4029,  1.6616,  1.9320,  2.1459,  2.3386,  2.5081,  2.6799,  2.9195,
     0.1546,  0.3854,  0.6184,  0.8460,  1.0599,  1.2428,  1.3906,  1.5550,
     1.7388,  1.8945,  2.0757,  2.2386,  2.4014,  2.5705,  2.7574,  2.9400,
     0.1080,  0.2307,  0.4112,  0.6067,  0.7725,  0.9467,  1.1285,  1.3205,
     1.5348,  1.7609,  1.9937,  2.1878,  2.3583,  2.5515,  2.7199,  2.9049,
     0.1482,  0.3178,  0.4983,  0.6342,  0.7783,  0.9880,  1.2019,  1.3404,
     1.5223,  1.7296,  1.9211,  2.0943,  2.2928,  2.5008,  2.7136,  2.9224,
     0.1145,  0.2910,  0.4891,  0.6492,  0.8126,  0.9530,  1.1180,  1.3155,
     1.5054,  1.6893,  1.8899,  2.1188,  2.3389,  2.5512,  2.7313,  2.9224,
     0.0939,  0.1689,  0.3250,  0.5792,  0.7698,  0.9245,  1.1574,  1.3865,
     1.5959,  1.7977,  1.9821,  2.1528,  2.3326,  2.5540,  2.7553,  2.9179,
     0.1243,  0.2474,  0.3923,  0.6199,  0.7908,  0.9379,  1.1497,  1.3734,
     1.5582,  1.7420,  1.9539,  2.1385,  2.3240,  2.5277,  2.7311,  2.9178,
     0.1961,  0.3748,  0.5176,  0.6387,  0.8169,  1.0477,  1.2124,  1.3869,
     1.5604,  1.7225,  1.8770,  2.0837,  2.2960,  2.5103,  2.6945,  2.8862,
     0.1295,  0.2403,  0.4149,  0.6189,  0.7913,  0.9130,  1.0832,  1.2787,
     1.4860,  1.7112,  1.9502,  2.1348,  2.2776,  2.4982,  2.7431,  2.9522,
     0.0160,  0.0362,  0.0097,  0.0057, -0.0014, -0.0073, -0.0046, -0.0064,
    -0.0121,  0.0019,  0.0149, -0.0440, -0.0479, -0.0382, -0.0480, -0.0182,
     0.0170,  0.0114, -0.0298, -0.0175, -0.0033, -0.0354, -0.0510, -0.0025,
     0.0307,  0.0351,  0.0338,  0.0420,  0.0138, -0.0175, -0.0102,  0.0053,
     0.0084, -0.0003,  0.0412, -0.0027,  0.0145, -0.0039,  0.0083,  0.0400,
     0.0001, -0.0262,  0.0055, -0.0082,  0.0348,  0.0433,  0.0137, -0.0024,
    -0.0055,  0.0262,  0.0521,  0.0349,  0.0185,  0.0076, -0.0319, -0.0561,
    -0.0460, -0.0253, -0.0097,  0.0163,  0.0184, -0.0037, -0.0480, -0.0371,
     0.0628,  0.0665,  0.0296, -0.0057,  0.0253,  0.0227,  0.0350,  0.0692,
     0.0545,  0.0218,  0.0094, -0.0449, -0.0372,  0.0005,  0.0258,  0.0118,
     0.0285,  0.0760,  0.0822,  0.0527, -0.0299, -0.0049,  0.0170,  0.0195,
     0.0136,  0.0286,  0.0289,  0.0139,  0.0054,  0.0152,  0.0244,  0.0028,
    -0.0056, -0.0260,  0.0307,  0.0572, -0.0087,  0.0088,  0.0062,  0.0000,
     0.0125,  0.0000, -0.0292,  0.0820,  0.0872,  0.0646,  0.0346,  0.0076,
    -0.0022, -0.0253, -0.0567, -0.0188, -0.0336, -0.0673, -0.0549, -0.0166,
    -0.0259, -0.0140,  0.0040, -0.0029, -0.0430, -0.0531, -0.0253, -0.0019,
    -0.0071,  0.0393,  0.0072, -0.0327, -0.0236, -0.0235, -0.0177, -0.0186,
    -0.0280, -0.0201, -0.0077,  0.0383,  0.0418,  0.0321,  0.0294,  0.0169,
     0.0468,  0.0301,  0.0133,  0.0363,  0.0516,  0.0937,  0.1240,  0.1404,
     0.1325,  0.1178,  0.0999,  0.0251, -0.0037, -0.0495, -0.0703, -0.0219,
    -0.0261, -0.0304, -0.0204, -0.0372,  0.0355,  0.0131, -0.0093, -0.0099,
    -0.0069, -0.0034, -0.0065, -0.0208, -0.0231, -0.0117, -0.0211, -0.0243,
     0.0046, -0.0107, -0.0070,  0.0123,  0.0230,  0.0152,  0.0164,  0.0412,
     0.0619,  0.0858,  0.0862, -0.0056,  0.0125,  0.0182,  0.0347,  0.0388,
     0.0456,  0.0407, -0.0249, -0.0460,  0.0206,  0.0299,  0.0253,  0.0207,
     0.0177,  0.0238,  0.0253,  0.0030,  0.0042,  0.0020, -0.0081, -0.0136,
    -0.0290, -0.0042,  0.0122,  0.0051,  0.0107,  0.0228,  0.0211, -0.0068,
    -0.0436, -0.0299, -0.0078, -0.0779, -0.1157, -0.0679,  0.0172,  0.0150,
    -0.0051,  0.0081, -0.0512, -0.0616,  0.0576,  0.0799,  0.0803,  0.0336,
     0.0001, -0.0298, -0.0747, -0.0115, -0.0101, -0.0170, -0.0050,  0.0174,
    -0.0290, -0.0601, -0.0150,  0.0121,  0.0165,  0.0230,  0.0028, -0.0317,
    -0.0165,  0.0356,  0.0451,  0.0120,  0.0321,  0.0084, -0.0058,  0.0122,
     0.1935,  0.1802,  0.2195,  0.2410,  0.2201,  0.1915,  0.1840,  0.1935,
     0.2213,  0.2079,  0.1858,  0.1974,  0.2239,  0.2173,  0.1840,  0.2120,
     0.4912,  0.4777,  0.4607,  0.4395,  0.4426,  0.4388,  0.4416,  0.4345,
     0.4239,  0.4331,  0.4522,  0.4423,  0.4475,  0.4387,  0.4525,  0.4446,
};

const float ff_metasound_lsp44[] = {
     0.0927,  0.2291,  0.4059,  0.5779,  0.7288,  0.8821,  1.0377,  1.1915,
     1.3433,  1.4931,  1.6475,  1.7989,  1.9381,  2.0858,  2.2321,  2.3765,
     2.5187,  2.6530,  2.7895,  2.9354,  0.0944,  0.1974,  0.3046,  0.4714,
     0.6116,  0.7829,  0.9027,  1.0375,  1.1869,  1.3488,  1.5036,  1.6781,
     1.8276,  1.9983,  2.1449,  2.3089,  2.4534,  2.6113,  2.7553,  2.9062,
     0.1168,  0.2843,  0.4907,  0.6706,  0.8100,  0.9417,  1.0753,  1.2014,
     1.3151,  1.4496,  1.5832,  1.7379,  1.8642,  2.0230,  2.1681,  2.3250,
     2.4676,  2.6242,  2.7602,  2.9066,  0.1353,  0.2335,  0.3370,  0.4380,
     0.5819,  0.7353,  0.8671,  1.0160,  1.1435,  1.2977,  1.4860,  1.6739,
     1.8412,  2.0028,  2.1537,  2.3124,  2.4741,  2.6272,  2.7862,  2.9536,
     0.1003,  0.2226,  0.3584,  0.4971,  0.6291,  0.7710,  0.9157,  1.0669,
     1.2143,  1.3624,  1.5104,  1.6681,  1.8164,  1.9823,  2.1394,  2.3082,
     2.4677,  2.6306,  2.7909,  2.9382,  0.1056,  0.2027,  0.2956,  0.4005,
     0.5215,  0.6708,  0.8545,  1.0557,  1.2344,  1.4023,  1.5676,  1.7278,
     1.8808,  2.0381,  2.1846,  2.3376,  2.4887,  2.6377,  2.7878,  2.9504,
     0.1015,  0.2462,  0.4122,  0.5783,  0.7233,  0.8833,  1.0377,  1.1903,
     1.3341,  1.4727,  1.6138,  1.7582,  1.8912,  2.0370,  2.1701,  2.3125,
     2.4500,  2.6006,  2.7507,  2.9166,  0.1787,  0.2418,  0.3265,  0.5379,
     0.6584,  0.7681,  0.9545,  1.1050,  1.2125,  1.3528,  1.4763,  1.6705,
     1.8136,  1.9594,  2.0936,  2.2724,  2.4394,  2.5919,  2.7037,  2.8747,
     0.0859,  0.1600,  0.2980,  0.4933,  0.6696,  0.8285,  0.9958,  1.1545,
     1.3107,  1.4591,  1.6127,  1.7652,  1.9143,  2.0680,  2.2171,  2.3643,
     2.5141,  2.6611,  2.8143,  2.9691,  0.0910,  0.2110,  0.3364,  0.4718,
     0.5856,  0.7298,  0.8910,  1.0514,  1.1988,  1.3572,  1.5178,  1.6861,
     1.8399,  2.0099,  2.1639,  2.3225,  2.4774,  2.6321,  2.7863,  2.9412,
     0.1904,  0.2874,  0.3681,  0.4981,  0.6248,  0.7880,  0.9121,  1.0750,
     1.2185,  1.3809,  1.5296,  1.7007,  1.8592,  2.0470,  2.1913,  2.3250,
     2.4519,  2.5984,  2.7408,  2.9023,  0.0917,  0.2067,  0.3246,  0.4961,
     0.6310,  0.8024,  0.9438,  1.1008,  1.2362,  1.3892,  1.5407,  1.7033,
     1.8427,  2.0061,  2.1498,  2.3117,  2.4550,  2.6053,  2.7462,  2.9029,
     0.0989,  0.2193,  0.3756,  0.5410,  0.6929,  0.8368,  0.9801,  1.1250,
     1.2677,  1.4184,  1.5677,  1.7292,  1.8770,  2.0311,  2.1803,  2.3306,
     2.4836,  2.6339,  2.7943,  2.9549,  0.0861,  0.1943,  0.3057,  0.4867,
     0.6194,  0.7592,  0.9184,  1.1052,  1.2486,  1.4064,  1.5609,  1.7273,
     1.8703,  2.0291,  2.1686,  2.3225,  2.4628,  2.6115,  2.7471,  2.9005,
     0.0932,  0.2110,  0.3737,  0.5479,  0.7120,  0.8570,  0.9975,  1.1364,
     1.2772,  1.4220,  1.5612,  1.7089,  1.8410,  1.9827,  2.1263,  2.2859,
     2.4459,  2.6172,  2.7788,  2.9395,  0.1193,  0.2341,  0.3523,  0.5029,
     0.6437,  0.7803,  0.9367,  1.1007,  1.2392,  1.3869,  1.5425,  1.7168,
     1.8709,  2.0248,  2.1584,  2.2949,  2.4308,  2.5823,  2.7235,  2.9034,
     0.0834,  0.1988,  0.3557,  0.5261,  0.6767,  0.8427,  1.0029,  1.1683,
     1.3138,  1.4527,  1.6046,  1.7583,  1.9011,  2.0517,  2.1928,  2.3397,
     2.4839,  2.6291,  2.7771,  2.9329,  0.0938,  0.1967,  0.3213,  0.4675,
     0.6068,  0.7664,  0.9418,  1.1120,  1.2535,  1.3932,  1.5243,  1.6801,
     1.8346,  1.9931,  2.1376,  2.3035,  2.4636,  2.6244,  2.7829,  2.9371,
     0.1017,  0.2552,  0.4327,  0.6017,  0.7467,  0.8797,  1.0097,  1.1442,
     1.2628,  1.4049,  1.5541,  1.7090,  1.8461,  1.9982,  2.1486,  2.3029,
     2.4513,  2.6075,  2.7594,  2.9209,  0.1031,  0.2295,  0.3747,  0.5122,
     0.6596,  0.7935,  0.9345,  1.1050,  1.2384,  1.3543,  1.4739,  1.6136,
     1.7447,  1.8914,  2.0434,  2.1916,  2.3557,  2.5396,  2.7419,  2.9401,
     0.1007,  0.2374,  0.3715,  0.5173,  0.6465,  0.8069,  0.9553,  1.1145,
     1.2594,  1.4143,  1.5617,  1.7166,  1.8457,  2.0012,  2.1462,  2.2864,
     2.4258,  2.5910,  2.7372,  2.9018,  0.0808,  0.1726,  0.2849,  0.4592,
     0.6118,  0.7853,  0.9588,  1.1256,  1.2751,  1.4392,  1.5898,  1.7514,
     1.8977,  2.0554,  2.1937,  2.3430,  2.4831,  2.6249,  2.7601,  2.9155,
     0.1669,  0.2574,  0.3694,  0.5569,  0.6773,  0.8061,  1.0160,  1.1667,
     1.2791,  1.4041,  1.5452,  1.7207,  1.8524,  2.0038,  2.1414,  2.3338,
     2.4747,  2.6157,  2.7303,  2.8848,  0.1598,  0.2521,  0.3416,  0.5149,
     0.6703,  0.7941,  0.9408,  1.1164,  1.2017,  1.3293,  1.4908,  1.6783,
     1.8438,  1.9927,  2.1149,  2.2698,  2.4420,  2.6193,  2.7583,  2.9103,
     0.0902,  0.1978,  0.3265,  0.4578,  0.5878,  0.7439,  0.9110,  1.0906,
     1.2556,  1.4125,  1.5688,  1.7295,  1.8829,  2.0472,  2.2058,  2.3537,
     2.5075,  2.6548,  2.8058,  2.9538,  0.0818,  0.1695,  0.2794,  0.4470,
     0.6069,  0.7641,  0.9313,  1.0946,  1.2411,  1.4072,  1.5640,  1.7186,
     1.8651,  2.0254,  2.1726,  2.3286,  2.4784,  2.6287,  2.7750,  2.9339,
     0.1980,  0.3134,  0.4099,  0.4975,  0.6491,  0.8376,  0.9441,  1.0298,
     1.1795,  1.3866,  1.5784,  1.7209,  1.8137,  1.9271,  2.0863,  2.2930,
     2.4696,  2.6184,  2.7587,  2.9251,  0.1338,  0.2341,  0.3566,  0.4797,
     0.6129,  0.7580,  0.9093,  1.0491,  1.1911,  1.3313,  1.4841,  1.6503,
     1.8035,  1.9685,  2.1128,  2.2694,  2.4093,  2.5728,  2.7206,  2.8994,
     0.0937,  0.2034,  0.3447,  0.5032,  0.6370,  0.7993,  0.9674,  1.1323,
     1.2830,  1.4199,  1.5492,  1.7010,  1.8513,  2.0087,  2.1550,  2.3115,
     2.4643,  2.6237,  2.7812,  2.9392,  0.1085,  0.2152,  0.3126,  0.4569,
     0.5718,  0.7213,  0.8837,  1.0604,  1.2053,  1.3755,  1.5397,  1.7001,
     1.8409,  2.0039,  2.1498,  2.3080,  2.4535,  2.6063,  2.7505,  2.9110,
     0.0562,  0.2066,  0.4034,  0.5490,  0.6682,  0.7924,  0.9495,  1.0800,
     1.1869,  1.3156,  1.4834,  1.6619,  1.8404,  2.0199,  2.1509,  2.2755,
     2.4072,  2.5580,  2.6993,  2.8913,  0.0939,  0.2303,  0.3742,  0.5260,
     0.6662,  0.8294,  0.9769,  1.1315,  1.2792,  1.4153,  1.5436,  1.6701,
     1.8215,  1.9920,  2.1310,  2.3005,  2.4534,  2.5786,  2.7204,  2.9068,
     0.1005,  0.2442,  0.3898,  0.5398,  0.6958,  0.8474,  1.0008,  1.1556,
     1.3020,  1.4456,  1.5954,  1.7470,  1.8922,  2.0500,  2.2019,  2.3492,
     2.4963,  2.6412,  2.7890,  2.9423,  0.1022,  0.2031,  0.3213,  0.4402,
     0.5637,  0.7117,  0.8673,  1.0242,  1.1727,  1.3206,  1.4846,  1.6465,
     1.8015,  1.9655,  2.1233,  2.2873,  2.4464,  2.6074,  2.7685,  2.9409,
     0.1985,  0.3497,  0.4622,  0.5982,  0.7489,  0.8752,  0.9925,  1.1679,
     1.3288,  1.4606,  1.5820,  1.7492,  1.8922,  2.0511,  2.1780,  2.3373,
     2.4760,  2.6233,  2.7466,  2.8978,  0.1284,  0.2433,  0.3630,  0.4852,
     0.6117,  0.7460,  0.8904,  1.0360,  1.1738,  1.3142,  1.4696,  1.6185,
     1.7719,  1.9318,  2.0961,  2.2697,  2.4408,  2.6046,  2.7681,  2.9451,
     0.1042,  0.2286,  0.3598,  0.5064,  0.6438,  0.7899,  0.9350,  1.0891,
     1.2323,  1.3807,  1.5225,  1.6747,  1.8153,  1.9669,  2.1145,  2.2832,
     2.4430,  2.6085,  2.7748,  2.9346,  0.0780,  0.1724,  0.2440,  0.3489,
     0.5280,  0.7426,  0.9272,  1.0914,  1.2562,  1.4188,  1.5804,  1.7376,
     1.8909,  2.0473,  2.1946,  2.3457,  2.4950,  2.6424,  2.7926,  2.9549,
     0.1103,  0.2608,  0.4087,  0.5538,  0.6923,  0.8418,  0.9940,  1.1507,
     1.2919,  1.4406,  1.5802,  1.7262,  1.8638,  2.0085,  2.1572,  2.2975,
     2.4329,  2.5866,  2.7380,  2.9107,  0.1297,  0.2532,  0.4003,  0.5329,
     0.6733,  0.7950,  0.9557,  1.0859,  1.2235,  1.3538,  1.5037,  1.6389,
     1.7964,  1.9285,  2.0898,  2.2541,  2.4231,  2.5711,  2.6875,  2.8947,
     0.0871,  0.1968,  0.3425,  0.4949,  0.6424,  0.7959,  0.9534,  1.1132,
     1.2656,  1.4229,  1.5785,  1.7271,  1.8729,  2.0355,  2.1998,  2.3562,
     2.5151,  2.6663,  2.8145,  2.9534,  0.1038,  0.2204,  0.3248,  0.4566,
     0.5947,  0.7443,  0.8811,  1.0379,  1.2031,  1.3772,  1.5430,  1.7092,
     1.8625,  2.0322,  2.1904,  2.3417,  2.4960,  2.6458,  2.7979,  2.9485,
     0.1329,  0.2763,  0.3943,  0.5147,  0.6512,  0.8071,  0.9410,  1.0879,
     1.2298,  1.3850,  1.5282,  1.6674,  1.8137,  1.9993,  2.1344,  2.2749,
     2.4257,  2.5863,  2.7410,  2.9184,  0.1052,  0.2142,  0.3584,  0.5033,
     0.6387,  0.7804,  0.9320,  1.0780,  1.2172,  1.3764,  1.5421,  1.6887,
     1.8246,  1.9833,  2.1245,  2.2797,  2.4237,  2.5779,  2.7257,  2.9097,
     0.1092,  0.2676,  0.4071,  0.5355,  0.6661,  0.8142,  0.9621,  1.1173,
     1.2628,  1.4185,  1.5696,  1.7220,  1.8595,  2.0178,  2.1720,  2.3221,
     2.4718,  2.6259,  2.7775,  2.9334,  0.0929,  0.2017,  0.3073,  0.4570,
     0.5775,  0.7635,  0.9299,  1.0832,  1.2334,  1.3935,  1.5420,  1.7112,
     1.8601,  2.0309,  2.1735,  2.3230,  2.4543,  2.6034,  2.7418,  2.8988,
     0.0775,  0.2005,  0.3490,  0.5200,  0.6747,  0.8383,  0.9885,  1.1738,
     1.3141,  1.4236,  1.5892,  1.7402,  1.8474,  2.0210,  2.1593,  2.2730,
     2.4235,  2.5604,  2.7128,  2.9005,  0.1104,  0.2292,  0.3353,  0.4732,
     0.6152,  0.7675,  0.9164,  1.0907,  1.2594,  1.4064,  1.5218,  1.6426,
     1.8018,  1.9937,  2.1362,  2.2961,  2.4523,  2.6083,  2.7613,  2.9202,
     0.0826,  0.2000,  0.3384,  0.5144,  0.6694,  0.8377,  0.9870,  1.1461,
     1.2950,  1.4495,  1.5872,  1.7387,  1.8793,  2.0329,  2.1723,  2.3114,
     2.4415,  2.5908,  2.7354,  2.9028,  0.1063,  0.2268,  0.3442,  0.4735,
     0.6116,  0.7507,  0.9028,  1.0768,  1.2426,  1.4052,  1.5566,  1.7015,
     1.8243,  1.9742,  2.1276,  2.2824,  2.4262,  2.5953,  2.7627,  2.9290,
     0.1150,  0.2814,  0.4543,  0.6095,  0.7373,  0.8592,  0.9908,  1.1108,
     1.2339,  1.3590,  1.4864,  1.6168,  1.7392,  1.8752,  2.0212,  2.1688,
     2.3128,  2.4869,  2.7019,  2.9239,  0.0948,  0.2074,  0.3433,  0.4943,
     0.6346,  0.7645,  0.8809,  1.0610,  1.2307,  1.3487,  1.4655,  1.6186,
     1.7534,  1.8859,  2.0486,  2.2200,  2.3835,  2.5581,  2.7565,  2.9502,
     0.1062,  0.2239,  0.3683,  0.5197,  0.6704,  0.8184,  0.9642,  1.1127,
     1.2556,  1.3976,  1.5405,  1.6940,  1.8375,  1.9888,  2.1377,  2.2980,
     2.4555,  2.6184,  2.7849,  2.9452,  0.0888,  0.2005,  0.2847,  0.4322,
     0.5763,  0.7577,  0.9262,  1.1095,  1.2719,  1.4331,  1.5843,  1.7452,
     1.8845,  2.0385,  2.1805,  2.3345,  2.4750,  2.6217,  2.7555,  2.9013,
     0.1713,  0.2617,  0.3868,  0.5859,  0.7073,  0.8535,  1.0593,  1.1778,
     1.3109,  1.4508,  1.5910,  1.7463,  1.8911,  2.0651,  2.2035,  2.3355,
     2.4947,  2.6440,  2.7424,  2.8943,  0.1346,  0.2549,  0.4089,  0.5488,
     0.6949,  0.8394,  0.9810,  1.1145,  1.2528,  1.4044,  1.5423,  1.6872,
     1.8274,  1.9726,  2.1403,  2.2809,  2.4128,  2.5564,  2.6887,  2.8895,
     0.0776,  0.1621,  0.2553,  0.4191,  0.5988,  0.7921,  0.9651,  1.1350,
     1.2930,  1.4475,  1.6011,  1.7585,  1.9068,  2.0638,  2.2102,  2.3594,
     2.5096,  2.6581,  2.8099,  2.9654,  0.0864,  0.1778,  0.2854,  0.4235,
     0.5568,  0.7220,  0.8963,  1.0609,  1.2217,  1.3830,  1.5422,  1.7018,
     1.8551,  2.0206,  2.1783,  2.3328,  2.4869,  2.6366,  2.7923,  2.9539,
     0.1144,  0.2576,  0.4186,  0.5594,  0.6875,  0.8221,  0.9598,  1.0944,
     1.2273,  1.3713,  1.5152,  1.6628,  1.8070,  1.9525,  2.0965,  2.2535,
     2.4132,  2.5725,  2.7250,  2.9150,  0.1079,  0.2221,  0.3334,  0.4845,
     0.6083,  0.7516,  0.9018,  1.0594,  1.2060,  1.3673,  1.5212,  1.6880,
     1.8208,  1.9831,  2.1269,  2.2909,  2.4366,  2.6027,  2.7339,  2.8924,
     0.0994,  0.2233,  0.3634,  0.5145,  0.6568,  0.8131,  0.9746,  1.1296,
     1.2666,  1.4116,  1.5748,  1.7264,  1.8649,  2.0217,  2.1716,  2.3293,
     2.4900,  2.6455,  2.7818,  2.9362,  0.1120,  0.2079,  0.3128,  0.4124,
     0.5291,  0.6816,  0.8478,  1.0150,  1.1772,  1.3456,  1.5208,  1.6882,
     1.8458,  2.0078,  2.1627,  2.3198,  2.4733,  2.6251,  2.7796,  2.9489,
     0.0853,  0.2030,  0.3669,  0.5326,  0.6678,  0.8086,  0.9526,  1.1142,
     1.2551,  1.4158,  1.5694,  1.7073,  1.8431,  1.9686,  2.1153,  2.2376,
     2.3686,  2.5591,  2.7320,  2.9104,  0.0905,  0.2166,  0.3539,  0.5201,
     0.6700,  0.8346,  0.9883,  1.1457,  1.2714,  1.3845,  1.5172,  1.6688,
     1.8008,  1.9535,  2.1019,  2.2708,  2.4135,  2.5974,  2.7486,  2.9033,
     0.0084,  0.0374,  0.0164, -0.0153,  0.0288,  0.0107, -0.0255, -0.0242,
     0.0000, -0.0055, -0.0081, -0.0075, -0.0022, -0.0052, -0.0069, -0.0017,
     0.0003,  0.0091,  0.0028, -0.0027,  0.0085,  0.0043, -0.0235, -0.0411,
     0.0202,  0.0359,  0.0376,  0.0321,  0.0306, -0.0358, -0.0276, -0.0090,
     0.0032,  0.0048,  0.0309,  0.0332,  0.0284,  0.0237,  0.0051, -0.0101,
    -0.0233, -0.0428, -0.0585, -0.0387,  0.0039,  0.0081,  0.0029, -0.0017,
    -0.0006, -0.0068,  0.0044,  0.0182,  0.0376,  0.0387, -0.0334, -0.0269,
    -0.0182, -0.0069, -0.0026,  0.0035, -0.0049, -0.0212, -0.0408, -0.0245,
     0.0186,  0.0189,  0.0153,  0.0120,  0.0157,  0.0055, -0.0046,  0.0179,
     0.0284, -0.0032, -0.0261, -0.0205, -0.0039,  0.0174,  0.0299,  0.0207,
     0.0012, -0.0056,  0.0010,  0.0141, -0.0119,  0.0190,  0.0315,  0.0033,
    -0.0128,  0.0300,  0.0328,  0.0308,  0.0353,  0.0266,  0.0066, -0.0328,
    -0.0273,  0.0054,  0.0145,  0.0175,  0.0015, -0.0171,  0.0062, -0.0164,
     0.0045, -0.0071,  0.0025,  0.0278,  0.0283,  0.0117, -0.0026, -0.0285,
    -0.0408, -0.0366, -0.0059, -0.0208, -0.0354, -0.0334, -0.0263, -0.0064,
     0.0072, -0.0006, -0.0235, -0.0037, -0.0307, -0.0294, -0.0163, -0.0197,
    -0.0235,  0.0192,  0.0013, -0.0219, -0.0123, -0.0004, -0.0081, -0.0096,
    -0.0123, -0.0101,  0.0021,  0.0151,  0.0106,  0.0151,  0.0292,  0.0033,
     0.0283,  0.0124,  0.0058, -0.0017, -0.0038,  0.0152,  0.0141,  0.0132,
     0.0178,  0.0157,  0.0073,  0.0176,  0.0141,  0.0097, -0.0092, -0.0163,
    -0.0230, -0.0134, -0.0099, -0.0147,  0.0040, -0.0183, -0.0175, -0.0080,
    -0.0083, -0.0290, -0.0417, -0.0398, -0.0269, -0.0199, -0.0143, -0.0053,
    -0.0099, -0.0054, -0.0199, -0.0219, -0.0170,  0.0107,  0.0194,  0.0035,
     0.0437,  0.0406,  0.0215,  0.0120,  0.0053, -0.0028,  0.0238,  0.0337,
     0.0217,  0.0011,  0.0227,  0.0244,  0.0327,  0.0378,  0.0437,  0.0356,
    -0.0033,  0.0113,  0.0407,  0.0334, -0.0125, -0.0003, -0.0141, -0.0273,
    -0.0137, -0.0079, -0.0145, -0.0071,  0.0114,  0.0181,  0.0150,  0.0085,
    -0.0077, -0.0038, -0.0219, -0.0263, -0.0187, -0.0233,  0.0133,  0.0265,
    -0.0156, -0.0091, -0.0110, -0.0016,  0.0143,  0.0177,  0.0240,  0.0082,
    -0.0143, -0.0257, -0.0014,  0.0002,  0.0082,  0.0180,  0.0325,  0.0340,
    -0.0153, -0.0389, -0.0240,  0.0082,  0.0140,  0.0046, -0.0138, -0.0378,
    -0.0366,  0.0297,  0.0252,  0.0078,  0.0063,  0.0006,  0.0044,  0.0074,
     0.0094,  0.0113,  0.0105,  0.0137,  0.0438,  0.0262, -0.0078, -0.0185,
    -0.0215, -0.0407, -0.0435, -0.0208, -0.0004, -0.0144, -0.0205, -0.0248,
    -0.0159, -0.0069, -0.0153,  0.0132,  0.0355,  0.0298,  0.0120,  0.0072,
     0.0236,  0.0526,  0.0479,  0.0233, -0.0133, -0.0283, -0.0468, -0.0549,
    -0.0370,  0.0032,  0.0056,  0.0023,  0.0050,  0.0024,  0.0279,  0.0116,
    -0.0045, -0.0012,  0.0107,  0.0190,  0.0253,  0.0191,  0.0043,  0.0193,
    -0.0348, -0.0246,  0.0123,  0.0210,  0.0135, -0.0096, -0.0109, -0.0076,
    -0.0156, -0.0290,  0.0160,  0.0194,  0.0219,  0.0259,  0.0250,  0.0195,
     0.4948,  0.4961,  0.4940,  0.4878,  0.4849,  0.4727,  0.4571,  0.4551,
     0.4534,  0.4468,  0.4412,  0.4354,  0.4298,  0.4272,  0.4498,  0.4506,
     0.4560,  0.4592,  0.4758,  0.4941,  0.2476,  0.1771,  0.1974,  0.1881,
     0.1667,  0.1826,  0.2067,  0.2031,  0.1734,  0.1534,  0.1415,  0.1761,
     0.1897,  0.1772,  0.1651,  0.1247,  0.1041,  0.1231,  0.1809,  0.2234,
};

#endif /* AVCODEC_METASOUND_TWINVQ_DATA_H */
