.TH amt-howto 7 "(c) 2007 Gerd Hoffmann"
.SH NAME
amt-howto - Intel AMT with linux mini howto
.SH DESCRIPTION

.SS What is AMT and why I should care?
AMT stands for "Active Management Technology".  It provides some
remote management facilities.  They are handled by the hardware and
firmware, thus they work independant from the operation system.
Means: It works before Linux bootet up to the point where it activated
the network interface.  It works even when your most recent test
kernel deadlocked the machine.  Which makes it quite useful for
development machines ...
.P
Intel AMT is part of the vPro Platform.  Recent intel-chipset based
business machines should have it.  My fairly new Intel SDV machine has
it too.

.SS Documentation
Look here for documentation beyond this mini howto:
.br
http://www.intel.com/technology/platform-technology/intel-amt/
.br
Most useful to get started: "Intel AMT Deployment and Reference Guide"

.SS Very short AMT enabling instructions.
.TP
Enter BIOS Setup.
* Enable AMT
.TP
Enter ME (Management Extention) Setup.  Ctrl-P hotkey works for me.
* Login, factory default password is "admin".
.br
* Change password.  Trivial ones don't work, must include upper-
and lowercase letters, digits, special characters.
.br
* Enable AMT Managment.
.TP
Reboot, Enter ME Setup again with AMT enabled.
* Configure AMT (hostname, network config, ...)
.br
* Use SMB (Small Business) management mode.  The other one
(Enterprise) requires Active Directory Service Infrastructure,
you don't want that, at least not for your first steps ...

.SS Testing AMT
Take your browser, point it to http://machine:16992/.  If you
configured AMT to use DHCP (which is the default) the OS and the
management stack share the same IP address.
.P
You must do that from a remote host as the NIC intercepts network
packets for AMT, thus it doesn't work from the local machine as the
packets never pass the NIC then.  If everything is fine you'll see a
greeting page with a button for login.
.P
You can login now, using "admin" as username and the password
configured during setup.  You'll see some pages with informations
about the machine.  You can also change AMT settings here.

.SS Control Machine
You might have noticed already while browing the pages: There is a
"Remote Control" page.  You can remotely reset and powercycle the
machine there, thus recover the machine after booting a b0rken kernel,
without having someone walk over to the machine and hit the reset
button.

.SS Serial-over-LAN (SOL) console
AMT also provides a virtual serial port which can be accessed via
network.  That gives you a serial console without a serial cable to
another machine.
.P
If you have activated AMT and SOL the linux kernel should see an
additional serial port, like this on my machine:
.P
.nf
  [root@xeni ~]# dmesg | grep ttyS2
  0000:00:03.3: ttyS2 at I/O 0xe000 (irq = 169) is a 16550A
.fi
.P
Edit initab, add a line like this:
.P
.nf
  S2:2345:respawn:/sbin/agetty ttyS2 115200 vt100-nav
.fi
.P
You should add the serial port to /etc/securetty too so you are able
to login as root.  Reload inittab ("init q").  Use amtterm to connect.
Tap enter.  You should see a login prompt now and be able to login.
.P
You can also use that device as console for the linux kernel, using
the usual "console=ttyS2,115200" kernel command line argument, so you
see the boot messages (and kernel Oopses, if any).
.P
You can tell grub to use that serial device, so you can pick a working
kernel for the next boot.  Usual commands from the grub manual, except
that you need "\-\-port=0xe000" instead of "\-\-unit=0" due to the
non-standard I/O port for the serial line (my machine, yours might use
another port, check linux kernel boot messages).
.P
The magic command for the Xen kernel is "com1=115200,8n1,0xe000,0"
(again, you might have to replace the I/O port).  The final '0'
disables the IRQ, otherwise the Xen kernel hangs at boot after
enabling interrupts.

.SS Fun with Xen and AMT
The AMT network stack seems to become slightly confused when running
on a Xen host in DHCP mode.  Everything works fine as long as only
Dom0 runs.  But if one starts a guest OS (with bridged networking) AMT
suddenly changes the IP address to the one the guest aquired via DHCP.
.P
It is probably a good idea to assign a separate static IP address to
AMT then.  I didn't manage to switch my machine from DHCP to static IP
yet though, the BIOS refuses to accept the settings.  The error
message doesn't indicate why.

.SS More fun with AMT
You might want to download the DTK (Developer Toolkit, source code is
available too) and play with it.  The .exe is a self-extracting rar
archive and can be unpacked on linux using the unrar utility.  The
Switchbox comes with a linux binary (additionally to the Windows
stuff).  The GUI tools are written in C#.  Trying to make them fly
with mono didn't work for me though (mono version 1.2.3 as shipped
with Fedora 7).

.SH SEE ALSO
amtterm(1), gamt(1), amttool(1)
.P
http://www.intel.com/technology/platform-technology/intel-amt/
.SH WRITTEN BY
Gerd Hoffmann <kraxel@redhat.com>
