/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.auth.internal;

import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.util.StreamUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class KeyPairAuthenticationDetailProvider
implements BasicAuthenticationDetailsProvider,
RefreshableOnNotAuthenticatedProvider<String> {
    private final String resourceId;
    private final InputStream privateKeyStream;
    private final char[] passphrase;
    private final String tenancyId;

    public KeyPairAuthenticationDetailProvider(String resourceId, InputStream privateKeyStream, char[] passphrase) {
        this(resourceId, privateKeyStream, passphrase, null);
    }

    public KeyPairAuthenticationDetailProvider(String resourceId, InputStream privateKeyStream, char[] passphrase, String tenancyId) {
        this.resourceId = resourceId;
        this.privateKeyStream = privateKeyStream;
        this.passphrase = passphrase;
        this.tenancyId = tenancyId;
    }

    @Override
    public String getKeyId() {
        if (this.tenancyId != null) {
            return "resource/v2.1.1/" + this.tenancyId + "/" + this.resourceId;
        }
        return "resource/v2.1/" + this.resourceId;
    }

    @Override
    public InputStream getPrivateKey() {
        try {
            return new ByteArrayInputStream(StreamUtils.toByteArray(this.privateKeyStream));
        }
        catch (IOException ex) {
            throw new IllegalStateException("Unable to read private key stream.", ex);
        }
    }

    @Override
    public String getPassPhrase() {
        return this.passphrase.toString();
    }

    @Override
    public char[] getPassphraseCharacters() {
        return this.passphrase;
    }

    @Override
    public String refresh() {
        return this.resourceId;
    }
}

