/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.util.internal;

import java.util.Arrays;

public enum Validate {


    public static <T> T notNull(T o, String reason, Object ... values) {
        if (o == null) {
            throw new NullPointerException(String.format(reason, values));
        }
        return o;
    }

    public static <T> T isInstanceOf(Class<?> clazz, T o, String reason, Object ... values) {
        if (!clazz.isInstance(o)) {
            throw new IllegalArgumentException(String.format(reason, values));
        }
        return o;
    }

    public static String notBlank(String s, String reason, Object ... values) {
        if (s == null) {
            throw new NullPointerException(String.format(reason, values));
        }
        if (s.trim().isEmpty()) {
            throw new IllegalArgumentException(String.format(reason, values));
        }
        return s;
    }

    public static void isTrue(boolean condition, String reason, Object ... values) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(reason, values));
        }
    }

    public static long inclusiveBetween(long minimum, long maximum, long value, String reason, Object ... values) {
        if (minimum > maximum) {
            throw new IllegalArgumentException(String.format("minimum '%d' was greater than maximum '%d'", minimum, maximum));
        }
        if (minimum > value || maximum < value) {
            throw new IllegalArgumentException(String.format(reason, values));
        }
        return value;
    }

    public static <T> T[] noNullElements(T[] array, String reason, Object ... values) {
        if (array == null) {
            throw new NullPointerException(String.format(reason, values));
        }
        if (Arrays.stream(array).anyMatch(o -> o == null)) {
            throw new IllegalArgumentException(String.format(reason, values));
        }
        return array;
    }

    public static <T> T[] notEmpty(T[] array, String reason, Object ... values) {
        if (array == null) {
            throw new NullPointerException(String.format(reason, values));
        }
        if (array.length == 0) {
            throw new IllegalArgumentException(String.format(reason, values));
        }
        return array;
    }
}

