// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(
    clippy::collapsible_if,
    clippy::bool_comparison,
    clippy::nonminimal_bool,
    clippy::comparison_to_empty,
    clippy::redundant_pattern_matching,
    clippy::useless_asref
)]
pub(super) fn resolve_endpoint(
    _params: &crate::config::endpoint::Params,
    _diagnostic_collector: &mut crate::endpoint_lib::diagnostic::DiagnosticCollector,
    partition_resolver: &crate::endpoint_lib::partition::PartitionResolver,
) -> ::aws_smithy_http::endpoint::Result {
    #[allow(unused_variables)]
    let use_dual_stack = &_params.use_dual_stack;
    #[allow(unused_variables)]
    let use_fips = &_params.use_fips;
    #[allow(unused_variables)]
    let endpoint = &_params.endpoint;
    #[allow(unused_variables)]
    let region = &_params.region;
    #[allow(unused_variables)]
    if let Some(endpoint) = endpoint {
        if (*use_fips) == (true) {
            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                "Invalid Configuration: FIPS and custom endpoint are not supported".to_string(),
            ));
        }
        if (*use_dual_stack) == (true) {
            return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                "Invalid Configuration: Dualstack and custom endpoint are not supported".to_string(),
            ));
        }
        return Ok(::aws_smithy_types::endpoint::Endpoint::builder().url(endpoint.to_owned()).build());
    }
    #[allow(unused_variables)]
    if let Some(region) = region {
        #[allow(unused_variables)]
        if let Some(partition_result) = partition_resolver.resolve_partition(region.as_ref() as &str, _diagnostic_collector) {
            if (partition_result.name()) == ("aws") {
                if (*use_fips) == (false) {
                    if (*use_dual_stack) == (false) {
                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                            .url({
                                let mut out = String::new();
                                out.push_str("https://");
                                #[allow(clippy::needless_borrow)]
                                out.push_str(&region.as_ref() as &str);
                                out.push_str(".signin.aws.amazon.com");
                                out
                            })
                            .build());
                    }
                }
            }
            if (partition_result.name()) == ("aws-cn") {
                if (*use_fips) == (false) {
                    if (*use_dual_stack) == (false) {
                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                            .url({
                                let mut out = String::new();
                                out.push_str("https://");
                                #[allow(clippy::needless_borrow)]
                                out.push_str(&region.as_ref() as &str);
                                out.push_str(".signin.amazonaws.cn");
                                out
                            })
                            .build());
                    }
                }
            }
            if (partition_result.name()) == ("aws-us-gov") {
                if (*use_fips) == (false) {
                    if (*use_dual_stack) == (false) {
                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                            .url({
                                let mut out = String::new();
                                out.push_str("https://");
                                #[allow(clippy::needless_borrow)]
                                out.push_str(&region.as_ref() as &str);
                                out.push_str(".signin.amazonaws-us-gov.com");
                                out
                            })
                            .build());
                    }
                }
            }
            if (*use_fips) == (true) {
                if (*use_dual_stack) == (true) {
                    if (true) == (partition_result.supports_fips()) {
                        if (true) == (partition_result.supports_dual_stack()) {
                            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                                .url({
                                    let mut out = String::new();
                                    out.push_str("https://signin-fips.");
                                    #[allow(clippy::needless_borrow)]
                                    out.push_str(&region.as_ref() as &str);
                                    out.push('.');
                                    #[allow(clippy::needless_borrow)]
                                    out.push_str(&partition_result.dual_stack_dns_suffix());
                                    out
                                })
                                .build());
                        }
                    }
                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                        "FIPS and DualStack are enabled, but this partition does not support one or both".to_string(),
                    ));
                }
            }
            if (*use_fips) == (true) {
                if (*use_dual_stack) == (false) {
                    if (partition_result.supports_fips()) == (true) {
                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                            .url({
                                let mut out = String::new();
                                out.push_str("https://signin-fips.");
                                #[allow(clippy::needless_borrow)]
                                out.push_str(&region.as_ref() as &str);
                                out.push('.');
                                #[allow(clippy::needless_borrow)]
                                out.push_str(&partition_result.dns_suffix());
                                out
                            })
                            .build());
                    }
                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                        "FIPS is enabled but this partition does not support FIPS".to_string(),
                    ));
                }
            }
            if (*use_fips) == (false) {
                if (*use_dual_stack) == (true) {
                    if (true) == (partition_result.supports_dual_stack()) {
                        return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                            .url({
                                let mut out = String::new();
                                out.push_str("https://signin.");
                                #[allow(clippy::needless_borrow)]
                                out.push_str(&region.as_ref() as &str);
                                out.push('.');
                                #[allow(clippy::needless_borrow)]
                                out.push_str(&partition_result.dual_stack_dns_suffix());
                                out
                            })
                            .build());
                    }
                    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
                        "DualStack is enabled but this partition does not support DualStack".to_string(),
                    ));
                }
            }
            return Ok(::aws_smithy_types::endpoint::Endpoint::builder()
                .url({
                    let mut out = String::new();
                    out.push_str("https://signin.");
                    #[allow(clippy::needless_borrow)]
                    out.push_str(&region.as_ref() as &str);
                    out.push('.');
                    #[allow(clippy::needless_borrow)]
                    out.push_str(&partition_result.dns_suffix());
                    out
                })
                .build());
        }
        #[allow(unreachable_code)]
        return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(format!(
            "No rules matched these parameters. This is a bug. {_params:?}"
        )));
    }
    return Err(::aws_smithy_http::endpoint::ResolveEndpointError::message(
        "Invalid Configuration: Missing Region".to_string(),
    ));
}
