// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: BUSL-1.1

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             (unknown)
// source: private/pbpeerstream/peerstream.proto

package pbpeerstream

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	PeerStreamService_StreamResources_FullMethodName = "/hashicorp.consul.internal.peerstream.PeerStreamService/StreamResources"
	PeerStreamService_ExchangeSecret_FullMethodName  = "/hashicorp.consul.internal.peerstream.PeerStreamService/ExchangeSecret"
)

// PeerStreamServiceClient is the client API for PeerStreamService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PeerStreamServiceClient interface {
	// StreamResources opens an event stream for resources to share between peers, such as services.
	// Events are streamed as they happen.
	// buf:lint:ignore RPC_REQUEST_STANDARD_NAME
	// buf:lint:ignore RPC_RESPONSE_STANDARD_NAME
	// buf:lint:ignore RPC_REQUEST_RESPONSE_UNIQUE
	StreamResources(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[ReplicationMessage, ReplicationMessage], error)
	// ExchangeSecret is a unary RPC for exchanging the one-time establishment secret
	// for a long-lived stream secret.
	ExchangeSecret(ctx context.Context, in *ExchangeSecretRequest, opts ...grpc.CallOption) (*ExchangeSecretResponse, error)
}

type peerStreamServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewPeerStreamServiceClient(cc grpc.ClientConnInterface) PeerStreamServiceClient {
	return &peerStreamServiceClient{cc}
}

func (c *peerStreamServiceClient) StreamResources(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[ReplicationMessage, ReplicationMessage], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &PeerStreamService_ServiceDesc.Streams[0], PeerStreamService_StreamResources_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[ReplicationMessage, ReplicationMessage]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type PeerStreamService_StreamResourcesClient = grpc.BidiStreamingClient[ReplicationMessage, ReplicationMessage]

func (c *peerStreamServiceClient) ExchangeSecret(ctx context.Context, in *ExchangeSecretRequest, opts ...grpc.CallOption) (*ExchangeSecretResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ExchangeSecretResponse)
	err := c.cc.Invoke(ctx, PeerStreamService_ExchangeSecret_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PeerStreamServiceServer is the server API for PeerStreamService service.
// All implementations should embed UnimplementedPeerStreamServiceServer
// for forward compatibility.
type PeerStreamServiceServer interface {
	// StreamResources opens an event stream for resources to share between peers, such as services.
	// Events are streamed as they happen.
	// buf:lint:ignore RPC_REQUEST_STANDARD_NAME
	// buf:lint:ignore RPC_RESPONSE_STANDARD_NAME
	// buf:lint:ignore RPC_REQUEST_RESPONSE_UNIQUE
	StreamResources(grpc.BidiStreamingServer[ReplicationMessage, ReplicationMessage]) error
	// ExchangeSecret is a unary RPC for exchanging the one-time establishment secret
	// for a long-lived stream secret.
	ExchangeSecret(context.Context, *ExchangeSecretRequest) (*ExchangeSecretResponse, error)
}

// UnimplementedPeerStreamServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedPeerStreamServiceServer struct{}

func (UnimplementedPeerStreamServiceServer) StreamResources(grpc.BidiStreamingServer[ReplicationMessage, ReplicationMessage]) error {
	return status.Errorf(codes.Unimplemented, "method StreamResources not implemented")
}
func (UnimplementedPeerStreamServiceServer) ExchangeSecret(context.Context, *ExchangeSecretRequest) (*ExchangeSecretResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExchangeSecret not implemented")
}
func (UnimplementedPeerStreamServiceServer) testEmbeddedByValue() {}

// UnsafePeerStreamServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PeerStreamServiceServer will
// result in compilation errors.
type UnsafePeerStreamServiceServer interface {
	mustEmbedUnimplementedPeerStreamServiceServer()
}

func RegisterPeerStreamServiceServer(s grpc.ServiceRegistrar, srv PeerStreamServiceServer) {
	// If the following call pancis, it indicates UnimplementedPeerStreamServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&PeerStreamService_ServiceDesc, srv)
}

func _PeerStreamService_StreamResources_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(PeerStreamServiceServer).StreamResources(&grpc.GenericServerStream[ReplicationMessage, ReplicationMessage]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type PeerStreamService_StreamResourcesServer = grpc.BidiStreamingServer[ReplicationMessage, ReplicationMessage]

func _PeerStreamService_ExchangeSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExchangeSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PeerStreamServiceServer).ExchangeSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PeerStreamService_ExchangeSecret_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PeerStreamServiceServer).ExchangeSecret(ctx, req.(*ExchangeSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PeerStreamService_ServiceDesc is the grpc.ServiceDesc for PeerStreamService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PeerStreamService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "hashicorp.consul.internal.peerstream.PeerStreamService",
	HandlerType: (*PeerStreamServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ExchangeSecret",
			Handler:    _PeerStreamService_ExchangeSecret_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamResources",
			Handler:       _PeerStreamService_StreamResources_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "private/pbpeerstream/peerstream.proto",
}
