//@HEADER
// ************************************************************************
//
//                        Kokkos v. 4.0
//       Copyright (2022) National Technology & Engineering
//               Solutions of Sandia, LLC (NTESS).
//
// Under the terms of Contract DE-NA0003525 with NTESS,
// the U.S. Government retains certain rights in this software.
//
// Part of Kokkos, under the Apache License v2.0 with LLVM Exceptions.
// See https://kokkos.org/LICENSE for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//@HEADER

#include <gtest/gtest.h>
#include <cstdlib>

#include <Kokkos_Core.hpp>

#ifdef KOKKOS_ENABLE_CUDA
#include <TestCuda_Category.hpp>
#endif
#ifdef KOKKOS_ENABLE_HIP
#include <TestHIP_Category.hpp>
#endif
#ifdef KOKKOS_ENABLE_SYCL
#include <TestSYCL_Category.hpp>
#endif
#ifdef KOKKOS_ENABLE_OPENMP
#include <TestOpenMP_Category.hpp>
#endif
#ifdef KOKKOS_ENABLE_THREADS
#include <TestThreads_Category.hpp>
#endif
#ifdef KOKKOS_ENABLE_HPX
#include <TestHPX_Category.hpp>
#endif
#ifdef KOKKOS_ENABLE_OPENMPTARGET
#include <TestOpenMPTarget_Category.hpp>
#endif
#ifdef KOKKOS_ENABLE_OPENACC
#include <TestOpenACC_Category.hpp>
#endif
#ifndef TEST_EXECSPACE
#ifdef KOKKOS_ENABLE_SERIAL
#include <TestSerial_Category.hpp>
#endif
#endif
#include <TestReducers_d.hpp>

int main(int argc, char *argv[]) {
  Kokkos::initialize(argc, argv);
  ::testing::InitGoogleTest(&argc, argv);

  int result = RUN_ALL_TESTS();
  Kokkos::finalize();
  return result;
}
