// SPDX-FileCopyrightText: 2021 deroad <wargio@libero.it>
// SPDX-License-Identifier: LGPL-3.0-only

#ifndef RZ_ASM_AVR_DISASSEMBLER_H
#define RZ_ASM_AVR_DISASSEMBLER_H
#include <rz_types.h>
#include <rz_util.h>

typedef enum {
	AVR_OP_INVALID = 0,
	AVR_OP_ADC,
	AVR_OP_ADD,
	AVR_OP_ADIW,
	AVR_OP_AND,
	AVR_OP_ANDI,
	AVR_OP_ASR,
	AVR_OP_BLD,
	AVR_OP_BRCC,
	AVR_OP_BRCS,
	AVR_OP_BREAK,
	AVR_OP_BREQ,
	AVR_OP_BRGE,
	AVR_OP_BRHC,
	AVR_OP_BRHS,
	AVR_OP_BRID,
	AVR_OP_BRIE,
	AVR_OP_BRLO,
	AVR_OP_BRLT,
	AVR_OP_BRMI,
	AVR_OP_BRNE,
	AVR_OP_BRPL,
	AVR_OP_BRSH,
	AVR_OP_BRTC,
	AVR_OP_BRTS,
	AVR_OP_BRVC,
	AVR_OP_BRVS,
	AVR_OP_BST,
	AVR_OP_CALL,
	AVR_OP_CBI,
	AVR_OP_CLC,
	AVR_OP_CLH,
	AVR_OP_CLI,
	AVR_OP_CLN,
	AVR_OP_CLR,
	AVR_OP_CLS,
	AVR_OP_CLT,
	AVR_OP_CLV,
	AVR_OP_CLZ,
	AVR_OP_COM,
	AVR_OP_CP,
	AVR_OP_CPC,
	AVR_OP_CPI,
	AVR_OP_CPSE,
	AVR_OP_DEC,
	AVR_OP_DES,
	AVR_OP_EICALL,
	AVR_OP_EIJMP,
	AVR_OP_ELPM,
	AVR_OP_EOR,
	AVR_OP_FMUL,
	AVR_OP_FMULS,
	AVR_OP_FMULSU,
	AVR_OP_ICALL,
	AVR_OP_IJMP,
	AVR_OP_IN,
	AVR_OP_INC,
	AVR_OP_JMP,
	AVR_OP_LAC,
	AVR_OP_LAS,
	AVR_OP_LAT,
	AVR_OP_LD,
	AVR_OP_LDD,
	AVR_OP_LDI,
	AVR_OP_LDS,
	AVR_OP_LPM,
	AVR_OP_LSL,
	AVR_OP_LSR,
	AVR_OP_MOV,
	AVR_OP_MOVW,
	AVR_OP_MUL,
	AVR_OP_MULS,
	AVR_OP_MULSU,
	AVR_OP_NEG,
	AVR_OP_NOP,
	AVR_OP_OR,
	AVR_OP_ORI,
	AVR_OP_OUT,
	AVR_OP_POP,
	AVR_OP_PUSH,
	AVR_OP_RCALL,
	AVR_OP_RET,
	AVR_OP_RETI,
	AVR_OP_RJMP,
	AVR_OP_ROL,
	AVR_OP_ROR,
	AVR_OP_SBC,
	AVR_OP_SBCI,
	AVR_OP_SBI,
	AVR_OP_SBIC,
	AVR_OP_SBIS,
	AVR_OP_SBIW,
	AVR_OP_SBRC,
	AVR_OP_SBRS,
	AVR_OP_SEC,
	AVR_OP_SEH,
	AVR_OP_SEI,
	AVR_OP_SEN,
	AVR_OP_SER,
	AVR_OP_SES,
	AVR_OP_SET,
	AVR_OP_SEV,
	AVR_OP_SEZ,
	AVR_OP_SLEEP,
	AVR_OP_SPM,
	AVR_OP_ST,
	AVR_OP_STD,
	AVR_OP_STS,
	AVR_OP_SUB,
	AVR_OP_SUBI,
	AVR_OP_SWAP,
	AVR_OP_TST,
	AVR_OP_WDR,
	AVR_OP_XCH,
	/* end */
	AVR_OP_SIZE
} AVROpMnem;

typedef struct avr_opcode_t {
	AVROpMnem mnemonic;
	ut16 mask;
	ut16 param[4];
	ut16 cycles;
	ut16 size;
} AVROp;

ut32 avr_disassembler(const ut8 *buffer, const ut32 size, ut64 pc, bool be, AVROp *aop, RzStrBuf *sb);

#endif /* RZ_ASM_AVR_DISASSEMBLER_H */
