<!-- Generated by cargo-onedoc. DO NOT EDIT. -->

# constcat

[![Crates.io Version](https://badgers.space/crates/version/constcat)](https://crates.io/crates/constcat)
[![Docs.rs Latest](https://badgers.space/badge/docs.rs/latest/blue)](https://docs.rs/constcat)
[![Build Status](https://badgers.space/github/checks/rossmacarthur/constcat?label=build)](https://github.com/rossmacarthur/constcat/actions/workflows/build.yaml)

[`std::concat!`] with support for `const` variables and expressions.

[`std::concat!`]: core::concat

Works on stable Rust ✨.

## 🚀 Getting started

Add `constcat` to your Cargo manifest.

```sh
cargo add constcat
```

Import the macro using the following.

```rust
use constcat::concat;
```

## 🤸 Usage

### String slices

`concat!` works exactly like [`std::concat!`], concatenating `&str`
literals into a static string slice, except you can now pass variables and
constant expressions.

```rust
const CRATE_NAME: &str = env!("CARGO_PKG_NAME");
const CRATE_VERSION: &str = env!("CARGO_PKG_VERSION");
const fn tada() -> &'static str { "🎉" }
const VERSION: &str = concat!(CRATE_NAME, " ", CRATE_VERSION, tada());
```

### Byte slices

`concat_bytes!` works similarly to `concat!`, concatenating `const`
`&[u8]` expressions and literals into a static byte slice.

```rust
const VERSION: u32 = 1;
const fn entries() -> &'static [u8] { b"example" }
const HEADER: &[u8] = concat_bytes!(&VERSION.to_le_bytes(), entries());
```

### `T` slices

`concat_slices!` is the underlying macro used for both of the above, this
can be used to concatenate `const` `&[T]` expressions into a static
slice.

This macro requires the type of slice to be specified in the form `[T]: `
before the comma separated expressions.

```rust
const MAGIC: &[i32; 4] = &[1, 3, 3, 7];
const VERSION: i32 = 1;
const HEADER: &[i32] = concat_slices!([i32]: MAGIC, &[0, VERSION]);
```

```rust
const PRIMARIES: &'static [(u8, u8, u8)] = &[(255, 0, 0), (0, 255, 0), (0, 0, 255)];
const SECONDARIES: &'static [(u8, u8, u8)] = &[(255, 255, 0), (255, 0, 255), (0, 255, 255)];
const COLORS: &[(u8, u8, u8)] = concat_slices!([(u8, u8, u8)]: PRIMARIES, SECONDARIES);
```

### MSRV

This crate supports Rust 1.66 and above.

[`std::concat!`]: core::concat

## License

This project is distributed under the terms of both the MIT license and the Apache License (Version 2.0).

See [LICENSE-APACHE](LICENSE-APACHE) and [LICENSE-MIT](LICENSE-MIT) for details.
