/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import java.util.Collections;
import java.util.Iterator;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.mapping.Property;
import net.sf.hibernate.mapping.RootClass;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.mapping.Value;
import net.sf.hibernate.util.JoinedIterator;

public class Subclass
extends PersistentClass {
    private PersistentClass superclass;
    private Value key;

    public Subclass(PersistentClass superclass) {
        this.superclass = superclass;
    }

    public CacheConcurrencyStrategy getCache() {
        return this.getSuperclass().getCache();
    }

    public RootClass getRootClass() {
        return this.getSuperclass().getRootClass();
    }

    public PersistentClass getSuperclass() {
        return this.superclass;
    }

    public Property getIdentifierProperty() {
        return this.getSuperclass().getIdentifierProperty();
    }

    public Value getIdentifier() {
        return this.getSuperclass().getIdentifier();
    }

    public boolean hasIdentifierProperty() {
        return this.getSuperclass().hasIdentifierProperty();
    }

    public Value getDiscriminator() {
        return this.getSuperclass().getDiscriminator();
    }

    public boolean isMutable() {
        return this.getSuperclass().isMutable();
    }

    public boolean isInherited() {
        return true;
    }

    public boolean isPolymorphic() {
        return true;
    }

    public void addProperty(Property p) {
        super.addProperty(p);
        this.getSuperclass().addSubclassProperty(p);
    }

    public void setTable(Table table) {
        super.setTable(table);
        this.getSuperclass().addSubclassTable(table);
    }

    public Iterator getPropertyClosureIterator() {
        return new JoinedIterator(new Iterator[]{this.getPropertyIterator(), this.getSuperclass().getPropertyClosureIterator()});
    }

    public Iterator getTableClosureIterator() {
        return new JoinedIterator(new Iterator[]{this.getSuperclass().getTableClosureIterator(), Collections.singleton(this.getTable()).iterator()});
    }

    protected void addSubclassProperty(Property p) {
        super.addSubclassProperty(p);
        this.getSuperclass().addSubclassProperty(p);
    }

    protected void addSubclassTable(Table table) {
        super.addSubclassTable(table);
        this.getSuperclass().addSubclassTable(table);
    }

    public boolean isVersioned() {
        return this.getSuperclass().isVersioned();
    }

    public Property getVersion() {
        return this.getSuperclass().getVersion();
    }

    public boolean hasEmbeddedIdentifier() {
        return this.getSuperclass().hasEmbeddedIdentifier();
    }

    public Class getPersister() {
        return this.getSuperclass().getPersister();
    }

    public Table getRootTable() {
        return this.getSuperclass().getRootTable();
    }

    public Value getKey() {
        if (this.key == null) {
            return this.getIdentifier();
        }
        return this.key;
    }

    public boolean isExplicitPolymorphism() {
        return this.getSuperclass().isExplicitPolymorphism();
    }

    public void setKey(Value key) {
        this.key = key;
    }

    public void setSuperclass(PersistentClass superclass) {
        this.superclass = superclass;
    }
}

