/******************************************************************************************************
 * (C) 2014 markummitchell@github.com. This file is part of Engauge Digitizer, which is released      *
 * under GNU General Public License version 2 (GPLv2) or (at your option) any later version. See file *
 * LICENSE or go to gnu.org/licenses for details. Distribution requires prior written permission.     *
 ******************************************************************************************************/

#ifndef FILE_CMD_ABSTRACT_H
#define FILE_CMD_ABSTRACT_H

#include <QString>

class MainWindow;

/// Base class for 'file commands' that are used specifically for regression testing of file import/open/export features.
/// These commands operate outside of the normal undo/redo command framework, since that framework uses commands that
/// are attached to an open Document. The file commands follow special rules:
/// -# Never generated by the code
/// -# Created by manually editing a 'file command' xml file, which does NOT have a Document (so error report files cannot
///    be used unless pretty much everything is removed)
/// -# Are only read during regression testing normally. Although they can be loaded otherwise, there is no point in doing so
/// -# These commands operate in the forward direction only, since undoing a File Close could be quite messy
class FileCmdAbstract 
{
 public:
  /// Single constructor
  FileCmdAbstract(const QString &cmdDescription);

  virtual ~FileCmdAbstract();

  /// Apply this command, through MainWindow
  virtual void redo(MainWindow &mainWindow) = 0;

 protected:
  /// Command description for logging
  QString cmdDescription() const;

 private:

  QString m_cmdDescription;
};

#endif // FILE_CMD_ABSTRACT_H
