<!-- THIS WHOLE FILE IS AUTOGENERATED. DO NOT MODIFY IT. See scripts/generate-docs.sh -->




# config

## **ai-anthropic-api-key**
<small style="color: lightgray;">(only in GDB)</small>


Anthropic API key.

Defaults to ANTHROPIC_API_KEY environment variable if not set.

**Default:** ''  

----------

## **ai-history-size**
<small style="color: lightgray;">(only in GDB)</small>


Maximum number of questions and answers to keep in the prompt.



**Default:** 3  

----------

## **ai-max-tokens**
<small style="color: lightgray;">(only in GDB)</small>


The maximum number of tokens to return in the response.

Useful when limiting verbosity or conserving resources. Set to a lower value to restrict output.

**Default:** 100  

----------

## **ai-model**
<small style="color: lightgray;">(only in GDB)</small>


The name of the large language model to query.

Changing this affects the behavior, response quality, and cost (if applicable) of AI responses.

**Default:** 'gpt-3.5-turbo'  

----------

## **ai-ollama-endpoint**
<small style="color: lightgray;">(only in GDB)</small>


Ollama API endpoint.

Defaults to OLLAMA_ENDPOINT environment variable if not set.

**Default:** ''  

----------

## **ai-openai-api-key**
<small style="color: lightgray;">(only in GDB)</small>


OpenAI API key.

Will default to OPENAI_API_KEY environment variable if not set.

**Default:** ''  

----------

## **ai-show-usage**
<small style="color: lightgray;">(only in GDB)</small>


Whether to show how many tokens are used with each OpenAI API call.



**Default:** off  

----------

## **ai-stack-depth**
<small style="color: lightgray;">(only in GDB)</small>


Rows of stack context to include in the prompt for the ai command.



**Default:** 16  

----------

## **ai-temperature**
<small style="color: lightgray;">(only in GDB)</small>


The temperature specification for the LLM query.

This controls the degree of randomness in the response.

**Default:** 0  

----------

## **attachp-resolution-method**
<small style="color: lightgray;">(only in GDB)</small>


How to determine the process to attach when multiple candidates exists.



**Default:** 'ask'  
**Valid values:** 'none', 'oldest', 'newest', 'ask'

----------

## **auto-explore-auxv**


Stack exploration for AUXV information; it may be really slow.



**Default:** 'warn'  
**Valid values:** 'warn', 'yes', 'no'

----------

## **auto-explore-pages**


Whether to try to infer page permissions when memory maps are missing.

This command can cause errors.

**Default:** 'warn'  
**Valid values:** 'yes', 'warn', 'no'

----------

## **auto-explore-stack**


Stack exploration; it may be really slow.



**Default:** 'warn'  
**Valid values:** 'warn', 'yes', 'no'

----------

## **auto-save-search**


Automatically pass --save to "search" command.



**Default:** off  

----------

## **bn-autosync**


Whether to automatically run bn-sync every step.



**Default:** off  

----------

## **bn-il-level**


The IL level to use when displaying Binary Ninja decompilation.



**Default:** 'hlil'  
**Valid values:** 'disasm', 'llil', 'mlil', 'hlil'

----------

## **bn-rpc-host**


Binary Ninja XML-RPC server host.



**Default:** '127.0.0.1'  

----------

## **bn-rpc-port**


Binary Ninja XML-RPC server port.



**Default:** 31337  

----------

## **bn-timeout**


Time to wait for Binary Ninja XML-RPC, in seconds.



**Default:** 2  

----------

## **context-backtrace-lines**


Number of lines to print in the backtrace context.



**Default:** 8  

----------

## **context-clear-screen**


Whether to clear the screen before printing the context.



**Default:** off  

----------

## **context-code-lines**


Number of source code lines to print by the context command.



**Default:** 10  

----------

## **context-code-tabstop**


Number of spaces that a <tab> in the source code counts for.



**Default:** 8  

----------

## **context-disasm-lines**


Number of additional lines to print in the disasm context.



**Default:** 10  

----------

## **context-ghidra**


When to try to decompile the current function with ghidra.

Doing this is slow and requires radare2/r2pipe or rizin/rzpipe.

**Default:** 'never'  
**Valid values:** 'always', 'never', 'if-no-source'

----------

## **context-history-size**


Number of context history entries to store.



**Default:** 50  

----------

## **context-integration-decompile**


Whether context should fall back to decompilation with no source code.



**Default:** on  

----------

## **context-max-threads**


Maximum number of threads displayed by the context command.



**Default:** 4  

----------

## **context-output**


Where Pwndbg should output ("stdout" or file/tty).



**Default:** 'stdout'  

----------

## **context-reserve-lines**


When to reserve lines after the prompt to reduce context shake.

The "if-ctx-fits" setting only reserves lines if the whole context would still fit vertically in the current terminal window.
It doesn't take into account line-wrapping due to insufficient terminal width.

**Default:** 'if-ctx-fits'  
**Valid values:** 'never', 'if-ctx-fits', 'always'

----------

## **context-sections**


Which context sections are displayed (controls order).



**Default:** 'regs disasm code ghidra stack backtrace expressions threads heap_tracker'  

----------

## **context-stack-lines**


Number of lines to print in the stack context.



**Default:** 8  

----------

## **cymbol-editor**
<small style="color: lightgray;">(only in GDB)</small>


Path to the editor for editing custom structures.



**Default:** ''  

----------

## **debug-events**
<small style="color: lightgray;">(only in GDB)</small>


Display internal event debugging info.



**Default:** off  

----------

## **decompiler**


Framework that your ghidra plugin installed.



**Default:** 'radare2'  
**Valid values:** 'radare2', 'rizin'

----------

## **default-visualize-chunk-number**


Default number of chunks to visualize.



**Default:** 10  

----------

## **dereference-limit**


Max number of pointers to dereference in a chain.



**Default:** 5  

----------

## **disasm-annotations**


Display annotations for instructions.



**Default:** on  

----------

## **disasm-inline-symbols**


Replacing constant operands with their symbol in the disassembly.



**Default:** on  

----------

## **disasm-reg-alias**


Force the disassembly to use register aliases (e.g. aarch64 x29 -> fp).

The register aliasing is done by capstone, see:
https://github.com/capstone-engine/capstone/blob/next/docs/cs_v6_release_guide.md#:~:text=None.-,Register%20alias,-Register%20alias%20

Enabling this may make disassembly slower.

**Default:** off  

----------

## **disasm-telescope-depth**


Depth of telescope for disasm annotations.



**Default:** 3  

----------

## **disasm-telescope-string-length**


The number of characters in strings to display in disasm annotations.



**Default:** 50  

----------

## **emulate**


Unicorn emulation of code from the current PC register.

Emulate can be:

1. off             - no emulation is performed
2. jumps-only      - emulation is done only to resolve branch instructions
3. on              - emulation is done to resolve registers/memory values etc.

Emulation can slow down Pwndbg. Disabling it may improve performance.
Emulation requires >1GB RAM being available on the system and ability to allocate RWX memory.

**Default:** 'on'  
**Valid values:** 'on', 'off', 'jumps-only'

----------

## **emulate-annotations**


Unicorn emulation for instruction annotations.

Refers to register and memory value annotations.

**Default:** on  

----------

## **emulate-future-annotations**


Unicorn emulation for future instruction's annotations.



**Default:** on  

----------

## **exception-debugger**


Whether to debug exceptions raised in Pwndbg commands.



**Default:** off  

----------

## **exception-verbose**


Print a full stacktrace for exceptions raised in Pwndbg commands.



**Default:** off  

----------

## **gcc-compiler-path**
<small style="color: lightgray;">(only in GDB)</small>


Path to the gcc/g++ toolchain for generating imported symbols.



**Default:** ''  

----------

## **gdb-workaround-stop-event**
<small style="color: lightgray;">(only in GDB)</small>


Asynchronous stop events to improve 'commands' functionality.

Note that this may cause unexpected behavior with Pwndbg or gdb.execute.

Values explained:

+ `disabled` - Disable the workaround (default).
+ `disabled-deadlock` - Disable only deadlock detection; deadlocks may still occur.
+ `enabled` - Enable asynchronous stop events; gdb.execute may behave unexpectedly (asynchronously).

**Default:** 'disabled'  
**Valid values:** 'disabled', 'disabled-deadlock', 'enabled'

----------

## **go-dump-indent-amount**


The indent amount for go-dump pretty printing.



**Default:** 4  

----------

## **go-dump-line-width**


The soft line width for go-dump pretty printing.



**Default:** 80  

----------

## **hexdump-bytes**


Number of bytes printed by hexdump command.



**Default:** 64  

----------

## **hexdump-group-use-big-endian**


Use big-endian within each group of bytes in hexdump command.

When `on`, use big-endian within each group of bytes. Only applies to raw bytes, not the ASCII part. See also hexdump-highlight-group-lsb.

**Default:** off  

----------

## **hexdump-group-width**


Number of bytes grouped in hexdump command.

If -1, the architecture's pointer size is used.

**Default:** -1  

----------

## **hexdump-limit-mb**


The maximum size in megabytes (MB) `hexdump` will read.

Set the maximum size in megabytes (MB) that the `hexdump` command will attempt to read at once.
    Prevents GDB crashes due to excessive memory allocation requests.
    Set to 0 for unlimited (use with caution).

**Default:** 10  

----------

## **hexdump-width**


Line width of hexdump command.



**Default:** 16  

----------

## **ida-rpc-host**
<small style="color: lightgray;">(only in GDB)</small>


Ida xmlrpc server address.



**Default:** '127.0.0.1'  

----------

## **ida-rpc-port**
<small style="color: lightgray;">(only in GDB)</small>


Ida xmlrpc server port.



**Default:** 31337  

----------

## **ida-timeout**
<small style="color: lightgray;">(only in GDB)</small>


Time to wait for ida xmlrpc in seconds.



**Default:** 2  

----------

## **integration-function-lookup**


Use integration to look up function type signatures.



**Default:** on  

----------

## **integration-provider**


Which provider to use for integration features.



**Default:** 'none'  
**Valid values:** 'none', 'binja', 'ida'

----------

## **integration-smart-enhance**


Use integration to determine when to disassemble during enhancing.



**Default:** on  

----------

## **integration-symbol-lookup**


Whether to use integration to look up unknown symbols.



**Default:** on  

----------

## **kernel-vmmap**


The method to get vmmap information when debugging via QEMU kernel.

Values explained:

+ `page-tables` - read /proc/$qemu-pid/mem to parse kernel page tables to render vmmap
+ `monitor` - use QEMU's `monitor info mem` to render vmmap
+ `none` - disable vmmap rendering; useful if rendering is particularly slow

Note that the page-tables method will require the QEMU kernel process to be on the same machine and within the same PID namespace. Running QEMU kernel and GDB in different Docker containers will not work. Consider running both containers with --pid=host (meaning they will see and so be able to interact with all processes on the machine).

**Default:** 'page-tables'  
**Valid values:** 'page-tables', 'monitor', 'none'

----------

## **left-pad-disasm**


Whether to left-pad disassembly.



**Default:** on  

----------

## **max-decimal-number**


Show all numbers greater than this in hex.

For negative numbers, their absolute value is used.

Set the parameter to 'unlimited' if you want all values in decimal.
Specially, set the parameter to zero if you want all values in hex.

The assembly instruction operands come from capstone, and are thus
not controlled by this setting. For consistency with them, leave
this setting at 9 (the default).

**Default:** 9  

----------

## **max-visualize-chunk-size**


Max display size for heap chunks visualization (0 for display all).



**Default:** 0  

----------

## **nearpc-integration-comments**


Whether to show comments from integration provider.



**Default:** on  

----------

## **nearpc-lines**


Number of additional lines to print for the nearpc command.



**Default:** 10  

----------

## **nearpc-num-opcode-bytes**


Number of opcode bytes to print for each instruction.



**Default:** 0  

----------

## **nearpc-opcode-separator-bytes**


Number of spaces between opcode bytes.



**Default:** 1  

----------

## **nearpc-show-args**


Whether to show call arguments below instruction.



**Default:** on  

----------

## **objc-max-function-arguments**


Maximum number of arguments to resolve for an Objective-C method call.



**Default:** 32  

----------

## **objc-max-function-types-depth**


Maximum allowed depth for a type in an Objective-C method call.



**Default:** 32  

----------

## **safe-linking**


Whether glibc uses safe-linking.



**Default:** auto  
**Valid values:** on, off, auto.

----------

## **show-compact-regs**


Whether to show a compact register view with columns.



**Default:** off  

----------

## **show-compact-regs-columns**


The number of columns (0 for dynamic number of columns).



**Default:** 2  

----------

## **show-compact-regs-min-width**


The minimum width of each column.



**Default:** 20  

----------

## **show-compact-regs-separation**


The number of spaces separating columns.



**Default:** 4  

----------

## **show-flags**


Whether to show flags registers.



**Default:** off  

----------

## **show-retaddr-reg**


Whether to show return address register.



**Default:** on  

----------

## **show-tips**


Whether to display the tip of the day on startup.



**Default:** on  

----------

## **syntax-highlight**


Source code / assembly syntax highlight.



**Default:** on  

----------

## **telescope-dont-skip-registers**


Don't skip a repeated line if a registers points to it.



**Default:** on  

----------

## **telescope-frame-print-retaddr**


Print one pointer past the stack frame.



**Default:** on  

----------

## **telescope-framepointer-offset**


Print offset to framepointer for each address, if sufficiently small.



**Default:** on  

----------

## **telescope-lines**


Number of lines to printed by the telescope command.



**Default:** 8  

----------

## **telescope-skip-repeating-val**


Whether to skip repeating values of the telescope command.



**Default:** on  

----------

## **telescope-skip-repeating-val-min**


Minimum amount of repeated values before skipping lines.



**Default:** 3  

----------

## **vmmap-prefer-relpaths**


Show relative paths by default in vmmap.



**Default:** on  

----------
