# Announce: Rakudo Perl 6 compiler, Release #100 (2016.06)

On behalf of the Rakudo development team, I’m very happy to announce the
June 2016 release of Rakudo Perl 6 #100. Rakudo is an implementation of
Perl 6 on the Moar Virtual Machine[^1].

This release implements the 6.c version of the Perl 6 specifications.
It includes bugfixes and optimizations on top of
the 2015.12 release of Rakudo, but no new features.

Upcoming releases in 2016 will include new functionality that is not
part of the 6.c specification, available with a lexically scoped
pragma. Our goal is to ensure that anything that is tested as part of the
6.c specification will continue to work unchanged. There may be incremental
spec releases this year as well.

The tarball for this release is available from <http://rakudo.org/downloads/rakudo/>.

Please note: This announcement is not for the Rakudo Star
distribution[^2] --- it’s announcing a new release of the compiler
only. For the latest Rakudo Star release, see
<http://rakudo.org/downloads/star/>.

Notable changes in this release are outlined below:

 + Fixes:
   + Arrays with holes (e.g. from :delete) now correctly iterate/auto-vivify
   + Precompilation on file systems with coarse timestamps no longer fails
   + An issue with reverse dependencies of installed modules was fixed
 + Additions:
   + The "is-approx" sub from Test now allows for relative/absolute tolerance
   + A fail in a custom BUILD will now be returned, rather than thrown
 + Efficiency:
   + .map between 10% and 30% faster
   + .unique, .repeated and .squish 10% to 20% faster
   + gather/take about 10% faster
   + Basic object creation (using either .new or .bless) now up to 3x faster
   + (+@a), (*@a) and (**@a) signature handling between 20% and 4x faster
   + All routines now have less overhead, thanks to improved implementation of
     return handlers (including those that do not use return)
+ Deprecations:
   + The "is_approx" sub (note underscore) from Test
+ Potential issues:
   + There's been an unconfirmed report this release fails NativeCall
     tests when attempting to build an .rpm package. Basic evaluation showed
     packaged NativeCall still works fine and currently the cause of test
     failures is unknown.

These are only some of the changes in this release. For a more
detailed list, see “docs/ChangeLog”.

The following people contributed to this release:

Elizabeth Mattijsen, Jonathan Worthington, Jan-Olof Hendig, Zoffix Znet,
Josh Soref, Pawel Murias, Wenzel P. P. Peppmeyer, Aleks-Daniel Jakimenko-Aleksejev,
Tom Browder, Daniel Green, Jonathan Stowe, titsuki, Stefan Seifert, Pepe Schwarz,
Christian Bartolomäus, Will "Coke" Coleda, Steve Mynott, Tobias Leich, Larry Wall,
Timo Paulssen, Brock Wilcox, Moritz Lenz, Bruce Gray, raiph, LLFourn, Bart Wiegmans,
Jimmy Zhuo, Steve Bertrand, Brad Gilbert, diakopter, Nick Logan, Sterling Hanenkamp,
Carl Masak, Rob Hoelz, David H. Adler, David Warring, ab5tract, Christopher Bottoms

as well as

Itsuki Toyota, Matthew Wilson, Will Coleda, parabolize

If you would like to contribute or find out more information, visit
<http://perl6.org>, <http://rakudo.org/how-to-help>, ask on the
<perl6-compiler@perl.org> mailing list, or ask on IRC #perl6 on freenode.

The next release of Rakudo (#101), is tentatively scheduled for 2016-07-16.

A list of the other planned release dates is available in the
“docs/release_guide.pod” file.

The development team appreciates feedback! If you’re using Rakudo, do
get back to us. Questions, comments, suggestions for improvements, cool
discoveries, incredible hacks, or any other feedback -- get in touch with
us through (the above-mentioned) mailing list or IRC channel. Enjoy!

Please note that recent releases have known issues running on the JVM.
We are working to get the JVM backend working again but do not yet have
an estimated delivery date.

[^1]: See <http://moarvm.org/>

[^2]: What’s the difference between the Rakudo compiler and the Rakudo
Star distribution?

The Rakudo compiler is a compiler for the Perl 6 language.
Not much more.

The Rakudo Star distribution is the Rakudo compiler plus a selection
of useful Perl 6 modules, a module installer, the most recent
incarnation of the “Using Perl 6” book, and other software that can
be used with the Rakudo compiler to enhance its utility.
