# Superset
 N-Prolog is compatible with ARITY/PROLOG. This is an old language specification from the 1980s. Some predicates have been added to run more modern code, primarily based on ISO-Prolog. However, please note that these may not necessarily conform to the ISO-Prolog specification.

 # Spec
The following extension functions respect ISO-Prolog as much as possible, but they are provided primarily for the purpose of being a backward-compatible extension in N-Prolog. Please refrain from pointing out differences with ISO-Prolog.


- \+ (not)

- atom_concat/3  
 The first and second arguments are concatenated and unified with the third argument. Now ,the following cases are not supported. e.g. atom_concat(X,b,ab).

- append/3

- member/2

- between/3

- select/3

- succ/2

- maplist/2

- compound/1

- ground/1

- once/1

- atom_codes/2

- atom_chars/2

- char_code/2

- number_codes/2

- number_chars/2

- predicate_property/2

- bagof/3

- setof/3

- findall/3

- write_canonical/1 /2

- atom_length/2

- get_code/1 2

- get_char/1 2

- get_byte/1 2

- put_char/1 2

- put_code/1 2

- put_byte/1 2

- peek_code/1 2

- peek_char/1 2

- peek_byte/1 2

- flush_output/0 1

- catch/3

- throw/1

- unify_with_occurs_check/2

- current_input/1

- current_output/1

- set_input/1

- set_output/1

- use_module/1

- module/1

- copy_term/2

- at_end_of_stream/1

- stream_property/2

- dynamic/1
In N-Prolog, when foo/1 is given, the entire foo predicate is defined as dynamic.

- initialization/1

- retractall/1

- subsumes_term/2


# Not ISO-Prolog
N-Prolog is specialized for experimenting with and playing around with small-scale code. Therefore, the following features are not included.

- sub_atom/5  
 Reverse computation is too complex.
- open/3  
 Please use open/3 compatible with Arity/Prolog.
- multifile/1 
 For now, we are not considering complex libraries.
- include/1
- ensure_loaded/1
- write_term/2
- current_prolog_flag/2

- set_prolog_flag/2 The set_prolog_flag exists, but it is different from ISO.
  - set_prolog_flag(string,arity). e.g. $hello world$
  - set_prolog_flag(string,iso).   e.g. "hello world"
  - set_prolog_flag(expression,canonical). e.g.  foo(1)
  - set_prolog_flag(expression,sexp).      e.g.  (foo 1) 

 
- long atom with '\\' 
 Excessively long atoms hinder code readability.

- char-code with '\0x23\' 
 Use char_code/2. ?- char_code(X,0x23). X = '#' .

# String
Strings are enclosed in dollar signs, similar to ARITY/PROLOG. However, they can be changed to double quotes using set_prolog_flag.

```
N-Prolog Ver 4.01
?- X = $hello$.
X = $hello$ .
yes
?- set_prolog_flag(string,iso).
yes
?- X = "hello".
X = "hello" .
yes
?- set_prolog_flag(string,arity).
yes
?- X = $hello$.
X = $hello$ .
yes
?- 

```


# Module
A module is generated by module/2. The first argument is the module name, and the second argument is a list of predicates and their arities to be exported. Each file corresponds to one module. Files are stored in the library folder, and the filename is the module name followed by the .pl extension. To invoke a module, use use_module/1. The argument is an atom representing the module name.Predicates other than those exported have the module name prefixed to them.Predicates within a module are not displayed by listing/0.

e.g. 

```
:- module(asdf,[bar/1]).

bar(X) :- boo(X).

boo(X) :- write(X).

save file to library as asdf.pl
       |
       v
use_module(asdf)
bar(X) :-
    asdf_boo(X).
asdf_boo(X) :-
    write(X).

```

It is also possible to compile the module. In this case, use_module/1 first looks for a file to be executed by the compiler. If not found, it will load the file to be executed by the interpreter.


# Function
In ARITY/PROLOG, the ^ symbol is used for exponentiation. However, since ** is used for exponentiation in ISO-Prolog, we allow this as well.

```
N-Prolog Ver 3.80
?- X is 2**3.
X = 8 .
yes
?- 
```

# My Personal Thoughts on ISO-Prolog
I believe ISO-Prolog has excessively high requirements. It sets overly detailed specifications regarding syntax and imposes high standards on op/3. The appeal of Prolog, in my opinion, lies in the astonishing realization that first-order predicate logic can be applied to programming. I think overly detailed syntax rules hinder the widespread adoption of Prolog. I would like to emphasize that this is my personal opinion.



# Extended 

## format(Str,Format,List).
If the first argument is a variable, the formatted string will be unified with the variable. The second argument is the format, which is a string. Values can be inserted into the string, and the values to be inserted are provided as a list in the third argument.

The variables for insertion are as follows:
- ~O  All of atomic.
- ~A atom
- ~S string
- ~D integer
- ~F float

## format(Stream,format,List).
If the first argument is a stream or alias, the edited string will be output to that stream. The specifications of the second and third arguments remain the same.

e.g.

```
?- format(user_output,$asdf$,[]).
asdfyes
?- format(X,$hello ~S !$,[$world$]).
X = $hello world !$ .
yes
?- format(X,$hello ~A !$,[world]).
X = $hello world !$ .
yes
?- 
?- format(X,$number ~D $,[1]).
X = $number 1 $ .
yes
?- format(X,$number ~F $,[1.1]).
X = $number 1.1 $ .
yes
?- format(X,$number ~O ~O $,[1.1,atom]).
X = $number 1.1 atom $ .
yes
```