package billing

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/billing/mgmt/2017-04-24-preview/billing"

// DownloadURL a secure URL that can be used to download a PDF invoice until the URL expires.
type DownloadURL struct {
	// ExpiryTime - READ-ONLY; The time in UTC at which this download URL will expire.
	ExpiryTime *date.Time `json:"expiryTime,omitempty"`
	// URL - READ-ONLY; The URL to the PDF file.
	URL *string `json:"url,omitempty"`
}

// MarshalJSON is the custom marshaler for DownloadURL.
func (du DownloadURL) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorDetails the details of the error.
type ErrorDetails struct {
	// Code - READ-ONLY; Error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; Error message indicating why the operation failed.
	Message *string `json:"message,omitempty"`
	// Target - READ-ONLY; The target of the particular error.
	Target *string `json:"target,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorDetails.
func (ed ErrorDetails) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// ErrorResponse error response indicates that the service is not able to process the incoming request. The
// reason is provided in the error message.
type ErrorResponse struct {
	// Error - The details of the error.
	Error *ErrorDetails `json:"error,omitempty"`
}

// Invoice an invoice resource can be used download a PDF version of an invoice.
type Invoice struct {
	autorest.Response  `json:"-"`
	*InvoiceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Invoice.
func (i Invoice) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if i.InvoiceProperties != nil {
		objectMap["properties"] = i.InvoiceProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Invoice struct.
func (i *Invoice) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var invoiceProperties InvoiceProperties
				err = json.Unmarshal(*v, &invoiceProperties)
				if err != nil {
					return err
				}
				i.InvoiceProperties = &invoiceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				i.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				i.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				i.Type = &typeVar
			}
		}
	}

	return nil
}

// InvoiceProperties the properties of the invoice.
type InvoiceProperties struct {
	// DownloadURL - A secure link to download the PDF version of an invoice. The link will cease to work after its expiry time is reached.
	DownloadURL *DownloadURL `json:"downloadUrl,omitempty"`
	// InvoicePeriodStartDate - READ-ONLY; The start of the date range covered by the invoice.
	InvoicePeriodStartDate *date.Date `json:"invoicePeriodStartDate,omitempty"`
	// InvoicePeriodEndDate - READ-ONLY; The end of the date range covered by the invoice.
	InvoicePeriodEndDate *date.Date `json:"invoicePeriodEndDate,omitempty"`
	// BillingPeriodIds - READ-ONLY; Array of billing period ids that the invoice is attributed to.
	BillingPeriodIds *[]string `json:"billingPeriodIds,omitempty"`
}

// MarshalJSON is the custom marshaler for InvoiceProperties.
func (IP InvoiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if IP.DownloadURL != nil {
		objectMap["downloadUrl"] = IP.DownloadURL
	}
	return json.Marshal(objectMap)
}

// InvoicesListResult result of listing invoices. It contains a list of available invoices in reverse
// chronological order.
type InvoicesListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of invoices.
	Value *[]Invoice `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for InvoicesListResult.
func (ilr InvoicesListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// InvoicesListResultIterator provides access to a complete listing of Invoice values.
type InvoicesListResultIterator struct {
	i    int
	page InvoicesListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *InvoicesListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoicesListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *InvoicesListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter InvoicesListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter InvoicesListResultIterator) Response() InvoicesListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter InvoicesListResultIterator) Value() Invoice {
	if !iter.page.NotDone() {
		return Invoice{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the InvoicesListResultIterator type.
func NewInvoicesListResultIterator(page InvoicesListResultPage) InvoicesListResultIterator {
	return InvoicesListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ilr InvoicesListResult) IsEmpty() bool {
	return ilr.Value == nil || len(*ilr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ilr InvoicesListResult) hasNextLink() bool {
	return ilr.NextLink != nil && len(*ilr.NextLink) != 0
}

// invoicesListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ilr InvoicesListResult) invoicesListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !ilr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ilr.NextLink)))
}

// InvoicesListResultPage contains a page of Invoice values.
type InvoicesListResultPage struct {
	fn  func(context.Context, InvoicesListResult) (InvoicesListResult, error)
	ilr InvoicesListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *InvoicesListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/InvoicesListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ilr)
		if err != nil {
			return err
		}
		page.ilr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *InvoicesListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page InvoicesListResultPage) NotDone() bool {
	return !page.ilr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page InvoicesListResultPage) Response() InvoicesListResult {
	return page.ilr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page InvoicesListResultPage) Values() []Invoice {
	if page.ilr.IsEmpty() {
		return nil
	}
	return *page.ilr.Value
}

// Creates a new instance of the InvoicesListResultPage type.
func NewInvoicesListResultPage(cur InvoicesListResult, getNextPage func(context.Context, InvoicesListResult) (InvoicesListResult, error)) InvoicesListResultPage {
	return InvoicesListResultPage{
		fn:  getNextPage,
		ilr: cur,
	}
}

// Operation a Billing REST API operation.
type Operation struct {
	// Name - READ-ONLY; Operation name: {provider}/{resource}/{operation}.
	Name *string `json:"name,omitempty"`
	// Display - The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`
}

// MarshalJSON is the custom marshaler for Operation.
func (o Operation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if o.Display != nil {
		objectMap["display"] = o.Display
	}
	return json.Marshal(objectMap)
}

// OperationDisplay the object that represents the operation.
type OperationDisplay struct {
	// Provider - READ-ONLY; Service provider: Microsoft.Billing.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; Resource on which the operation is performed: Invoice, etc.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; Operation type: Read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationDisplay.
func (o OperationDisplay) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResult result listing billing operations. It contains a list of operations and a URL link
// to get the next set of results.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; List of billing operations supported by the Microsoft.Billing resource provider.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - READ-ONLY; URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationListResult.
func (olr OperationListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// Period a billing period resource.
type Period struct {
	autorest.Response `json:"-"`
	*PeriodProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Period.
func (p Period) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.PeriodProperties != nil {
		objectMap["properties"] = p.PeriodProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Period struct.
func (p *Period) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var periodProperties PeriodProperties
				err = json.Unmarshal(*v, &periodProperties)
				if err != nil {
					return err
				}
				p.PeriodProperties = &periodProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				p.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				p.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				p.Type = &typeVar
			}
		}
	}

	return nil
}

// PeriodProperties the properties of the billing period.
type PeriodProperties struct {
	// BillingPeriodStartDate - READ-ONLY; The start of the date range covered by the billing period.
	BillingPeriodStartDate *date.Date `json:"billingPeriodStartDate,omitempty"`
	// BillingPeriodEndDate - READ-ONLY; The end of the date range covered by the billing period.
	BillingPeriodEndDate *date.Date `json:"billingPeriodEndDate,omitempty"`
	// InvoiceIds - READ-ONLY; Array of invoice ids that associated with.
	InvoiceIds *[]string `json:"invoiceIds,omitempty"`
}

// MarshalJSON is the custom marshaler for PeriodProperties.
func (pp PeriodProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PeriodsListResult result of listing billing periods. It contains a list of available billing periods in
// reverse chronological order.
type PeriodsListResult struct {
	autorest.Response `json:"-"`
	// Value - READ-ONLY; The list of billing periods.
	Value *[]Period `json:"value,omitempty"`
	// NextLink - READ-ONLY; The link (url) to the next page of results.
	NextLink *string `json:"nextLink,omitempty"`
}

// MarshalJSON is the custom marshaler for PeriodsListResult.
func (plr PeriodsListResult) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}

// PeriodsListResultIterator provides access to a complete listing of Period values.
type PeriodsListResultIterator struct {
	i    int
	page PeriodsListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PeriodsListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PeriodsListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PeriodsListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PeriodsListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PeriodsListResultIterator) Response() PeriodsListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PeriodsListResultIterator) Value() Period {
	if !iter.page.NotDone() {
		return Period{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PeriodsListResultIterator type.
func NewPeriodsListResultIterator(page PeriodsListResultPage) PeriodsListResultIterator {
	return PeriodsListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (plr PeriodsListResult) IsEmpty() bool {
	return plr.Value == nil || len(*plr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (plr PeriodsListResult) hasNextLink() bool {
	return plr.NextLink != nil && len(*plr.NextLink) != 0
}

// periodsListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (plr PeriodsListResult) periodsListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !plr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(plr.NextLink)))
}

// PeriodsListResultPage contains a page of Period values.
type PeriodsListResultPage struct {
	fn  func(context.Context, PeriodsListResult) (PeriodsListResult, error)
	plr PeriodsListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PeriodsListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PeriodsListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.plr)
		if err != nil {
			return err
		}
		page.plr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PeriodsListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PeriodsListResultPage) NotDone() bool {
	return !page.plr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PeriodsListResultPage) Response() PeriodsListResult {
	return page.plr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PeriodsListResultPage) Values() []Period {
	if page.plr.IsEmpty() {
		return nil
	}
	return *page.plr.Value
}

// Creates a new instance of the PeriodsListResultPage type.
func NewPeriodsListResultPage(cur PeriodsListResult, getNextPage func(context.Context, PeriodsListResult) (PeriodsListResult, error)) PeriodsListResultPage {
	return PeriodsListResultPage{
		fn:  getNextPage,
		plr: cur,
	}
}

// Resource the Resource model definition.
type Resource struct {
	// ID - READ-ONLY; Resource Id.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Resource name.
	Name *string `json:"name,omitempty"`
	// Type - READ-ONLY; Resource type.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	return json.Marshal(objectMap)
}
