package security

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// JitNetworkAccessPoliciesClient is the API spec for Microsoft.Security (Azure Security Center) resource provider
type JitNetworkAccessPoliciesClient struct {
	BaseClient
}

// NewJitNetworkAccessPoliciesClient creates an instance of the JitNetworkAccessPoliciesClient client.
func NewJitNetworkAccessPoliciesClient(subscriptionID string, ascLocation string) JitNetworkAccessPoliciesClient {
	return NewJitNetworkAccessPoliciesClientWithBaseURI(DefaultBaseURI, subscriptionID, ascLocation)
}

// NewJitNetworkAccessPoliciesClientWithBaseURI creates an instance of the JitNetworkAccessPoliciesClient client using
// a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign
// clouds, Azure stack).
func NewJitNetworkAccessPoliciesClientWithBaseURI(baseURI string, subscriptionID string, ascLocation string) JitNetworkAccessPoliciesClient {
	return JitNetworkAccessPoliciesClient{NewWithBaseURI(baseURI, subscriptionID, ascLocation)}
}

// CreateOrUpdate create a policy for protecting resources using Just-in-Time access control
// Parameters:
// resourceGroupName - the name of the resource group within the user's subscription. The name is case
// insensitive.
// jitNetworkAccessPolicyName - name of a Just-in-Time access configuration policy.
func (client JitNetworkAccessPoliciesClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, jitNetworkAccessPolicyName string, body JitNetworkAccessPolicy) (result JitNetworkAccessPolicy, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: body,
			Constraints: []validation.Constraint{{Target: "body.JitNetworkAccessPolicyProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "body.JitNetworkAccessPolicyProperties.VirtualMachines", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("security.JitNetworkAccessPoliciesClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, jitNetworkAccessPolicyName, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "CreateOrUpdate", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client JitNetworkAccessPoliciesClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, jitNetworkAccessPolicyName string, body JitNetworkAccessPolicy) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"ascLocation":                autorest.Encode("path", client.AscLocation),
		"jitNetworkAccessPolicyName": autorest.Encode("path", jitNetworkAccessPolicyName),
		"resourceGroupName":          autorest.Encode("path", resourceGroupName),
		"subscriptionId":             autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	body.ID = nil
	body.Name = nil
	body.Type = nil
	body.Location = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies/{jitNetworkAccessPolicyName}", pathParameters),
		autorest.WithJSON(body),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client JitNetworkAccessPoliciesClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client JitNetworkAccessPoliciesClient) CreateOrUpdateResponder(resp *http.Response) (result JitNetworkAccessPolicy, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete a Just-in-Time access control policy.
// Parameters:
// resourceGroupName - the name of the resource group within the user's subscription. The name is case
// insensitive.
// jitNetworkAccessPolicyName - name of a Just-in-Time access configuration policy.
func (client JitNetworkAccessPoliciesClient) Delete(ctx context.Context, resourceGroupName string, jitNetworkAccessPolicyName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.JitNetworkAccessPoliciesClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceGroupName, jitNetworkAccessPolicyName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "Delete", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client JitNetworkAccessPoliciesClient) DeletePreparer(ctx context.Context, resourceGroupName string, jitNetworkAccessPolicyName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"ascLocation":                autorest.Encode("path", client.AscLocation),
		"jitNetworkAccessPolicyName": autorest.Encode("path", jitNetworkAccessPolicyName),
		"resourceGroupName":          autorest.Encode("path", resourceGroupName),
		"subscriptionId":             autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies/{jitNetworkAccessPolicyName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client JitNetworkAccessPoliciesClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client JitNetworkAccessPoliciesClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get policies for protecting resources using Just-in-Time access control for the subscription, location
// Parameters:
// resourceGroupName - the name of the resource group within the user's subscription. The name is case
// insensitive.
// jitNetworkAccessPolicyName - name of a Just-in-Time access configuration policy.
func (client JitNetworkAccessPoliciesClient) Get(ctx context.Context, resourceGroupName string, jitNetworkAccessPolicyName string) (result JitNetworkAccessPolicy, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.JitNetworkAccessPoliciesClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, jitNetworkAccessPolicyName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client JitNetworkAccessPoliciesClient) GetPreparer(ctx context.Context, resourceGroupName string, jitNetworkAccessPolicyName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"ascLocation":                autorest.Encode("path", client.AscLocation),
		"jitNetworkAccessPolicyName": autorest.Encode("path", jitNetworkAccessPolicyName),
		"resourceGroupName":          autorest.Encode("path", resourceGroupName),
		"subscriptionId":             autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies/{jitNetworkAccessPolicyName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client JitNetworkAccessPoliciesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client JitNetworkAccessPoliciesClient) GetResponder(resp *http.Response) (result JitNetworkAccessPolicy, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Initiate initiate a JIT access from a specific Just-in-Time policy configuration.
// Parameters:
// resourceGroupName - the name of the resource group within the user's subscription. The name is case
// insensitive.
// jitNetworkAccessPolicyName - name of a Just-in-Time access configuration policy.
func (client JitNetworkAccessPoliciesClient) Initiate(ctx context.Context, resourceGroupName string, jitNetworkAccessPolicyName string, body JitNetworkAccessPolicyInitiateRequest) (result JitNetworkAccessRequest, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesClient.Initiate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}},
		{TargetValue: body,
			Constraints: []validation.Constraint{{Target: "body.VirtualMachines", Name: validation.Null, Rule: true, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.JitNetworkAccessPoliciesClient", "Initiate", err.Error())
	}

	req, err := client.InitiatePreparer(ctx, resourceGroupName, jitNetworkAccessPolicyName, body)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "Initiate", nil, "Failure preparing request")
		return
	}

	resp, err := client.InitiateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "Initiate", resp, "Failure sending request")
		return
	}

	result, err = client.InitiateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "Initiate", resp, "Failure responding to request")
		return
	}

	return
}

// InitiatePreparer prepares the Initiate request.
func (client JitNetworkAccessPoliciesClient) InitiatePreparer(ctx context.Context, resourceGroupName string, jitNetworkAccessPolicyName string, body JitNetworkAccessPolicyInitiateRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"ascLocation":                        autorest.Encode("path", client.AscLocation),
		"jitNetworkAccessPolicyInitiateType": autorest.Encode("path", "initiate"),
		"jitNetworkAccessPolicyName":         autorest.Encode("path", jitNetworkAccessPolicyName),
		"resourceGroupName":                  autorest.Encode("path", resourceGroupName),
		"subscriptionId":                     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies/{jitNetworkAccessPolicyName}/{jitNetworkAccessPolicyInitiateType}", pathParameters),
		autorest.WithJSON(body),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// InitiateSender sends the Initiate request. The method will close the
// http.Response Body if it receives an error.
func (client JitNetworkAccessPoliciesClient) InitiateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// InitiateResponder handles the response to the Initiate request. The method always
// closes the http.Response Body.
func (client JitNetworkAccessPoliciesClient) InitiateResponder(resp *http.Response) (result JitNetworkAccessRequest, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List policies for protecting resources using Just-in-Time access control.
func (client JitNetworkAccessPoliciesClient) List(ctx context.Context) (result JitNetworkAccessPoliciesListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesClient.List")
		defer func() {
			sc := -1
			if result.jnapl.Response.Response != nil {
				sc = result.jnapl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.JitNetworkAccessPoliciesClient", "List", err.Error())
	}

	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.jnapl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "List", resp, "Failure sending request")
		return
	}

	result.jnapl, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "List", resp, "Failure responding to request")
		return
	}
	if result.jnapl.hasNextLink() && result.jnapl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client JitNetworkAccessPoliciesClient) ListPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Security/jitNetworkAccessPolicies", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client JitNetworkAccessPoliciesClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client JitNetworkAccessPoliciesClient) ListResponder(resp *http.Response) (result JitNetworkAccessPoliciesList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client JitNetworkAccessPoliciesClient) listNextResults(ctx context.Context, lastResults JitNetworkAccessPoliciesList) (result JitNetworkAccessPoliciesList, err error) {
	req, err := lastResults.jitNetworkAccessPoliciesListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client JitNetworkAccessPoliciesClient) ListComplete(ctx context.Context) (result JitNetworkAccessPoliciesListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx)
	return
}

// ListByRegion policies for protecting resources using Just-in-Time access control for the subscription, location
func (client JitNetworkAccessPoliciesClient) ListByRegion(ctx context.Context) (result JitNetworkAccessPoliciesListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesClient.ListByRegion")
		defer func() {
			sc := -1
			if result.jnapl.Response.Response != nil {
				sc = result.jnapl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.JitNetworkAccessPoliciesClient", "ListByRegion", err.Error())
	}

	result.fn = client.listByRegionNextResults
	req, err := client.ListByRegionPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "ListByRegion", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByRegionSender(req)
	if err != nil {
		result.jnapl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "ListByRegion", resp, "Failure sending request")
		return
	}

	result.jnapl, err = client.ListByRegionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "ListByRegion", resp, "Failure responding to request")
		return
	}
	if result.jnapl.hasNextLink() && result.jnapl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByRegionPreparer prepares the ListByRegion request.
func (client JitNetworkAccessPoliciesClient) ListByRegionPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"ascLocation":    autorest.Encode("path", client.AscLocation),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByRegionSender sends the ListByRegion request. The method will close the
// http.Response Body if it receives an error.
func (client JitNetworkAccessPoliciesClient) ListByRegionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByRegionResponder handles the response to the ListByRegion request. The method always
// closes the http.Response Body.
func (client JitNetworkAccessPoliciesClient) ListByRegionResponder(resp *http.Response) (result JitNetworkAccessPoliciesList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByRegionNextResults retrieves the next set of results, if any.
func (client JitNetworkAccessPoliciesClient) listByRegionNextResults(ctx context.Context, lastResults JitNetworkAccessPoliciesList) (result JitNetworkAccessPoliciesList, err error) {
	req, err := lastResults.jitNetworkAccessPoliciesListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "listByRegionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByRegionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "listByRegionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByRegionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "listByRegionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByRegionComplete enumerates all values, automatically crossing page boundaries as required.
func (client JitNetworkAccessPoliciesClient) ListByRegionComplete(ctx context.Context) (result JitNetworkAccessPoliciesListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesClient.ListByRegion")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByRegion(ctx)
	return
}

// ListByResourceGroup policies for protecting resources using Just-in-Time access control for the subscription,
// location
// Parameters:
// resourceGroupName - the name of the resource group within the user's subscription. The name is case
// insensitive.
func (client JitNetworkAccessPoliciesClient) ListByResourceGroup(ctx context.Context, resourceGroupName string) (result JitNetworkAccessPoliciesListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.jnapl.Response.Response != nil {
				sc = result.jnapl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.JitNetworkAccessPoliciesClient", "ListByResourceGroup", err.Error())
	}

	result.fn = client.listByResourceGroupNextResults
	req, err := client.ListByResourceGroupPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "ListByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.jnapl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "ListByResourceGroup", resp, "Failure sending request")
		return
	}

	result.jnapl, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "ListByResourceGroup", resp, "Failure responding to request")
		return
	}
	if result.jnapl.hasNextLink() && result.jnapl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client JitNetworkAccessPoliciesClient) ListByResourceGroupPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/jitNetworkAccessPolicies", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client JitNetworkAccessPoliciesClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client JitNetworkAccessPoliciesClient) ListByResourceGroupResponder(resp *http.Response) (result JitNetworkAccessPoliciesList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupNextResults retrieves the next set of results, if any.
func (client JitNetworkAccessPoliciesClient) listByResourceGroupNextResults(ctx context.Context, lastResults JitNetworkAccessPoliciesList) (result JitNetworkAccessPoliciesList, err error) {
	req, err := lastResults.jitNetworkAccessPoliciesListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "listByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "listByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "listByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client JitNetworkAccessPoliciesClient) ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result JitNetworkAccessPoliciesListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesClient.ListByResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroup(ctx, resourceGroupName)
	return
}

// ListByResourceGroupAndRegion policies for protecting resources using Just-in-Time access control for the
// subscription, location
// Parameters:
// resourceGroupName - the name of the resource group within the user's subscription. The name is case
// insensitive.
func (client JitNetworkAccessPoliciesClient) ListByResourceGroupAndRegion(ctx context.Context, resourceGroupName string) (result JitNetworkAccessPoliciesListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesClient.ListByResourceGroupAndRegion")
		defer func() {
			sc := -1
			if result.jnapl.Response.Response != nil {
				sc = result.jnapl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: client.SubscriptionID,
			Constraints: []validation.Constraint{{Target: "client.SubscriptionID", Name: validation.Pattern, Rule: `^[0-9A-Fa-f]{8}-([0-9A-Fa-f]{4}-){3}[0-9A-Fa-f]{12}$`, Chain: nil}}},
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("security.JitNetworkAccessPoliciesClient", "ListByResourceGroupAndRegion", err.Error())
	}

	result.fn = client.listByResourceGroupAndRegionNextResults
	req, err := client.ListByResourceGroupAndRegionPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "ListByResourceGroupAndRegion", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceGroupAndRegionSender(req)
	if err != nil {
		result.jnapl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "ListByResourceGroupAndRegion", resp, "Failure sending request")
		return
	}

	result.jnapl, err = client.ListByResourceGroupAndRegionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "ListByResourceGroupAndRegion", resp, "Failure responding to request")
		return
	}
	if result.jnapl.hasNextLink() && result.jnapl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByResourceGroupAndRegionPreparer prepares the ListByResourceGroupAndRegion request.
func (client JitNetworkAccessPoliciesClient) ListByResourceGroupAndRegionPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"ascLocation":       autorest.Encode("path", client.AscLocation),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-01-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Security/locations/{ascLocation}/jitNetworkAccessPolicies", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceGroupAndRegionSender sends the ListByResourceGroupAndRegion request. The method will close the
// http.Response Body if it receives an error.
func (client JitNetworkAccessPoliciesClient) ListByResourceGroupAndRegionSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceGroupAndRegionResponder handles the response to the ListByResourceGroupAndRegion request. The method always
// closes the http.Response Body.
func (client JitNetworkAccessPoliciesClient) ListByResourceGroupAndRegionResponder(resp *http.Response) (result JitNetworkAccessPoliciesList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceGroupAndRegionNextResults retrieves the next set of results, if any.
func (client JitNetworkAccessPoliciesClient) listByResourceGroupAndRegionNextResults(ctx context.Context, lastResults JitNetworkAccessPoliciesList) (result JitNetworkAccessPoliciesList, err error) {
	req, err := lastResults.jitNetworkAccessPoliciesListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "listByResourceGroupAndRegionNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceGroupAndRegionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "listByResourceGroupAndRegionNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceGroupAndRegionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "security.JitNetworkAccessPoliciesClient", "listByResourceGroupAndRegionNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceGroupAndRegionComplete enumerates all values, automatically crossing page boundaries as required.
func (client JitNetworkAccessPoliciesClient) ListByResourceGroupAndRegionComplete(ctx context.Context, resourceGroupName string) (result JitNetworkAccessPoliciesListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JitNetworkAccessPoliciesClient.ListByResourceGroupAndRegion")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResourceGroupAndRegion(ctx, resourceGroupName)
	return
}
