package sql

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// OperationsHealthClient is the the Azure SQL Database management API provides a RESTful set of web services that
// interact with Azure SQL Database services to manage your databases. The API enables you to create, retrieve, update,
// and delete databases.
type OperationsHealthClient struct {
	BaseClient
}

// NewOperationsHealthClient creates an instance of the OperationsHealthClient client.
func NewOperationsHealthClient(subscriptionID string) OperationsHealthClient {
	return NewOperationsHealthClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewOperationsHealthClientWithBaseURI creates an instance of the OperationsHealthClient client using a custom
// endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure
// stack).
func NewOperationsHealthClientWithBaseURI(baseURI string, subscriptionID string) OperationsHealthClient {
	return OperationsHealthClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// ListByLocation gets a service operation health status.
// Parameters:
// locationName - the name of the region where the resource is located.
func (client OperationsHealthClient) ListByLocation(ctx context.Context, locationName string) (result OperationsHealthListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsHealthClient.ListByLocation")
		defer func() {
			sc := -1
			if result.ohlr.Response.Response != nil {
				sc = result.ohlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByLocationNextResults
	req, err := client.ListByLocationPreparer(ctx, locationName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.OperationsHealthClient", "ListByLocation", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByLocationSender(req)
	if err != nil {
		result.ohlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.OperationsHealthClient", "ListByLocation", resp, "Failure sending request")
		return
	}

	result.ohlr, err = client.ListByLocationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.OperationsHealthClient", "ListByLocation", resp, "Failure responding to request")
		return
	}
	if result.ohlr.hasNextLink() && result.ohlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByLocationPreparer prepares the ListByLocation request.
func (client OperationsHealthClient) ListByLocationPreparer(ctx context.Context, locationName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"locationName":   autorest.Encode("path", locationName),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2020-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Sql/locations/{locationName}/operationsHealth", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByLocationSender sends the ListByLocation request. The method will close the
// http.Response Body if it receives an error.
func (client OperationsHealthClient) ListByLocationSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByLocationResponder handles the response to the ListByLocation request. The method always
// closes the http.Response Body.
func (client OperationsHealthClient) ListByLocationResponder(resp *http.Response) (result OperationsHealthListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByLocationNextResults retrieves the next set of results, if any.
func (client OperationsHealthClient) listByLocationNextResults(ctx context.Context, lastResults OperationsHealthListResult) (result OperationsHealthListResult, err error) {
	req, err := lastResults.operationsHealthListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "sql.OperationsHealthClient", "listByLocationNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByLocationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "sql.OperationsHealthClient", "listByLocationNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByLocationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.OperationsHealthClient", "listByLocationNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByLocationComplete enumerates all values, automatically crossing page boundaries as required.
func (client OperationsHealthClient) ListByLocationComplete(ctx context.Context, locationName string) (result OperationsHealthListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationsHealthClient.ListByLocation")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByLocation(ctx, locationName)
	return
}
