package backup

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// EnginesClient is the open API 2.0 Specs for Azure RecoveryServices Backup service
type EnginesClient struct {
	BaseClient
}

// NewEnginesClient creates an instance of the EnginesClient client.
func NewEnginesClient(subscriptionID string) EnginesClient {
	return NewEnginesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewEnginesClientWithBaseURI creates an instance of the EnginesClient client using a custom endpoint.  Use this when
// interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewEnginesClientWithBaseURI(baseURI string, subscriptionID string) EnginesClient {
	return EnginesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get the backup management servers registered to a Recovery Services vault. This returns a pageable list of servers.
// Parameters:
// vaultName - the name of the Recovery Services vault.
// resourceGroupName - the name of the resource group associated with the Recovery Services vault.
// filter - use this filter to choose the specific backup management server. backupManagementType {
// AzureIaasVM, MAB, DPM, AzureBackupServer, AzureSql }.
// skipToken - the Skip Token filter.
func (client EnginesClient) Get(ctx context.Context, vaultName string, resourceGroupName string, filter string, skipToken string) (result EngineBaseResourceListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EnginesClient.Get")
		defer func() {
			sc := -1
			if result.ebrl.Response.Response != nil {
				sc = result.ebrl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getNextResults
	req, err := client.GetPreparer(ctx, vaultName, resourceGroupName, filter, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "backup.EnginesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.ebrl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "backup.EnginesClient", "Get", resp, "Failure sending request")
		return
	}

	result.ebrl, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "backup.EnginesClient", "Get", resp, "Failure responding to request")
		return
	}
	if result.ebrl.hasNextLink() && result.ebrl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client EnginesClient) GetPreparer(ctx context.Context, vaultName string, resourceGroupName string, filter string, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vaultName":         autorest.Encode("path", vaultName),
	}

	const APIVersion = "2016-06-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/Subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupEngines", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client EnginesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client EnginesClient) GetResponder(resp *http.Response) (result EngineBaseResourceList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getNextResults retrieves the next set of results, if any.
func (client EnginesClient) getNextResults(ctx context.Context, lastResults EngineBaseResourceList) (result EngineBaseResourceList, err error) {
	req, err := lastResults.engineBaseResourceListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "backup.EnginesClient", "getNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "backup.EnginesClient", "getNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "backup.EnginesClient", "getNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetComplete enumerates all values, automatically crossing page boundaries as required.
func (client EnginesClient) GetComplete(ctx context.Context, vaultName string, resourceGroupName string, filter string, skipToken string) (result EngineBaseResourceListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EnginesClient.Get")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.Get(ctx, vaultName, resourceGroupName, filter, skipToken)
	return
}
