package storagepoolapi

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/storagepool/mgmt/2021-08-01/storagepool"
)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result storagepool.OperationListResult, err error)
}

var _ OperationsClientAPI = (*storagepool.OperationsClient)(nil)

// DiskPoolsClientAPI contains the set of methods on the DiskPoolsClient type.
type DiskPoolsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, diskPoolName string, diskPoolCreatePayload storagepool.DiskPoolCreate) (result storagepool.DiskPoolsCreateOrUpdateFuture, err error)
	Deallocate(ctx context.Context, resourceGroupName string, diskPoolName string) (result storagepool.DiskPoolsDeallocateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, diskPoolName string) (result storagepool.DiskPoolsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, diskPoolName string) (result storagepool.DiskPool, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result storagepool.DiskPoolListResultPage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result storagepool.DiskPoolListResultIterator, err error)
	ListBySubscription(ctx context.Context) (result storagepool.DiskPoolListResultPage, err error)
	ListBySubscriptionComplete(ctx context.Context) (result storagepool.DiskPoolListResultIterator, err error)
	ListOutboundNetworkDependenciesEndpoints(ctx context.Context, resourceGroupName string, diskPoolName string) (result storagepool.OutboundEnvironmentEndpointListPage, err error)
	ListOutboundNetworkDependenciesEndpointsComplete(ctx context.Context, resourceGroupName string, diskPoolName string) (result storagepool.OutboundEnvironmentEndpointListIterator, err error)
	Start(ctx context.Context, resourceGroupName string, diskPoolName string) (result storagepool.DiskPoolsStartFuture, err error)
	Update(ctx context.Context, resourceGroupName string, diskPoolName string, diskPoolUpdatePayload storagepool.DiskPoolUpdate) (result storagepool.DiskPoolsUpdateFuture, err error)
	Upgrade(ctx context.Context, resourceGroupName string, diskPoolName string) (result storagepool.DiskPoolsUpgradeFuture, err error)
}

var _ DiskPoolsClientAPI = (*storagepool.DiskPoolsClient)(nil)

// DiskPoolZonesClientAPI contains the set of methods on the DiskPoolZonesClient type.
type DiskPoolZonesClientAPI interface {
	List(ctx context.Context, location string) (result storagepool.DiskPoolZoneListResultPage, err error)
	ListComplete(ctx context.Context, location string) (result storagepool.DiskPoolZoneListResultIterator, err error)
}

var _ DiskPoolZonesClientAPI = (*storagepool.DiskPoolZonesClient)(nil)

// ResourceSkusClientAPI contains the set of methods on the ResourceSkusClient type.
type ResourceSkusClientAPI interface {
	List(ctx context.Context, location string) (result storagepool.ResourceSkuListResultPage, err error)
	ListComplete(ctx context.Context, location string) (result storagepool.ResourceSkuListResultIterator, err error)
}

var _ ResourceSkusClientAPI = (*storagepool.ResourceSkusClient)(nil)

// IscsiTargetsClientAPI contains the set of methods on the IscsiTargetsClient type.
type IscsiTargetsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, diskPoolName string, iscsiTargetName string, iscsiTargetCreatePayload storagepool.IscsiTargetCreate) (result storagepool.IscsiTargetsCreateOrUpdateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, diskPoolName string, iscsiTargetName string) (result storagepool.IscsiTargetsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, diskPoolName string, iscsiTargetName string) (result storagepool.IscsiTarget, err error)
	ListByDiskPool(ctx context.Context, resourceGroupName string, diskPoolName string) (result storagepool.IscsiTargetListPage, err error)
	ListByDiskPoolComplete(ctx context.Context, resourceGroupName string, diskPoolName string) (result storagepool.IscsiTargetListIterator, err error)
	Update(ctx context.Context, resourceGroupName string, diskPoolName string, iscsiTargetName string, iscsiTargetUpdatePayload storagepool.IscsiTargetUpdate) (result storagepool.IscsiTargetsUpdateFuture, err error)
}

var _ IscsiTargetsClientAPI = (*storagepool.IscsiTargetsClient)(nil)
