package actiontrail

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDeliveryHistoryJobs invokes the actiontrail.ListDeliveryHistoryJobs API synchronously
func (client *Client) ListDeliveryHistoryJobs(request *ListDeliveryHistoryJobsRequest) (response *ListDeliveryHistoryJobsResponse, err error) {
	response = CreateListDeliveryHistoryJobsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDeliveryHistoryJobsWithChan invokes the actiontrail.ListDeliveryHistoryJobs API asynchronously
func (client *Client) ListDeliveryHistoryJobsWithChan(request *ListDeliveryHistoryJobsRequest) (<-chan *ListDeliveryHistoryJobsResponse, <-chan error) {
	responseChan := make(chan *ListDeliveryHistoryJobsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDeliveryHistoryJobs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDeliveryHistoryJobsWithCallback invokes the actiontrail.ListDeliveryHistoryJobs API asynchronously
func (client *Client) ListDeliveryHistoryJobsWithCallback(request *ListDeliveryHistoryJobsRequest, callback func(response *ListDeliveryHistoryJobsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDeliveryHistoryJobsResponse
		var err error
		defer close(result)
		response, err = client.ListDeliveryHistoryJobs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDeliveryHistoryJobsRequest is the request struct for api ListDeliveryHistoryJobs
type ListDeliveryHistoryJobsRequest struct {
	*requests.RpcRequest
	PageNumber requests.Integer `position:"Query" name:"PageNumber"`
	PageSize   requests.Integer `position:"Query" name:"PageSize"`
}

// ListDeliveryHistoryJobsResponse is the response struct for api ListDeliveryHistoryJobs
type ListDeliveryHistoryJobsResponse struct {
	*responses.BaseResponse
	RequestId           string               `json:"RequestId" xml:"RequestId"`
	TotalCount          int                  `json:"TotalCount" xml:"TotalCount"`
	PageNumber          int                  `json:"PageNumber" xml:"PageNumber"`
	PageSize            int                  `json:"PageSize" xml:"PageSize"`
	DeliveryHistoryJobs []DeliveryHistoryJob `json:"DeliveryHistoryJobs" xml:"DeliveryHistoryJobs"`
}

// CreateListDeliveryHistoryJobsRequest creates a request to invoke ListDeliveryHistoryJobs API
func CreateListDeliveryHistoryJobsRequest() (request *ListDeliveryHistoryJobsRequest) {
	request = &ListDeliveryHistoryJobsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Actiontrail", "2020-07-06", "ListDeliveryHistoryJobs", "actiontrail", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListDeliveryHistoryJobsResponse creates a response to parse from ListDeliveryHistoryJobs response
func CreateListDeliveryHistoryJobsResponse() (response *ListDeliveryHistoryJobsResponse) {
	response = &ListDeliveryHistoryJobsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
