package address_purification

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CorrectAddress invokes the address_purification.CorrectAddress API synchronously
func (client *Client) CorrectAddress(request *CorrectAddressRequest) (response *CorrectAddressResponse, err error) {
	response = CreateCorrectAddressResponse()
	err = client.DoAction(request, response)
	return
}

// CorrectAddressWithChan invokes the address_purification.CorrectAddress API asynchronously
func (client *Client) CorrectAddressWithChan(request *CorrectAddressRequest) (<-chan *CorrectAddressResponse, <-chan error) {
	responseChan := make(chan *CorrectAddressResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CorrectAddress(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CorrectAddressWithCallback invokes the address_purification.CorrectAddress API asynchronously
func (client *Client) CorrectAddressWithCallback(request *CorrectAddressRequest, callback func(response *CorrectAddressResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CorrectAddressResponse
		var err error
		defer close(result)
		response, err = client.CorrectAddress(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CorrectAddressRequest is the request struct for api CorrectAddress
type CorrectAddressRequest struct {
	*requests.RpcRequest
	DefaultProvince string `position:"Body" name:"DefaultProvince"`
	ServiceCode     string `position:"Body" name:"ServiceCode"`
	DefaultCity     string `position:"Body" name:"DefaultCity"`
	DefaultDistrict string `position:"Body" name:"DefaultDistrict"`
	AppKey          string `position:"Body" name:"AppKey"`
	Text            string `position:"Body" name:"Text"`
}

// CorrectAddressResponse is the response struct for api CorrectAddress
type CorrectAddressResponse struct {
	*responses.BaseResponse
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCorrectAddressRequest creates a request to invoke CorrectAddress API
func CreateCorrectAddressRequest() (request *CorrectAddressRequest) {
	request = &CorrectAddressRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("address-purification", "2019-11-18", "CorrectAddress", "addrp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCorrectAddressResponse creates a response to parse from CorrectAddress response
func CreateCorrectAddressResponse() (response *CorrectAddressResponse) {
	response = &CorrectAddressResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
