package address_purification

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAddressSearch invokes the address_purification.GetAddressSearch API synchronously
func (client *Client) GetAddressSearch(request *GetAddressSearchRequest) (response *GetAddressSearchResponse, err error) {
	response = CreateGetAddressSearchResponse()
	err = client.DoAction(request, response)
	return
}

// GetAddressSearchWithChan invokes the address_purification.GetAddressSearch API asynchronously
func (client *Client) GetAddressSearchWithChan(request *GetAddressSearchRequest) (<-chan *GetAddressSearchResponse, <-chan error) {
	responseChan := make(chan *GetAddressSearchResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAddressSearch(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAddressSearchWithCallback invokes the address_purification.GetAddressSearch API asynchronously
func (client *Client) GetAddressSearchWithCallback(request *GetAddressSearchRequest, callback func(response *GetAddressSearchResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAddressSearchResponse
		var err error
		defer close(result)
		response, err = client.GetAddressSearch(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAddressSearchRequest is the request struct for api GetAddressSearch
type GetAddressSearchRequest struct {
	*requests.RpcRequest
	DefaultProvince string `position:"Body" name:"DefaultProvince"`
	ServiceCode     string `position:"Body" name:"ServiceCode"`
	DefaultCity     string `position:"Body" name:"DefaultCity"`
	DefaultDistrict string `position:"Body" name:"DefaultDistrict"`
	AppKey          string `position:"Body" name:"AppKey"`
	Text            string `position:"Body" name:"Text"`
}

// GetAddressSearchResponse is the response struct for api GetAddressSearch
type GetAddressSearchResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateGetAddressSearchRequest creates a request to invoke GetAddressSearch API
func CreateGetAddressSearchRequest() (request *GetAddressSearchRequest) {
	request = &GetAddressSearchRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("address-purification", "2019-11-18", "GetAddressSearch", "addrp", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAddressSearchResponse creates a response to parse from GetAddressSearch response
func CreateGetAddressSearchResponse() (response *GetAddressSearchResponse) {
	response = &GetAddressSearchResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
