package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeLogItems invokes the aegis.DescribeLogItems API synchronously
// api document: https://help.aliyun.com/api/aegis/describelogitems.html
func (client *Client) DescribeLogItems(request *DescribeLogItemsRequest) (response *DescribeLogItemsResponse, err error) {
	response = CreateDescribeLogItemsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeLogItemsWithChan invokes the aegis.DescribeLogItems API asynchronously
// api document: https://help.aliyun.com/api/aegis/describelogitems.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLogItemsWithChan(request *DescribeLogItemsRequest) (<-chan *DescribeLogItemsResponse, <-chan error) {
	responseChan := make(chan *DescribeLogItemsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeLogItems(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeLogItemsWithCallback invokes the aegis.DescribeLogItems API asynchronously
// api document: https://help.aliyun.com/api/aegis/describelogitems.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeLogItemsWithCallback(request *DescribeLogItemsRequest, callback func(response *DescribeLogItemsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeLogItemsResponse
		var err error
		defer close(result)
		response, err = client.DescribeLogItems(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeLogItemsRequest is the request struct for api DescribeLogItems
type DescribeLogItemsRequest struct {
	*requests.RpcRequest
	LoginOffset           requests.Integer `position:"Query" name:"LoginOffset"`
	ProcessSnapshotOffset requests.Integer `position:"Query" name:"ProcessSnapshotOffset"`
	PortSnapshotOffset    requests.Integer `position:"Query" name:"PortSnapshotOffset"`
	Query                 string           `position:"Query" name:"Query"`
	EndTime               string           `position:"Query" name:"EndTime"`
	CurrentPage           string           `position:"Query" name:"CurrentPage"`
	NetworkOffset         requests.Integer `position:"Query" name:"NetworkOffset"`
	StartTime             string           `position:"Query" name:"StartTime"`
	AccountSnapshotOffset requests.Integer `position:"Query" name:"AccountSnapshotOffset"`
	ProcessOffset         requests.Integer `position:"Query" name:"ProcessOffset"`
	SourceIp              string           `position:"Query" name:"SourceIp"`
	CrackOffset           requests.Integer `position:"Query" name:"CrackOffset"`
	PageSize              string           `position:"Query" name:"PageSize"`
}

// DescribeLogItemsResponse is the response struct for api DescribeLogItems
type DescribeLogItemsResponse struct {
	*responses.BaseResponse
	RequestId                 string         `json:"RequestId" xml:"RequestId"`
	TotalCount                int            `json:"TotalCount" xml:"TotalCount"`
	CrackTotalCount           int            `json:"CrackTotalCount" xml:"CrackTotalCount"`
	SetPageSize               int            `json:"SetPageSize" xml:"SetPageSize"`
	ProcessOffset             int            `json:"ProcessOffset" xml:"ProcessOffset"`
	NetworkOffset             int            `json:"NetworkOffset" xml:"NetworkOffset"`
	PortSnapshotOffset        int            `json:"PortSnapshotOffset" xml:"PortSnapshotOffset"`
	ProcessSnapshotTotalCount int            `json:"ProcessSnapshotTotalCount" xml:"ProcessSnapshotTotalCount"`
	CrackOffset               int            `json:"CrackOffset" xml:"CrackOffset"`
	NetworkTotalCount         int            `json:"NetworkTotalCount" xml:"NetworkTotalCount"`
	PortSnapshotTotalCount    int            `json:"PortSnapshotTotalCount" xml:"PortSnapshotTotalCount"`
	ProcessSnapshotOffset     int            `json:"ProcessSnapshotOffset" xml:"ProcessSnapshotOffset"`
	ProcessTotalCount         int            `json:"ProcessTotalCount" xml:"ProcessTotalCount"`
	LoginTotalCount           int            `json:"LoginTotalCount" xml:"LoginTotalCount"`
	CurrentPage               int            `json:"CurrentPage" xml:"CurrentPage"`
	AccountSnapshotOffset     int            `json:"AccountSnapshotOffset" xml:"AccountSnapshotOffset"`
	AccountSnapshotTotalCount int            `json:"AccountSnapshotTotalCount" xml:"AccountSnapshotTotalCount"`
	LogsList                  []LogsListItem `json:"LogsList" xml:"LogsList"`
}

// CreateDescribeLogItemsRequest creates a request to invoke DescribeLogItems API
func CreateDescribeLogItemsRequest() (request *DescribeLogItemsRequest) {
	request = &DescribeLogItemsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeLogItems", "vipaegis", "openAPI")
	return
}

// CreateDescribeLogItemsResponse creates a response to parse from DescribeLogItems response
func CreateDescribeLogItemsResponse() (response *DescribeLogItemsResponse) {
	response = &DescribeLogItemsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
