package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVulNumStatistics invokes the aegis.DescribeVulNumStatistics API synchronously
// api document: https://help.aliyun.com/api/aegis/describevulnumstatistics.html
func (client *Client) DescribeVulNumStatistics(request *DescribeVulNumStatisticsRequest) (response *DescribeVulNumStatisticsResponse, err error) {
	response = CreateDescribeVulNumStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVulNumStatisticsWithChan invokes the aegis.DescribeVulNumStatistics API asynchronously
// api document: https://help.aliyun.com/api/aegis/describevulnumstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVulNumStatisticsWithChan(request *DescribeVulNumStatisticsRequest) (<-chan *DescribeVulNumStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeVulNumStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVulNumStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVulNumStatisticsWithCallback invokes the aegis.DescribeVulNumStatistics API asynchronously
// api document: https://help.aliyun.com/api/aegis/describevulnumstatistics.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVulNumStatisticsWithCallback(request *DescribeVulNumStatisticsRequest, callback func(response *DescribeVulNumStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVulNumStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeVulNumStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVulNumStatisticsRequest is the request struct for api DescribeVulNumStatistics
type DescribeVulNumStatisticsRequest struct {
	*requests.RpcRequest
	SourceIp      string           `position:"Query" name:"SourceIp"`
	EndTs         requests.Integer `position:"Query" name:"EndTs"`
	StartTs       requests.Integer `position:"Query" name:"StartTs"`
	CreateTsEnd   requests.Integer `position:"Query" name:"CreateTsEnd"`
	CreateTsStart requests.Integer `position:"Query" name:"CreateTsStart"`
	Uuids         string           `position:"Query" name:"Uuids"`
}

// DescribeVulNumStatisticsResponse is the response struct for api DescribeVulNumStatistics
type DescribeVulNumStatisticsResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	CveNum            int    `json:"CveNum" xml:"CveNum"`
	EmgNum            int    `json:"EmgNum" xml:"EmgNum"`
	SysNum            int    `json:"SysNum" xml:"SysNum"`
	CmsNum            int    `json:"CmsNum" xml:"CmsNum"`
	CmsDealedTotalNum int    `json:"CmsDealedTotalNum" xml:"CmsDealedTotalNum"`
	VulDealedTotalNum int    `json:"VulDealedTotalNum" xml:"VulDealedTotalNum"`
	VulAsapSum        int    `json:"VulAsapSum" xml:"VulAsapSum"`
	VulLaterSum       int    `json:"VulLaterSum" xml:"VulLaterSum"`
	VulNntfSum        int    `json:"VulNntfSum" xml:"VulNntfSum"`
}

// CreateDescribeVulNumStatisticsRequest creates a request to invoke DescribeVulNumStatistics API
func CreateDescribeVulNumStatisticsRequest() (request *DescribeVulNumStatisticsRequest) {
	request = &DescribeVulNumStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeVulNumStatistics", "vipaegis", "openAPI")
	return
}

// CreateDescribeVulNumStatisticsResponse creates a response to parse from DescribeVulNumStatistics response
func CreateDescribeVulNumStatisticsResponse() (response *DescribeVulNumStatisticsResponse) {
	response = &DescribeVulNumStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
