package aegis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVulnerabilitySummary invokes the aegis.DescribeVulnerabilitySummary API synchronously
// api document: https://help.aliyun.com/api/aegis/describevulnerabilitysummary.html
func (client *Client) DescribeVulnerabilitySummary(request *DescribeVulnerabilitySummaryRequest) (response *DescribeVulnerabilitySummaryResponse, err error) {
	response = CreateDescribeVulnerabilitySummaryResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVulnerabilitySummaryWithChan invokes the aegis.DescribeVulnerabilitySummary API asynchronously
// api document: https://help.aliyun.com/api/aegis/describevulnerabilitysummary.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVulnerabilitySummaryWithChan(request *DescribeVulnerabilitySummaryRequest) (<-chan *DescribeVulnerabilitySummaryResponse, <-chan error) {
	responseChan := make(chan *DescribeVulnerabilitySummaryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVulnerabilitySummary(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVulnerabilitySummaryWithCallback invokes the aegis.DescribeVulnerabilitySummary API asynchronously
// api document: https://help.aliyun.com/api/aegis/describevulnerabilitysummary.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVulnerabilitySummaryWithCallback(request *DescribeVulnerabilitySummaryRequest, callback func(response *DescribeVulnerabilitySummaryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVulnerabilitySummaryResponse
		var err error
		defer close(result)
		response, err = client.DescribeVulnerabilitySummary(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVulnerabilitySummaryRequest is the request struct for api DescribeVulnerabilitySummary
type DescribeVulnerabilitySummaryRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SourceIp        string           `position:"Query" name:"SourceIp"`
	CronJobId       string           `position:"Query" name:"CronJobId"`
}

// DescribeVulnerabilitySummaryResponse is the response struct for api DescribeVulnerabilitySummary
type DescribeVulnerabilitySummaryResponse struct {
	*responses.BaseResponse
	RequestId       string `json:"RequestId" xml:"RequestId"`
	Success         bool   `json:"Success" xml:"Success"`
	SuggestionCount int    `json:"SuggestionCount" xml:"SuggestionCount"`
	LowCount        int    `json:"LowCount" xml:"LowCount"`
	MediumCount     int    `json:"MediumCount" xml:"MediumCount"`
	HighCount       int    `json:"HighCount" xml:"HighCount"`
	TotalCount      int    `json:"TotalCount" xml:"TotalCount"`
	ConcernCount    int    `json:"ConcernCount" xml:"ConcernCount"`
}

// CreateDescribeVulnerabilitySummaryRequest creates a request to invoke DescribeVulnerabilitySummary API
func CreateDescribeVulnerabilitySummaryRequest() (request *DescribeVulnerabilitySummaryRequest) {
	request = &DescribeVulnerabilitySummaryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("aegis", "2016-11-11", "DescribeVulnerabilitySummary", "vipaegis", "openAPI")
	return
}

// CreateDescribeVulnerabilitySummaryResponse creates a response to parse from DescribeVulnerabilitySummary response
func CreateDescribeVulnerabilitySummaryResponse() (response *DescribeVulnerabilitySummaryResponse) {
	response = &DescribeVulnerabilitySummaryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
