package airec

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QuerySingleReport invokes the airec.QuerySingleReport API synchronously
func (client *Client) QuerySingleReport(request *QuerySingleReportRequest) (response *QuerySingleReportResponse, err error) {
	response = CreateQuerySingleReportResponse()
	err = client.DoAction(request, response)
	return
}

// QuerySingleReportWithChan invokes the airec.QuerySingleReport API asynchronously
func (client *Client) QuerySingleReportWithChan(request *QuerySingleReportRequest) (<-chan *QuerySingleReportResponse, <-chan error) {
	responseChan := make(chan *QuerySingleReportResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QuerySingleReport(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QuerySingleReportWithCallback invokes the airec.QuerySingleReport API asynchronously
func (client *Client) QuerySingleReportWithCallback(request *QuerySingleReportRequest, callback func(response *QuerySingleReportResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QuerySingleReportResponse
		var err error
		defer close(result)
		response, err = client.QuerySingleReport(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QuerySingleReportRequest is the request struct for api QuerySingleReport
type QuerySingleReportRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"instanceId"`
	ReportType string `position:"Query" name:"reportType"`
}

// QuerySingleReportResponse is the response struct for api QuerySingleReport
type QuerySingleReportResponse struct {
	*responses.BaseResponse
	Code      string                 `json:"code" xml:"code"`
	Message   string                 `json:"message" xml:"message"`
	RequestId string                 `json:"requestId" xml:"requestId"`
	Result    map[string]interface{} `json:"result" xml:"result"`
}

// CreateQuerySingleReportRequest creates a request to invoke QuerySingleReport API
func CreateQuerySingleReportRequest() (request *QuerySingleReportRequest) {
	request = &QuerySingleReportRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Airec", "2020-11-26", "QuerySingleReport", "/v2/openapi/instances/[instanceId]/sync-reports/single-report", "airec", "openAPI")
	request.Method = requests.GET
	return
}

// CreateQuerySingleReportResponse creates a response to parse from QuerySingleReport response
func CreateQuerySingleReportResponse() (response *QuerySingleReportResponse) {
	response = &QuerySingleReportResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
