package alb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAclRelations invokes the alb.ListAclRelations API synchronously
func (client *Client) ListAclRelations(request *ListAclRelationsRequest) (response *ListAclRelationsResponse, err error) {
	response = CreateListAclRelationsResponse()
	err = client.DoAction(request, response)
	return
}

// ListAclRelationsWithChan invokes the alb.ListAclRelations API asynchronously
func (client *Client) ListAclRelationsWithChan(request *ListAclRelationsRequest) (<-chan *ListAclRelationsResponse, <-chan error) {
	responseChan := make(chan *ListAclRelationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAclRelations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAclRelationsWithCallback invokes the alb.ListAclRelations API asynchronously
func (client *Client) ListAclRelationsWithCallback(request *ListAclRelationsRequest, callback func(response *ListAclRelationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAclRelationsResponse
		var err error
		defer close(result)
		response, err = client.ListAclRelations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAclRelationsRequest is the request struct for api ListAclRelations
type ListAclRelationsRequest struct {
	*requests.RpcRequest
	AclIds *[]string `position:"Query" name:"AclIds"  type:"Repeated"`
}

// ListAclRelationsResponse is the response struct for api ListAclRelations
type ListAclRelationsResponse struct {
	*responses.BaseResponse
	RequestId    string        `json:"RequestId" xml:"RequestId"`
	AclRelations []AclRelation `json:"AclRelations" xml:"AclRelations"`
}

// CreateListAclRelationsRequest creates a request to invoke ListAclRelations API
func CreateListAclRelationsRequest() (request *ListAclRelationsRequest) {
	request = &ListAclRelationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alb", "2020-06-16", "ListAclRelations", "alb", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAclRelationsResponse creates a response to parse from ListAclRelations response
func CreateListAclRelationsResponse() (response *ListAclRelationsResponse) {
	response = &ListAclRelationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
