package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PausePdnsService invokes the alidns.PausePdnsService API synchronously
func (client *Client) PausePdnsService(request *PausePdnsServiceRequest) (response *PausePdnsServiceResponse, err error) {
	response = CreatePausePdnsServiceResponse()
	err = client.DoAction(request, response)
	return
}

// PausePdnsServiceWithChan invokes the alidns.PausePdnsService API asynchronously
func (client *Client) PausePdnsServiceWithChan(request *PausePdnsServiceRequest) (<-chan *PausePdnsServiceResponse, <-chan error) {
	responseChan := make(chan *PausePdnsServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PausePdnsService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PausePdnsServiceWithCallback invokes the alidns.PausePdnsService API asynchronously
func (client *Client) PausePdnsServiceWithCallback(request *PausePdnsServiceRequest, callback func(response *PausePdnsServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PausePdnsServiceResponse
		var err error
		defer close(result)
		response, err = client.PausePdnsService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PausePdnsServiceRequest is the request struct for api PausePdnsService
type PausePdnsServiceRequest struct {
	*requests.RpcRequest
	ServiceType string `position:"Query" name:"ServiceType"`
	Lang        string `position:"Query" name:"Lang"`
}

// PausePdnsServiceResponse is the response struct for api PausePdnsService
type PausePdnsServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreatePausePdnsServiceRequest creates a request to invoke PausePdnsService API
func CreatePausePdnsServiceRequest() (request *PausePdnsServiceRequest) {
	request = &PausePdnsServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "PausePdnsService", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePausePdnsServiceResponse creates a response to parse from PausePdnsService response
func CreatePausePdnsServiceResponse() (response *PausePdnsServiceResponse) {
	response = &PausePdnsServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
