package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateAntChainContractProject invokes the baas.CreateAntChainContractProject API synchronously
// api document: https://help.aliyun.com/api/baas/createantchaincontractproject.html
func (client *Client) CreateAntChainContractProject(request *CreateAntChainContractProjectRequest) (response *CreateAntChainContractProjectResponse, err error) {
	response = CreateCreateAntChainContractProjectResponse()
	err = client.DoAction(request, response)
	return
}

// CreateAntChainContractProjectWithChan invokes the baas.CreateAntChainContractProject API asynchronously
// api document: https://help.aliyun.com/api/baas/createantchaincontractproject.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAntChainContractProjectWithChan(request *CreateAntChainContractProjectRequest) (<-chan *CreateAntChainContractProjectResponse, <-chan error) {
	responseChan := make(chan *CreateAntChainContractProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateAntChainContractProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateAntChainContractProjectWithCallback invokes the baas.CreateAntChainContractProject API asynchronously
// api document: https://help.aliyun.com/api/baas/createantchaincontractproject.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateAntChainContractProjectWithCallback(request *CreateAntChainContractProjectRequest, callback func(response *CreateAntChainContractProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateAntChainContractProjectResponse
		var err error
		defer close(result)
		response, err = client.CreateAntChainContractProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateAntChainContractProjectRequest is the request struct for api CreateAntChainContractProject
type CreateAntChainContractProjectRequest struct {
	*requests.RpcRequest
	ProjectVersion     string `position:"Body" name:"ProjectVersion"`
	ProjectName        string `position:"Body" name:"ProjectName"`
	ProjectDescription string `position:"Body" name:"ProjectDescription"`
	ConsortiumId       string `position:"Body" name:"ConsortiumId"`
}

// CreateAntChainContractProjectResponse is the response struct for api CreateAntChainContractProject
type CreateAntChainContractProjectResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateCreateAntChainContractProjectRequest creates a request to invoke CreateAntChainContractProject API
func CreateCreateAntChainContractProjectRequest() (request *CreateAntChainContractProjectRequest) {
	request = &CreateAntChainContractProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "CreateAntChainContractProject", "baas", "openAPI")
	return
}

// CreateCreateAntChainContractProjectResponse creates a response to parse from CreateAntChainContractProject response
func CreateCreateAntChainContractProjectResponse() (response *CreateAntChainContractProjectResponse) {
	response = &CreateAntChainContractProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
