package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateFabricOrganization invokes the baas.CreateFabricOrganization API synchronously
// api document: https://help.aliyun.com/api/baas/createfabricorganization.html
func (client *Client) CreateFabricOrganization(request *CreateFabricOrganizationRequest) (response *CreateFabricOrganizationResponse, err error) {
	response = CreateCreateFabricOrganizationResponse()
	err = client.DoAction(request, response)
	return
}

// CreateFabricOrganizationWithChan invokes the baas.CreateFabricOrganization API asynchronously
// api document: https://help.aliyun.com/api/baas/createfabricorganization.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateFabricOrganizationWithChan(request *CreateFabricOrganizationRequest) (<-chan *CreateFabricOrganizationResponse, <-chan error) {
	responseChan := make(chan *CreateFabricOrganizationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateFabricOrganization(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateFabricOrganizationWithCallback invokes the baas.CreateFabricOrganization API asynchronously
// api document: https://help.aliyun.com/api/baas/createfabricorganization.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateFabricOrganizationWithCallback(request *CreateFabricOrganizationRequest, callback func(response *CreateFabricOrganizationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateFabricOrganizationResponse
		var err error
		defer close(result)
		response, err = client.CreateFabricOrganization(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateFabricOrganizationRequest is the request struct for api CreateFabricOrganization
type CreateFabricOrganizationRequest struct {
	*requests.RpcRequest
	Description         string           `position:"Query" name:"Description"`
	SpecName            string           `position:"Query" name:"SpecName"`
	PaymentDuration     requests.Integer `position:"Body" name:"PaymentDuration"`
	OrganizationName    string           `position:"Query" name:"OrganizationName"`
	Domain              string           `position:"Query" name:"Domain"`
	Location            string           `position:"Query" name:"Location"`
	PaymentDurationUnit string           `position:"Body" name:"PaymentDurationUnit"`
	PeersCount          requests.Integer `position:"Body" name:"PeersCount"`
}

// CreateFabricOrganizationResponse is the response struct for api CreateFabricOrganization
type CreateFabricOrganizationResponse struct {
	*responses.BaseResponse
	RequestId string                           `json:"RequestId" xml:"RequestId"`
	Success   bool                             `json:"Success" xml:"Success"`
	ErrorCode int                              `json:"ErrorCode" xml:"ErrorCode"`
	Result    ResultInCreateFabricOrganization `json:"Result" xml:"Result"`
}

// CreateCreateFabricOrganizationRequest creates a request to invoke CreateFabricOrganization API
func CreateCreateFabricOrganizationRequest() (request *CreateFabricOrganizationRequest) {
	request = &CreateFabricOrganizationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "CreateFabricOrganization", "baas", "openAPI")
	return
}

// CreateCreateFabricOrganizationResponse creates a response to parse from CreateFabricOrganization response
func CreateCreateFabricOrganizationResponse() (response *CreateFabricOrganizationResponse) {
	response = &CreateFabricOrganizationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
