package cdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCdnMonitorData invokes the cdn.DescribeCdnMonitorData API synchronously
func (client *Client) DescribeCdnMonitorData(request *DescribeCdnMonitorDataRequest) (response *DescribeCdnMonitorDataResponse, err error) {
	response = CreateDescribeCdnMonitorDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCdnMonitorDataWithChan invokes the cdn.DescribeCdnMonitorData API asynchronously
func (client *Client) DescribeCdnMonitorDataWithChan(request *DescribeCdnMonitorDataRequest) (<-chan *DescribeCdnMonitorDataResponse, <-chan error) {
	responseChan := make(chan *DescribeCdnMonitorDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCdnMonitorData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCdnMonitorDataWithCallback invokes the cdn.DescribeCdnMonitorData API asynchronously
func (client *Client) DescribeCdnMonitorDataWithCallback(request *DescribeCdnMonitorDataRequest, callback func(response *DescribeCdnMonitorDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCdnMonitorDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeCdnMonitorData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCdnMonitorDataRequest is the request struct for api DescribeCdnMonitorData
type DescribeCdnMonitorDataRequest struct {
	*requests.RpcRequest
	StartTime  string           `position:"Query" name:"StartTime"`
	DomainName string           `position:"Query" name:"DomainName"`
	EndTime    string           `position:"Query" name:"EndTime"`
	OwnerId    requests.Integer `position:"Query" name:"OwnerId"`
	Interval   string           `position:"Query" name:"Interval"`
}

// DescribeCdnMonitorDataResponse is the response struct for api DescribeCdnMonitorData
type DescribeCdnMonitorDataResponse struct {
	*responses.BaseResponse
	RequestId       string       `json:"RequestId" xml:"RequestId"`
	DomainName      string       `json:"DomainName" xml:"DomainName"`
	StartTime       string       `json:"StartTime" xml:"StartTime"`
	EndTime         string       `json:"EndTime" xml:"EndTime"`
	MonitorInterval string       `json:"MonitorInterval" xml:"MonitorInterval"`
	MonitorDatas    MonitorDatas `json:"MonitorDatas" xml:"MonitorDatas"`
}

// CreateDescribeCdnMonitorDataRequest creates a request to invoke DescribeCdnMonitorData API
func CreateDescribeCdnMonitorDataRequest() (request *DescribeCdnMonitorDataRequest) {
	request = &DescribeCdnMonitorDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cdn", "2014-11-11", "DescribeCdnMonitorData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeCdnMonitorDataResponse creates a response to parse from DescribeCdnMonitorData response
func CreateDescribeCdnMonitorDataResponse() (response *DescribeCdnMonitorDataResponse) {
	response = &DescribeCdnMonitorDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
