package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVehicleTrack invokes the cdrs.ListVehicleTrack API synchronously
func (client *Client) ListVehicleTrack(request *ListVehicleTrackRequest) (response *ListVehicleTrackResponse, err error) {
	response = CreateListVehicleTrackResponse()
	err = client.DoAction(request, response)
	return
}

// ListVehicleTrackWithChan invokes the cdrs.ListVehicleTrack API asynchronously
func (client *Client) ListVehicleTrackWithChan(request *ListVehicleTrackRequest) (<-chan *ListVehicleTrackResponse, <-chan error) {
	responseChan := make(chan *ListVehicleTrackResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVehicleTrack(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVehicleTrackWithCallback invokes the cdrs.ListVehicleTrack API asynchronously
func (client *Client) ListVehicleTrackWithCallback(request *ListVehicleTrackRequest, callback func(response *ListVehicleTrackResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVehicleTrackResponse
		var err error
		defer close(result)
		response, err = client.ListVehicleTrack(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVehicleTrackRequest is the request struct for api ListVehicleTrack
type ListVehicleTrackRequest struct {
	*requests.RpcRequest
	PlateId    string           `position:"Body" name:"PlateId"`
	CorpId     string           `position:"Body" name:"CorpId"`
	EndTime    string           `position:"Body" name:"EndTime"`
	StartTime  string           `position:"Body" name:"StartTime"`
	PageNumber requests.Integer `position:"Body" name:"PageNumber"`
	PageSize   requests.Integer `position:"Body" name:"PageSize"`
}

// ListVehicleTrackResponse is the response struct for api ListVehicleTrack
type ListVehicleTrackResponse struct {
	*responses.BaseResponse
	Code       string  `json:"Code" xml:"Code"`
	Message    string  `json:"Message" xml:"Message"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	PageNumber int64   `json:"PageNumber" xml:"PageNumber"`
	PageSize   int64   `json:"PageSize" xml:"PageSize"`
	TotalCount int64   `json:"TotalCount" xml:"TotalCount"`
	Data       []Datas `json:"Data" xml:"Data"`
}

// CreateListVehicleTrackRequest creates a request to invoke ListVehicleTrack API
func CreateListVehicleTrackRequest() (request *ListVehicleTrackRequest) {
	request = &ListVehicleTrackRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "ListVehicleTrack", "", "")
	request.Method = requests.POST
	return
}

// CreateListVehicleTrackResponse creates a response to parse from ListVehicleTrack response
func CreateListVehicleTrackResponse() (response *ListVehicleTrackResponse) {
	response = &ListVehicleTrackResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
