package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeVnRedirection invokes the cloudcallcenter.DescribeVnRedirection API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevnredirection.html
func (client *Client) DescribeVnRedirection(request *DescribeVnRedirectionRequest) (response *DescribeVnRedirectionResponse, err error) {
	response = CreateDescribeVnRedirectionResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeVnRedirectionWithChan invokes the cloudcallcenter.DescribeVnRedirection API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevnredirection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVnRedirectionWithChan(request *DescribeVnRedirectionRequest) (<-chan *DescribeVnRedirectionResponse, <-chan error) {
	responseChan := make(chan *DescribeVnRedirectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeVnRedirection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeVnRedirectionWithCallback invokes the cloudcallcenter.DescribeVnRedirection API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/describevnredirection.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeVnRedirectionWithCallback(request *DescribeVnRedirectionRequest, callback func(response *DescribeVnRedirectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeVnRedirectionResponse
		var err error
		defer close(result)
		response, err = client.DescribeVnRedirection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeVnRedirectionRequest is the request struct for api DescribeVnRedirection
type DescribeVnRedirectionRequest struct {
	*requests.RpcRequest
	InstanceId         string `position:"Query" name:"InstanceId"`
	NavigationScriptId string `position:"Query" name:"NavigationScriptId"`
}

// DescribeVnRedirectionResponse is the response struct for api DescribeVnRedirection
type DescribeVnRedirectionResponse struct {
	*responses.BaseResponse
	RequestId          string   `json:"RequestId" xml:"RequestId"`
	InstanceId         string   `json:"InstanceId" xml:"InstanceId"`
	CategoryId         string   `json:"CategoryId" xml:"CategoryId"`
	NavigationScriptId string   `json:"NavigationScriptId" xml:"NavigationScriptId"`
	UserUtterance      string   `json:"UserUtterance" xml:"UserUtterance"`
	Prompt             string   `json:"Prompt" xml:"Prompt"`
	Interruptible      bool     `json:"Interruptible" xml:"Interruptible"`
	RedirectionType    string   `json:"RedirectionType" xml:"RedirectionType"`
	RedirectionTarget  string   `json:"RedirectionTarget" xml:"RedirectionTarget"`
	SimilarUtterances  []string `json:"SimilarUtterances" xml:"SimilarUtterances"`
}

// CreateDescribeVnRedirectionRequest creates a request to invoke DescribeVnRedirection API
func CreateDescribeVnRedirectionRequest() (request *DescribeVnRedirectionRequest) {
	request = &DescribeVnRedirectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "DescribeVnRedirection", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeVnRedirectionResponse creates a response to parse from DescribeVnRedirection response
func CreateDescribeVnRedirectionResponse() (response *DescribeVnRedirectionResponse) {
	response = &DescribeVnRedirectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
